<?php include('../header.php') ?>




    
    <section class="hero-mini-banner" style="
        background: url(../assets/img/about-bg.png) no-repeat;
        background-size: cover;
        background-position: center;
      ">
        <div class="container">
            <div class="banner-content">
                <h1 class="text-white display-2 font-weight-bold mb-3">
                    Who We Are
                </h1>
                <p class="text-white">
                    We are a leading global financial experts who provide market
                    opportunities to our clients. We have been continuously developing
                    our trading platform so that traders can feel comfortable while
                    trading
                </p>
            </div>
        </div>
    </section>
    

    
    <section class="about-1-section theme-padding">
        <div class="container">
            <div class="row align-items-center">
                <div class="col-sm-6">
                    <div class="content-box">
                        <h2 class="display-4 font-weight-bold mb-3">Welcome to Wizense</h2>
                        <p class="text-grey-500 text-lead">
                            Wizense is an international forex organization offering its
                            clients direct access to the significant world stocks and
                            currency markets. Our Company is built on the pedestal of
                            Transparency, Reliance & trust.
                        </p>
                        <ul class="pl-0 mt-4 text-lead">
                            <li>
                                Worldwide Trust and Reliance
                            </li>
                            <li>
                                Expansive Spectrum of Global Markets
                            </li>
                            <li>
                                Quick and Transparent Execution
                            </li>
                            <li>
                                The Ultimate Client Support
                            </li>
                        </ul>
                    </div>
                </div>
                <div class="col-sm-6">
                    <div class="img-box">
                        <img src="../assets/img/welcome-mtfxg.png" class="img-fluid" alt="Welcome Wizense" />
                    </div>
                </div>
            </div>
        </div>
    </section>
    

    
    <section class="why-choose-us theme-padding" style="
        background: url(../assets/img/about-choose-us-bg.png) no-repeat;
        background-size: cover;
        background-position: center;
      ">
        <div class="container">
            <div class="title text-center">
                <h2 class="display-3 font-weight-bold mb-4">Why Choose Us</h2>
                <p class="text-grey-500 text-lead">
                    Unlock a Lot More with a Forex and CFD Trading Account!
                </p>
            </div>
            <div class="features-box">
                <div class="row">
                    <div class="col-md-3 col-sm-6 col-6 text-center box mb-5">
                        <div class="icon">
                            <svg width="63" height="64" viewBox="0 0 63 64" fill="none" xmlns="http://www.w3.org/2000/svg">
                                <path d="M31.3 62.7749C48.1 62.7749 61.8 49.0749 61.8 32.2749C61.8 15.4749 48.1 1.7749 31.3 1.7749C14.5 1.7749 0.800049 15.4749 0.800049 32.2749C0.800049 49.0749 14.5 62.7749 31.3 62.7749Z" stroke="#667B91" stroke-width="1.6" stroke-miterlimit="10" />
                                <path d="M6.5 19.075L16.2 28.775L16 23.175H26.6C27.8 23.175 28.8 22.375 29.1 21.275C29.1 20.875 29.4 20.475 29.9 20.475H32.6C33 20.475 33.4 20.775 33.4 21.275V22.475C33.4 22.775 33.7 23.075 34 23.175C34.6 23.375 35.3 23.575 35.8 23.975C36.1 24.175 36.5 24.075 36.7 23.875L37.5 23.075C37.8 22.775 38.3 22.775 38.6 23.075L40.5 24.975C40.8 25.275 40.8 25.775 40.5 26.075L39.7 26.875C39.5 27.075 39.4 27.475 39.6 27.775C39.9 28.375 40.2 28.975 40.4 29.675C40.5 29.975 40.8 30.275 41.1 30.275H42.2C42.6 30.275 43 30.575 43 31.075V33.775C43 34.175 42.7 34.5749 42.2 34.5749H41.1C40.8 34.5749 40.5 34.875 40.4 35.175C40.2 35.875 39.9 36.4749 39.6 37.0749C39.4 37.3749 39.5 37.775 39.7 37.975L40.5 38.775" stroke="#83d030" stroke-width="1.6" stroke-miterlimit="10" />
                                <path d="M47.4 32.2749C47.4 23.3749 40.2 16.0749 31.2 16.0749H16.2V9.2749L6.5 18.9749" stroke="url(#paint0_linear_2_591)" stroke-width="1.6" />
                                <path d="M31.3 36.7749C33.8 36.7749 35.8 34.7749 35.8 32.2749C35.8 29.7749 33.8 27.7749 31.3 27.7749C28.8 27.7749 26.8 29.7749 26.8 32.2749C26.8 34.7749 28.8 36.7749 31.3 36.7749Z" stroke="#83d030" stroke-width="1.6" stroke-miterlimit="10" />
                                <path d="M55.7001 45.5749L46.0001 35.8749L46.2001 41.3749H35.6001C34.4001 41.3749 33.4001 42.1749 33.1001 43.2749C33.1001 43.6749 32.8001 44.0749 32.3001 44.0749H29.6001C29.2001 44.0749 28.8001 43.7749 28.8001 43.2749V42.0749C28.8001 41.7749 28.5001 41.4749 28.2001 41.3749C27.6001 41.1749 26.9001 40.9749 26.4001 40.5749C26.1001 40.3749 25.7001 40.4749 25.5001 40.6749L24.7001 41.4749C24.4001 41.7749 23.9001 41.7749 23.6001 41.4749L21.7001 39.5749C21.4001 39.2749 21.4001 38.7749 21.7001 38.4749L22.5001 37.6749C22.7001 37.4749 22.8001 37.0749 22.6001 36.7749C22.3001 36.1749 22.0001 35.5749 21.8001 34.8749C21.7001 34.5749 21.4001 34.2749 21.1001 34.2749H20.0001C19.6001 34.2749 19.2001 33.9749 19.2001 33.4749V30.9749C19.2001 30.5749 19.5001 30.1749 20.0001 30.1749H21.1001C21.4001 30.1749 21.7001 29.8749 21.8001 29.5749C22.0001 28.8749 22.3001 28.2749 22.6001 27.6749C22.8001 27.3749 22.7001 26.9749 22.5001 26.7749L21.7001 25.9749" stroke="#83d030" stroke-width="1.6" stroke-miterlimit="10" />
                                <path d="M14.8 32.2749C14.8 41.1749 22 48.4749 31 48.4749H46V55.2749L55.7001 45.5749" stroke="url(#paint1_linear_2_591)" stroke-width="1.6" />
                                <path d="M31 27.7749C28.5 27.7749 26.5 29.7749 26.5 32.2749C26.5 34.7749 28.5 36.7749 31 36.7749C33.5 36.7749 35.5 34.7749 35.5 32.2749C35.5 29.7749 33.5 27.7749 31 27.7749Z" stroke="#83d030" stroke-width="1.6" stroke-miterlimit="10" />
                                <defs>
                                    <linearGradient id="paint0_linear_2_591" x1="5.93194" y1="18.8582" x2="48.2745" y2="11.7356" gradientUnits="userSpaceOnUse">
                                        <stop stop-color="#667B91" />
                                        <stop offset="1" stop-color="#667B91" stop-opacity="0" />
                                    </linearGradient>
                                    <linearGradient id="paint1_linear_2_591" x1="14.232" y1="41.8582" x2="56.5746" y2="34.7356" gradientUnits="userSpaceOnUse">
                                        <stop stop-color="#667B91" stop-opacity="0" />
                                        <stop offset="0.619792" stop-color="#667B91" />
                                    </linearGradient>
                                </defs>
                            </svg>
                        </div>
                        <div class="text">
                            Exceptional Trading tools
                        </div>
                    </div>
                    <div class="col-md-3 col-sm-6 col-6 text-center box mb-5">
                        <div class="icon">
                            <svg width="63" height="64" viewBox="0 0 63 64" fill="none" xmlns="http://www.w3.org/2000/svg">
                                <path d="M31.3 62.7749C48.1 62.7749 61.8 49.0749 61.8 32.2749C61.8 15.4749 48.1 1.7749 31.3 1.7749C14.5 1.7749 0.800049 15.4749 0.800049 32.2749C0.800049 49.0749 14.5 62.7749 31.3 62.7749Z" stroke="#667B91" stroke-width="1.6" stroke-miterlimit="10" />
                                <path d="M16 41.575C19.1 46.675 24.8 50.175 31.3 50.175C38 50.175 43.8 46.475 46.9 41.075" stroke="url(#paint0_linear_2_601)" stroke-width="1.6" />
                                <path d="M47.0001 23.775C44.0001 18.175 38.1001 14.375 31.3001 14.375C24.6001 14.375 18.8001 18.075 15.7001 23.475" stroke="url(#paint1_linear_2_601)" stroke-width="1.6" />
                                <path d="M26.3001 23.9749C23.5001 25.6749 21.6001 28.7749 21.6001 32.2749C21.6001 35.8749 23.6001 39.0749 26.5001 40.7749" stroke="#83d030" stroke-width="1.6" stroke-miterlimit="10" />
                                <path d="M36 40.7748C39 39.1748 41.1 35.8748 41.1 32.1748C41.1 28.5748 39.1 25.3748 36.1 23.6748" stroke="#83d030" stroke-width="1.6" stroke-miterlimit="10" />
                                <path d="M50.8 41.175H11.8C10.5 41.175 9.40002 40.075 9.40002 38.775V25.775C9.40002 24.475 10.5 23.375 11.8 23.375H50.9C52.2 23.375 53.3 24.475 53.3 25.775V38.775C53.2 40.075 52.1 41.175 50.8 41.175Z" stroke="#83d030" stroke-width="1.6" stroke-miterlimit="10" />
                                <path d="M28.9 33.975C28.9 35.175 29.9 36.275 31.3 36.275C32.7 36.275 33.7 35.275 33.7 33.975C33.7 32.775 32.7 32.075 31.3 31.675C29.9 31.275 28.9 30.675 28.9 29.375C28.9 28.175 29.9 27.075 31.3 27.075C32.7 27.075 33.7 28.075 33.7 29.375" stroke="#83d030" stroke-width="1.6" stroke-miterlimit="10" />
                                <path d="M31.3 25.4749V37.9749" stroke="#83d030" stroke-width="1.6" stroke-miterlimit="10" />
                                <defs>
                                    <linearGradient id="paint0_linear_2_601" x1="15.5708" y1="44.8666" x2="45.3894" y2="35.2887" gradientUnits="userSpaceOnUse">
                                        <stop stop-color="#667B91" stop-opacity="0" />
                                        <stop offset="1" stop-color="#667B91" />
                                    </linearGradient>
                                    <linearGradient id="paint1_linear_2_601" x1="15.2654" y1="18.2917" x2="45.5788" y2="8.74355" gradientUnits="userSpaceOnUse">
                                        <stop stop-color="#667B91" />
                                        <stop offset="1" stop-color="#667B91" stop-opacity="0" />
                                    </linearGradient>
                                </defs>
                            </svg>
                        </div>
                        <div class="text">
                            Multiple Payment Methods
                        </div>
                    </div>
                    <div class="col-md-3 col-sm-6 col-6 text-center box mb-5">
                        <div class="icon">
                            <svg width="63" height="64" viewBox="0 0 63 64" fill="none" xmlns="http://www.w3.org/2000/svg">
                                <path d="M31.5 62.7749C48.3 62.7749 62 49.0749 62 32.2749C62 15.4749 48.3 1.7749 31.5 1.7749C14.7 1.7749 1 15.4749 1 32.2749C1 49.0749 14.7 62.7749 31.5 62.7749Z" stroke="#667B91" stroke-width="1.6" stroke-miterlimit="10" />
                                <path d="M19.6 45.675C22.8 48.475 26.9 50.175 31.5 50.175C36.1 50.175 40.3 48.475 43.5 45.575" stroke="url(#paint0_linear_2_613)" stroke-width="1.6" />
                                <path d="M46.8 41.575C48.4 38.875 49.4 35.675 49.4 32.275C49.4 22.375 41.4 14.375 31.5 14.375C21.6 14.375 13.6 22.375 13.6 32.275C13.6 35.775 14.6 38.975 16.3 41.675" stroke="url(#paint1_linear_2_613)" stroke-width="1.6" />
                                <path d="M34.2 32.8749L37.4 28.2749" stroke="#83d030" stroke-width="1.2541" stroke-miterlimit="10" />
                                <path d="M30.2 31.175L32.9 33.075" stroke="#83d030" stroke-width="1.2541" stroke-miterlimit="10" />
                                <path d="M25.6 36.875L28.9 31.375" stroke="#83d030" stroke-width="1.2541" stroke-miterlimit="10" />
                                <path d="M33.7 34.675C34.2522 34.675 34.7 34.2273 34.7 33.675C34.7 33.1228 34.2522 32.675 33.7 32.675C33.1477 32.675 32.7 33.1228 32.7 33.675C32.7 34.2273 33.1477 34.675 33.7 34.675Z" stroke="#83d030" stroke-width="1.2541" stroke-miterlimit="10" />
                                <path d="M29.4 31.575C29.9523 31.575 30.4 31.1272 30.4 30.575C30.4 30.0227 29.9523 29.575 29.4 29.575C28.8477 29.575 28.4 30.0227 28.4 30.575C28.4 31.1272 28.8477 31.575 29.4 31.575Z" stroke="#83d030" stroke-width="1.2541" stroke-miterlimit="10" />
                                <path d="M25.1 38.7749C25.6523 38.7749 26.1 38.3272 26.1 37.7749C26.1 37.2226 25.6523 36.7749 25.1 36.7749C24.5477 36.7749 24.1 37.2226 24.1 37.7749C24.1 38.3272 24.5477 38.7749 25.1 38.7749Z" stroke="#83d030" stroke-width="1.2541" stroke-miterlimit="10" />
                                <path d="M37.9 28.375C38.4523 28.375 38.9 27.9273 38.9 27.375C38.9 26.8227 38.4523 26.375 37.9 26.375C37.3477 26.375 36.9 26.8227 36.9 27.375C36.9 27.9273 37.3477 28.375 37.9 28.375Z" stroke="#83d030" stroke-width="1.2541" stroke-miterlimit="10" />
                                <path d="M33.9 21.475H29C28.6 21.475 28.3 21.175 28.3 20.775V19.775C28.3 19.375 28.6 19.075 29 19.075H33.9C34.3 19.075 34.6 19.375 34.6 19.775V20.775C34.6 21.175 34.3 21.475 33.9 21.475Z" stroke="#83d030" stroke-width="1.2541" stroke-miterlimit="10" />
                                <path d="M44.5 41.4749H18.5C18.1 41.4749 17.8 41.1749 17.8 40.7749V22.1749C17.8 21.7749 18.1 21.4749 18.5 21.4749H44.5C44.9 21.4749 45.2 21.7749 45.2 22.1749V40.7749C45.2 41.1749 44.9 41.4749 44.5 41.4749Z" stroke="#83d030" stroke-width="1.2541" stroke-miterlimit="10" />
                                <path d="M46.4 45.4749H16.6C16.2 45.4749 15.9 45.1749 15.9 44.7749V42.1749C15.9 41.7749 16.2 41.4749 16.6 41.4749H46.4C46.8 41.4749 47.1 41.7749 47.1 42.1749V44.7749C47.1 45.1749 46.8 45.4749 46.4 45.4749Z" stroke="#83d030" stroke-width="1.2541" stroke-miterlimit="10" />
                                <defs>
                                    <linearGradient id="paint0_linear_2_613" x1="43.5" y1="45.575" x2="20.3729" y2="54.9226" gradientUnits="userSpaceOnUse">
                                        <stop stop-color="#667B91" />
                                        <stop offset="1" stop-color="#667B91" stop-opacity="0" />
                                    </linearGradient>
                                    <linearGradient id="paint1_linear_2_613" x1="16.8504" y1="45.4217" x2="46.1227" y2="46.3237" gradientUnits="userSpaceOnUse">
                                        <stop stop-color="#667B91" />
                                        <stop offset="1" stop-color="#667B91" stop-opacity="0" />
                                    </linearGradient>
                                </defs>
                            </svg>
                        </div>
                        <div class="text">
                            Trading guides & Education
                        </div>
                    </div>
                    <div class="col-md-3 col-sm-6 col-6 text-center box mb-5">
                        <div class="icon">
                            <svg width="64" height="64" viewBox="0 0 64 64" fill="none" xmlns="http://www.w3.org/2000/svg">
                                <path d="M31.9998 62.7749C48.7998 62.7749 62.4998 49.0749 62.4998 32.2749C62.4998 15.4749 48.7998 1.7749 31.9998 1.7749C15.1998 1.7749 1.49976 15.4749 1.49976 32.2749C1.49976 49.0749 15.1998 62.7749 31.9998 62.7749Z" stroke="#667B91" stroke-width="1.6" stroke-miterlimit="10" />
                                <path d="M44.2997 45.275C47.6997 41.975 49.8997 37.3749 49.8997 32.275C49.8997 27.275 47.8997 22.775 44.5997 19.575" stroke="#667B91" stroke-width="1.6" stroke-miterlimit="10" />
                                <path d="M19.3997 19.575C16.0997 22.775 14.0997 27.275 14.0997 32.275C14.0997 37.175 16.0997 41.675 19.2997 44.875" stroke="#667B91" stroke-width="1.6" stroke-miterlimit="10" />
                                <path d="M21.0998 51.475H42.7998C43.6998 51.475 44.4998 50.6749 44.4998 49.7749V14.775C44.4998 13.875 43.6998 13.075 42.7998 13.075H24.1998C22.2998 14.975 21.2998 15.975 19.3998 17.875V49.7749C19.4998 50.6749 20.1998 51.475 21.0998 51.475Z" stroke="#83d030" stroke-width="1.6" stroke-miterlimit="10" />
                                <path d="M30.1996 21.075H40.4996" stroke="#83d030" stroke-width="1.6" stroke-miterlimit="10" />
                                <path d="M23.6997 26.9749H40.4997" stroke="#83d030" stroke-width="1.6" stroke-miterlimit="10" />
                                <path d="M23.6997 32.7749H40.4997" stroke="#83d030" stroke-width="1.6" stroke-miterlimit="10" />
                                <path d="M23.6997 38.6748H40.4997" stroke="#83d030" stroke-width="1.6" stroke-miterlimit="10" />
                                <path d="M23.6997 44.575H40.4997" stroke="#83d030" stroke-width="1.6" stroke-miterlimit="10" />
                            </svg>
                        </div>
                        <div class="text">
                            Daily market news
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
    

    
   <!-- <section class="about-ceo theme-padding">
        <div class="container">
            <div class="row align-items-center">
                <div class="col-sm-4 mb-sm-0 mb-4">
                    <div class="img-box text-sm-left text-center">
                        <img src="../assets/img/about-ceo-img.png" class="img-fluid" alt="CEO Image" />
                    </div>
                    <div class="name-box text-center">
                        <h2 class="font-weight-bold">Despo Tsialoupi</h2>
                        <p class="text-grey-500 font-weight-bold">CEO, Wizense</p>
                    </div>
                </div>
                <div class="col-sm-8">
                    <div class="content pl-md-5 ml-md-4">
                        <h2 class="display-3 font-weight-bold mb-4">About CEO</h2>
                        <p class="text-grey-500 mb-4 font16">
                            <b>Despo Tsialoupi</b> leads the company's international
                            operations, with the responsibility for business across Asia,
                            Europe, & Latin America. She also oversees the company's ongoing
                            efforts in the emerging trading markets.
                        </p>
                        <p class="text-grey-500 mb-4 font16">
                            After graduating from
                            <b>The University of Salford UK in Business Management</b>,
                            inspired to make a difference in the financial market, she
                            decided to turn her eyes towards the Foreign exchange market.
                            For many years, she learned the meticulous intricacies of the
                            trading world & gained expertise & certitude in rendering
                            sybarite trading experience to the traders.
                        </p>
                        <p class="text-grey-500 mb-4 font16">
                            While at <b>Wizense</b>, Despo led the company's core execution
                            operations; she aims to bring suaveness by providing an eclectic
                            trading platform to the users.
                        </p>
                        <p class="text-grey-500 font16">
                            <b>As Despo Tsialoupi states</b>, "I believe that each trader &
                            investor must be bolstered with the assiduous tools to reach the
                            apex of their Trading potential, which is what we strive to
                            achieve with Wizense."
                        </p>
                    </div>
                </div>
            </div>
        </div>
    </section> -->
    <section class="about-benefits theme-padding">
        <div class="container">
            <div class="title text-center">
                <h2 class="display-3 font-weight-bold mb-4">
                    Benefits of Trading with Wizense
                </h2>
                <p class="text-grey-500 text-lead">
                    Our Company provides a wide array of trading services.
                </p>
            </div>
            <div class="benefits-grid">
                <div class="row">
                    <div class="col-sm-4">
                        <div class="benefit-box text-center">
                            <div class="icon">
                                <svg width="64" height="63" viewBox="0 0 64 63" fill="none" xmlns="http://www.w3.org/2000/svg">
                                    <path d="M32 61.8096C48.8447 61.8096 62.5 48.1543 62.5 31.3096C62.5 14.4649 48.8447 0.80957 32 0.80957C15.1553 0.80957 1.5 14.4649 1.5 31.3096C1.5 48.1543 15.1553 61.8096 32 61.8096Z" stroke="#667B91" stroke-width="1.6" stroke-miterlimit="10" />
                                    <path d="M13.8499 31.4595C13.8499 21.5595 21.9499 13.4595 31.8499 13.4595C41.7499 13.4595 49.8499 21.5595 49.8499 31.4595L49.8499 39.8906" stroke="url(#paint0_linear_2_661)" stroke-width="1.6" />
                                    <path d="M49.8499 31.4595C49.8499 41.3595 41.7499 49.4595 31.8499 49.4595C21.9499 49.4595 13.8499 41.3595 13.8499 31.4595" stroke="url(#paint1_linear_2_661)" stroke-width="1.6" />
                                    <path d="M27.2 35.9096C27.2 38.4096 29.3 40.5096 32 40.5096C34.7 40.5096 36.7999 38.4096 36.7999 35.9096C36.7999 33.4096 34.7 32.0096 32 31.3096C29.3 30.6096 27.2 29.2096 27.2 26.7096C27.2 24.2096 29.3 22.1096 32 22.1096C34.7 22.1096 36.7999 24.2096 36.7999 26.7096" stroke="#83d030" stroke-width="1.6" stroke-miterlimit="10" />
                                    <path d="M31.9999 18.6096V44.0096" stroke="#83d030" stroke-width="1.6" stroke-miterlimit="10" />
                                    <path d="M49.7999 39.4902L49.7999 47.2982" stroke="#788A9E" stroke-width="1.6" stroke-miterlimit="10" />
                                    <path d="M54.3999 42.898L49.7999 47.398L45.2999 42.898" stroke="#788A9E" stroke-width="1.6" stroke-miterlimit="10" />
                                    <defs>
                                        <linearGradient id="paint0_linear_2_661" x1="13.3499" y1="20.9595" x2="50.3499" y2="13.9595" gradientUnits="userSpaceOnUse">
                                            <stop stop-color="#667B91" stop-opacity="0" />
                                            <stop offset="1" stop-color="#667B91" />
                                        </linearGradient>
                                        <linearGradient id="paint1_linear_2_661" x1="13.3499" y1="38.9595" x2="50.3499" y2="31.9595" gradientUnits="userSpaceOnUse">
                                            <stop stop-color="#667B91" />
                                            <stop offset="1" stop-color="#667B91" stop-opacity="0" />
                                        </linearGradient>
                                    </defs>
                                </svg>
                            </div>
                            <div class="content">
                                <h2 class="font-weight-bold font24">Low trading cost</h2>
                                <p class="text-grey-500">
                                    Trade at lowest price with high profit margins.
                                </p>
                            </div>
                        </div>
                    </div>
                    <div class="col-sm-4">
                        <div class="benefit-box text-center">
                            <div class="icon">
                                <svg width="63" height="63" viewBox="0 0 63 63" fill="none" xmlns="http://www.w3.org/2000/svg">
                                    <path d="M31.5 61.8096C48.3 61.8096 62 48.1096 62 31.3096C62 14.5096 48.3 0.80957 31.5 0.80957C14.7 0.80957 1 14.5096 1 31.3096C1 48.1096 14.7 61.8096 31.5 61.8096Z" stroke="#667B91" stroke-width="1.6" stroke-miterlimit="10" />
                                    <path d="M29 48.9096C20.3 47.7096 13.7 40.2096 13.7 31.2096C13.7 23.6096 18.5 17.1096 25.2 14.5096" stroke="url(#paint0_linear_2_700)" stroke-width="1.6" />
                                    <path d="M37.2999 14.3096C44.2999 16.7096 49.2999 23.4096 49.2999 31.2096C49.2999 39.8096 43.2 47.0096 35.2 48.7096" stroke="url(#paint1_linear_2_700)" stroke-width="1.6" />
                                    <path d="M39.7 37.2096C39.7 37.2096 39.7 31.7096 39.7 21.9096C39.7 12.1096 31.6 9.40958 31.6 9.40958C31.6 9.40958 23.5 12.2096 23.5 21.9096C23.5 31.6096 23.5 37.2096 23.5 37.2096H39.7Z" stroke="#83d030" stroke-width="1.6" stroke-miterlimit="10" />
                                    <path d="M31.3 22.3096C32.9569 22.3096 34.3 20.9664 34.3 19.3096C34.3 17.6527 32.9569 16.3096 31.3 16.3096C29.6432 16.3096 28.3 17.6527 28.3 19.3096C28.3 20.9664 29.6432 22.3096 31.3 22.3096Z" stroke="#83d030" stroke-width="1.6" stroke-miterlimit="10" />
                                    <path d="M31.3 37.0096V31.4096" stroke="#83d030" stroke-width="1.6" stroke-miterlimit="10" />
                                    <path d="M37.3 37.1096L35.8 40.7096H27.3L25.8 37.1096" stroke="#83d030" stroke-width="1.6" stroke-miterlimit="10" />
                                    <path d="M29.4 42.9096V50.2096" stroke="#83d030" stroke-width="1.6" stroke-miterlimit="10" />
                                    <path d="M32 42.9096V46.5096" stroke="#83d030" stroke-width="1.6" stroke-miterlimit="10" />
                                    <path d="M34.9 42.8096V56.2096" stroke="#83d030" stroke-width="1.6" stroke-miterlimit="10" />
                                    <path d="M39.5 34.2096L44.9 39.7096V31.9096L39.5 24.8096" stroke="#83d030" stroke-width="1.6" stroke-miterlimit="10" />
                                    <path d="M23.3 34.2096L18 39.7096V31.9096L23.3 24.8096" stroke="#83d030" stroke-width="1.6" stroke-miterlimit="10" />
                                    <defs>
                                        <linearGradient id="paint0_linear_2_700" x1="29" y1="48.9095" x2="45.3546" y2="28.2334" gradientUnits="userSpaceOnUse">
                                            <stop stop-color="#667B91" />
                                            <stop offset="1" stop-color="#667B91" stop-opacity="0" />
                                        </linearGradient>
                                        <linearGradient id="paint1_linear_2_700" x1="38.9511" y1="14.3096" x2="19.8345" y2="37.7845" gradientUnits="userSpaceOnUse">
                                            <stop stop-color="#667B91" />
                                            <stop offset="1" stop-color="#667B91" stop-opacity="0" />
                                        </linearGradient>
                                    </defs>
                                </svg>
                            </div>
                            <div class="content">
                                <h2 class="font-weight-bold font24">Exceptional Speed</h2>
                                <p class="text-grey-500">
                                    Experience unbeatable super fast trading.
                                </p>
                            </div>
                        </div>
                    </div>
                    <div class="col-sm-4">
                        <div class="benefit-box text-center">
                            <div class="icon">
                                <svg width="63" height="63" viewBox="0 0 63 63" fill="none" xmlns="http://www.w3.org/2000/svg">
                                    <path d="M31.3 61.8C48.1 61.8 61.8 48.1 61.8 31.3C61.8 14.5 48.1 0.799988 31.3 0.799988C14.5 0.799988 0.800049 14.5 0.800049 31.3C0.800049 48.1 14.5 61.8 31.3 61.8Z" stroke="#667B91" stroke-width="1.6" stroke-miterlimit="10" />
                                    <path d="M31.3001 41.8258C37.1134 41.8258 41.826 37.1132 41.826 31.2999C41.826 25.4866 37.1134 20.774 31.3001 20.774C25.4868 20.774 20.7742 25.4866 20.7742 31.2999C20.7742 37.1132 25.4868 41.8258 31.3001 41.8258Z" stroke="#667B91" stroke-width="1.6" stroke-miterlimit="10" />
                                    <path d="M42.5 18.2L42.7 19C43 20.7 44.1 22.1 45.6 22.8L46.3 23.2C49.5 24.8 50.3 29 48 31.7L47.5 32.3C46.4 33.6 46 35.3 46.3 37L46.5 37.8C47.2 41.3 44.5 44.5 40.9 44.4H40.1C38.4 44.4 36.8 45.1 35.7 46.4L35.2 47C32.9 49.7 28.7 49.6 26.5 46.8L26 46.2C25 44.9 23.4 44.1 21.7 44H20.9C17.3 43.9 14.8 40.6 15.7 37.1L15.9 36.3C16.3 34.7 16 32.9 14.9 31.6L14.4 30.9C12.2 28.1 13.3 24 16.5 22.5L17.3 22.2C18.8 21.5 20 20.1 20.4 18.5L20.6 17.7C21.5 14.2 25.3 12.5 28.5 14.1L29.2 14.5C30.7 15.3 32.5 15.3 34 14.6L34.8 14.3C38 12.8 41.8 14.7 42.5 18.2Z" stroke="#83d030" stroke-width="1.6" stroke-miterlimit="10" />
                                </svg>
                            </div>
                            <div class="content">
                                <h2 class="font-weight-bold font24">Popular Instruments</h2>
                                <p class="text-grey-500">
                                    Access all the major instruments available in the market.
                                </p>
                            </div>
                        </div>
                    </div>
                    <div class="col-sm-4">
                        <div class="benefit-box text-center">
                            <div class="icon">
                                <svg width="63" height="63" viewBox="0 0 63 63" fill="none" xmlns="http://www.w3.org/2000/svg">
                                    <path d="M31.3 61.8096C48.1 61.8096 61.8 48.1096 61.8 31.3096C61.8 14.5096 48.1 0.80957 31.3 0.80957C14.5 0.80957 0.800049 14.5096 0.800049 31.3096C0.800049 48.1096 14.5 61.8096 31.3 61.8096Z" stroke="#667B91" stroke-width="1.6" stroke-miterlimit="10" />
                                    <path d="M43.6 44.3099C47 41.0099 49.2 36.4099 49.2 31.3099C49.2 26.3099 47.2 21.8099 43.9 18.6099" stroke="url(#paint0_linear_2_687)" stroke-width="1.6" />
                                    <path d="M18.7 18.6099C15.4 21.8099 13.4 26.3099 13.4 31.3099C13.4 36.2099 15.4 40.7099 18.6 43.9099" stroke="url(#paint1_linear_2_687)" stroke-width="1.6" />
                                    <path d="M42.2 50.5099H20.4C19.5 50.5099 18.7 49.7099 18.7 48.8099V13.8099C18.7 12.9099 19.5 12.1099 20.4 12.1099H39C40.9 14.0099 41.8999 15.0099 43.7999 16.9099V48.8099C43.7999 49.7099 43.1 50.5099 42.2 50.5099Z" stroke="#83d030" stroke-width="1.6" stroke-miterlimit="10" />
                                    <path d="M24 36.0098V46.4098" stroke="#83d030" stroke-width="1.6" stroke-miterlimit="10" />
                                    <path d="M28.8 32.5098V46.4098" stroke="#83d030" stroke-width="1.6" stroke-miterlimit="10" />
                                    <path d="M33.6 37.4097V46.4097" stroke="#83d030" stroke-width="1.6" stroke-miterlimit="10" />
                                    <path d="M38.3 29.6099V46.4099" stroke="#83d030" stroke-width="1.6" stroke-miterlimit="10" />
                                    <path d="M29.8 23.8099H34.5C34.5 26.4099 32.4 28.5099 29.8 28.5099C27.2 28.5099 25.1 26.4099 25.1 23.8099C25.1 21.3099 27 19.3099 29.5 19.1099L29.8 23.8099Z" stroke="#83d030" stroke-width="1.6" stroke-miterlimit="10" />
                                    <defs>
                                        <linearGradient id="paint0_linear_2_687" x1="49.2" y1="48.7896" x2="62.2574" y2="40.9544" gradientUnits="userSpaceOnUse">
                                            <stop stop-color="#667B91" />
                                            <stop offset="1" stop-color="#667B91" stop-opacity="0" />
                                        </linearGradient>
                                        <linearGradient id="paint1_linear_2_687" x1="18.7736" y1="47.827" x2="31.147" y2="40.6527" gradientUnits="userSpaceOnUse">
                                            <stop stop-color="#667B91" stop-opacity="0" />
                                            <stop offset="0.888072" stop-color="#667B91" />
                                        </linearGradient>
                                    </defs>
                                </svg>
                            </div>
                            <div class="content">
                                <h2 class="font-weight-bold font24">Analysis tools</h2>
                                <p class="text-grey-500">
                                    Predict better with advanced trading tools.
                                </p>
                            </div>
                        </div>
                    </div>
                    <div class="col-sm-4">
                        <div class="benefit-box text-center">
                            <div class="icon">
                                <svg width="63" height="63" viewBox="0 0 63 63" fill="none" xmlns="http://www.w3.org/2000/svg">
                                    <path d="M31.3 61.8096C48.1 61.8096 61.8 48.1096 61.8 31.3096C61.8 14.5096 48.1 0.80957 31.3 0.80957C14.5 0.80957 0.800049 14.5096 0.800049 31.3096C0.800049 48.1096 14.5 61.8096 31.3 61.8096Z" stroke="#667B91" stroke-width="1.6" stroke-miterlimit="10" />
                                    <path d="M31.3 49.21C41.2 49.21 49.2001 41.21 49.2001 31.31C49.2001 24.91 45.9001 19.41 40.9001 16.21" stroke="url(#paint0_linear_2_717)" stroke-width="1.6" />
                                    <path d="M21.4 16.3096C16.6 19.5096 13.4 25.0096 13.4 31.3096C13.4 41.2096 21.4 49.2096 31.3 49.2096" stroke="url(#paint1_linear_2_717)" stroke-width="1.6" />
                                    <path d="M21 31.2098V19.4098C21 13.7098 25.6 9.00977 31.3 9.00977C37 9.00977 41.6 13.6098 41.6 19.3098V31.1098" stroke="#83d030" stroke-width="1.6" stroke-miterlimit="10" />
                                    <path d="M19 24.8096H20.9V31.2096H19C18.2 31.2096 17.6 30.6096 17.6 29.8096V26.2096C17.6 25.4096 18.3 24.8096 19 24.8096Z" stroke="#83d030" stroke-width="1.6" stroke-miterlimit="10" />
                                    <path d="M43.5999 24.8096H41.7V31.2096H43.5999C44.3999 31.2096 45 30.6096 45 29.8096V26.2096C45 25.4096 44.2999 24.8096 43.5999 24.8096Z" stroke="#83d030" stroke-width="1.6" stroke-miterlimit="10" />
                                    <path d="M41.7001 31.21V32.11C41.7001 37.01 37.7 41.01 32.8 41.01H30.8" stroke="#83d030" stroke-width="1.6" stroke-miterlimit="10" />
                                    <path d="M30.1 42.0098H28.4C27.8 42.0098 27.4 41.5098 27.4 41.0098C27.4 40.4098 27.9 40.0098 28.4 40.0098H30.1C30.7 40.0098 31.1 40.5098 31.1 41.0098C31.1 41.6098 30.6 42.0098 30.1 42.0098Z" stroke="#83d030" stroke-width="1.6" stroke-miterlimit="10" />
                                    <defs>
                                        <linearGradient id="paint0_linear_2_717" x1="31.3001" y1="49.21" x2="53.9389" y2="30.335" gradientUnits="userSpaceOnUse">
                                            <stop stop-color="#667B91" />
                                            <stop offset="1" stop-color="#667B91" stop-opacity="0" />
                                        </linearGradient>
                                        <linearGradient id="paint1_linear_2_717" x1="15.6728" y1="16.3096" x2="12.1909" y2="47.0447" gradientUnits="userSpaceOnUse">
                                            <stop stop-color="#667B91" />
                                            <stop offset="1" stop-color="#667B91" stop-opacity="0" />
                                        </linearGradient>
                                    </defs>
                                </svg>
                            </div>
                            <div class="content">
                                <h2 class="font-weight-bold font24">Customer support</h2>
                                <p class="text-grey-500">
                                    We have a dedicated and multilingual customer support 24x7.
                                </p>
                            </div>
                        </div>
                    </div>
                    <div class="col-sm-4">
                        <div class="benefit-box text-center">
                            <div class="icon">
                                <svg width="63" height="63" viewBox="0 0 63 63" fill="none" xmlns="http://www.w3.org/2000/svg">
                                    <path d="M31.3 61.8096C48.1 61.8096 61.8 48.1096 61.8 31.3096C61.8 14.5096 48.1 0.80957 31.3 0.80957C14.5 0.80957 0.800049 14.5096 0.800049 31.3096C0.800049 48.1096 14.5 61.8096 31.3 61.8096Z" stroke="#667B91" stroke-width="1.6" stroke-miterlimit="10" />
                                    <path d="M43.6 44.3099C47 41.0099 49.2 36.4099 49.2 31.3099C49.2 26.3099 47.2 21.8099 43.9 18.6099" stroke="url(#paint0_linear_2_736)" stroke-width="1.6" />
                                    <path d="M18.7 18.6099C15.4 21.8099 13.4 26.3099 13.4 31.3099C13.4 36.2099 15.4 40.7099 18.6 43.9099" stroke="url(#paint1_linear_2_736)" stroke-width="1.6" />
                                    <path d="M42.2 50.5099H20.4C19.5 50.5099 18.7 49.7099 18.7 48.8099V13.8099C18.7 12.9099 19.5 12.1099 20.4 12.1099H39C40.9 14.0099 41.8999 15.0099 43.7999 16.9099V48.8099C43.7999 49.7099 43.1 50.5099 42.2 50.5099Z" stroke="#83d030" stroke-width="1.6" stroke-miterlimit="10" />
                                    <path d="M28.4 24.6097H24.6C24.1 24.6097 23.7 24.2097 23.7 23.7097V19.9097C23.7 19.4097 24.1 19.0097 24.6 19.0097H28.4C28.9 19.0097 29.2999 19.4097 29.2999 19.9097V23.7097C29.2999 24.2097 28.9 24.6097 28.4 24.6097Z" stroke="#667B91" stroke-width="1.6" stroke-miterlimit="10" />
                                    <path d="M25.2 20.8097L27.1 22.9097L31.4 18.4097" stroke="#83d030" stroke-width="1.6" stroke-miterlimit="10" />
                                    <path d="M32.7999 21.4097L40.2999 21.3097" stroke="#83d030" stroke-width="1.6" stroke-miterlimit="10" />
                                    <path d="M28.4 35.8098H24.6C24.1 35.8098 23.7 35.4098 23.7 34.9098V31.0098C23.7 30.5098 24.1 30.1098 24.6 30.1098H28.4C28.9 30.1098 29.2999 30.5098 29.2999 31.0098V34.8098C29.2999 35.3098 28.9 35.8098 28.4 35.8098Z" stroke="#667B91" stroke-width="1.6" stroke-miterlimit="10" />
                                    <path d="M25.2 31.9098L27.1 34.0098L31.4 29.5098" stroke="#83d030" stroke-width="1.6" stroke-miterlimit="10" />
                                    <path d="M32.7999 32.5098L40.2999 32.4098" stroke="#83d030" stroke-width="1.6" stroke-miterlimit="10" />
                                    <path d="M28.4 46.9099H24.6C24.1 46.9099 23.7 46.5099 23.7 46.0099V42.2099C23.7 41.7099 24.1 41.3099 24.6 41.3099H28.4C28.9 41.3099 29.2999 41.7099 29.2999 42.2099V46.0099C29.2999 46.4099 28.9 46.9099 28.4 46.9099Z" stroke="#667B91" stroke-width="1.6" stroke-miterlimit="10" />
                                    <path d="M25.2 43.0099L27.1 45.1099L31.4 40.6099" stroke="#83d030" stroke-width="1.6" stroke-miterlimit="10" />
                                    <path d="M32.7999 43.6099L40.2999 43.5099" stroke="#83d030" stroke-width="1.6" stroke-miterlimit="10" />
                                    <defs>
                                        <linearGradient id="paint0_linear_2_736" x1="43.6" y1="18.6099" x2="33.4603" y2="23.5661" gradientUnits="userSpaceOnUse">
                                            <stop stop-color="#667B91" />
                                            <stop offset="1" stop-color="#667B91" stop-opacity="0" />
                                        </linearGradient>
                                        <linearGradient id="paint1_linear_2_736" x1="18.7001" y1="43.9097" x2="28.4168" y2="39.3595" gradientUnits="userSpaceOnUse">
                                            <stop stop-color="#667B91" />
                                            <stop offset="1" stop-color="#667B91" stop-opacity="0" />
                                        </linearGradient>
                                    </defs>
                                </svg>
                            </div>
                            <div class="content">
                                <h2 class="font-weight-bold font24">Multiple methods</h2>
                                <p class="text-grey-500">
                                    We have various deposits and withdrawal methods.
                                </p>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="trade-now-btn-box mt-5 pt-4 text-center">
                <a href="https://secure.wizensefx.com/register/" class="btn btn-primary">Trade now</a>
            </div>
        </div>
    </section>

    
    <section class="about-vision theme-padding" style="
        background: url(../assets/img/about-vision-bg.png) no-repeat;
        background-size: cover;
        background-position: center;
      ">
        <div class="container">
            <div class="row">
                <div class="col-sm-10 offset-sm-2 col-md-9 offset-md-3 col-lg-8 offset-lg-4">
                    <div class="content pl-sm-5 ml-sm-4">
                        <h2 class="display-4 font-weight-bold text-white mb-4">
                            Our Vision
                        </h2>
                        <p class="text-white text-lead font-weight-light mb-4">
                            A world of tech-enabled trading where ambitious traders embrace
                            the challenge and opportunity of global markets.
                        </p>
                        <p class="text-white font-weight-light font16">
                            We are here to excel your trading experience. We aim to move
                            you, teach you and furnish you with an ideal exchanging
                            opportunity, climate, and devices that you merit. We are
                            dedicated to furnishing our customers with complete lucidity,
                            security, and top-level administration of assets with complete
                            trustworthiness and straightforwardness.
                        </p>
                    </div>
                </div>
            </div>
        </div>
    </section>
    

    
    
    

    
    <section class="about-card theme-padding">
        <div class="container">
            <div class="card-box">
                <img src="../assets/img/brand-circle.svg" class="bg-card-shape" alt="About Card Image">
                <div class="content">
                    <h2 class="display-4 font-weight-bold text-white mb-4">
                        Trade with the most recognized broker
                    </h2>
                    <p class="text-white mb-4 pb-2 text-lead-2 pr-4 font-weight-light">
                        We represent transparency & reliability. Brokers throughout the planet trust Wizense.
                    </p>
                    <a href="https://secure.wizensefx.com/register/" class="btn btn-primary">Register Now</a>
                </div>
            </div>
        </div>
    </section>
    


<?php include('../footer.php') ?>
