<?php

namespace App\Enums;

use App\Traits\EnumToArray;

enum SettingKey: string
{
    use EnumToArray;

    case NOTIFICATION_GROUP_POSTS = 'notification_group_posts';
    case NOTIFICATION_FRIEND_POSTS = 'notification_friend_posts';
    case NOTIFICATION_MY_POST_COMMENT = 'notification_my_post_comment';

    public function label(): string
    {
        return match ($this) {
            self::NOTIFICATION_GROUP_POSTS => 'Updates in joined groups',
            self::NOTIFICATION_FRIEND_POSTS => 'Activity of friends',
            self::NOTIFICATION_MY_POST_COMMENT => 'New activity on my post/comment',
        };
    }

    public function description(): string
    {
        return match ($this) {
            self::NOTIFICATION_GROUP_POSTS => "Get notified about the latest posts, events, and discussions in the groups you've joined. Stay informed and connected with your communities!",
            self::NOTIFICATION_FRIEND_POSTS => "Stay in the loop with real-time updates on your friends' activities. Be the first to know when they share, comment, or like content!",
            self::NOTIFICATION_MY_POST_COMMENT => 'Receive instant notifications whenever someone likes, replies, or mentions you on your posts or comments. Stay engaged and never miss an interaction!',
        };
    }
}
