<?php

namespace App\Http\Controllers\Api\Admin;

use App\Models\Post;
use App\Http\Controllers\Api\AdminController;
use App\Repositories\Admin\PostRepository;

class PostController extends AdminController
{
    protected $postRepository;

    public function __construct(PostRepository $postRepository)
    {
        parent::__construct();
        $this->postRepository = $postRepository;
    }

    public function index()
    {
        $data = $this->postRepository->getAll();

        return response()->json($data);
    }

    public function getTrash()
    {
        $data = $this->postRepository->getTrash();

        return response()->json($data);
    }

    public function show($id)
    {
        $data = $this->postRepository->show($id);

        return response()->json($data);
    }

    public function destroy(Post $post)
    {
        $this->postRepository->destroy($post);

        return response()->noContent();
    }

    public function restore($id)
    {
        $this->postRepository->restore($id);

        return response()->noContent();
    }
}
