<?php

namespace App\Http\Controllers\Api\Admin;

use App\Http\Controllers\Api\AdminController;
use App\Repositories\Admin\UserRepository;

class UserController extends AdminController
{
    protected $userRepository;

    public function __construct(UserRepository $userRepository)
    {
        parent::__construct();
        $this->userRepository = $userRepository;
    }

    public function index()
    {
        $data = $this->userRepository->getAll();

        return response()->json($data);
    }

    public function getTrash()
    {
        $data = $this->userRepository->getTrash();

        return response()->json($data);
    }

    public function show($id)
    {
        $data = $this->userRepository->show($id);

        return response()->json($data);
    }

    public function destroy($id)
    {
        $this->userRepository->destroy($id);

        return response()->noContent();
    }

    public function restore($id)
    {
        $this->userRepository->restore($id);

        return response()->noContent();
    }
}
