<?php

namespace App\Http\Controllers\Api\General;

use App\Http\Controllers\Api\GeneralController;
use App\Repositories\General\AnnouncementRepository;

class AnnouncementController extends GeneralController
{
    protected $announcementRepository;

    public function __construct(AnnouncementRepository $announcementRepository)
    {
        parent::__construct();
        $this->announcementRepository = $announcementRepository;
    }

    public function index()
    {
        $data = $this->announcementRepository->getAll();

        return response()->json($data);
    }

    public function show($id)
    {
        $data = $this->announcementRepository->show($id);

        return response()->json($data);
    }
}
