<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Factories\HasFactory;

class Friend extends Model
{
    use HasFactory;

    /**
     * The attributes that are mass assignable.
     *
     * @var array<int, string>
     */
    protected $fillable = [
        'from_user_id',
        'to_user_id',
        'is_seen',
        'is_accepted',
    ];

    /**
     * The attributes that should be cast.
     *
     * @var array<string, string>
     */
    protected $casts = [
        'is_seen' => 'boolean',
        'is_accepted' => 'boolean',
    ];

    public function scopeSeen($query, $value)
    {
        $query->where('is_seen', $value);
    }

    public function scopeAccepted($query, $value)
    {
        $query->where('is_accepted', $value);
    }

    public function scopeGetByUsers($query, $user1Id, $user2Id)
    {
        $query->where(function ($query) use ($user1Id, $user2Id) {
            $query->whereIn('from_user_id', [$user1Id, $user2Id])
                ->whereIn('to_user_id', [$user1Id, $user2Id])
                ->whereColumn('from_user_id', '<>', 'to_user_id');
        });
    }

    public function scopeCheckInListExists($query, $user1Id, $user2Id): bool
    {
        return $query->getByUsers($user1Id, $user2Id)->exists();
    }

    public function scopeCheckInAcceptListExists($query, $user1Id, $user2Id): bool
    {
        return $query->getByUsers($user1Id, $user2Id)->accepted(true)->exists();
    }

    public function scopeCheckInUnAcceptListExists($query, $user1Id, $user2Id): bool
    {
        return $query->getByUsers($user1Id, $user2Id)->accepted(false)->exists();
    }
}
