<?php

namespace App\Repositories\General;

use App\Models\Event;

class EventRepository
{
    public function getAll()
    {
        $events = Event::with([
            'user',
            'image',
        ])
            ->withTrashed()
            ->filter(request([
                'search',
            ]))
            ->latest('created_at')
            ->paginate(config('pagination.general'))
            ->withQueryString();

        return compact('events');
    }

    public function show($id)
    {
        $event = Event::with([
            'user',
            'image',
        ])
            ->withTrashed()
            ->find($id);

        return compact('event');
    }
}
