<?php

namespace App\Repositories\General;

use Exception;
use Throwable;
use App\Models\Notification;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Log;

class NotificationRepository
{
    public function getAll()
    {
        $notifications = auth()->user()->notifications()
            ->latest('updated_at')
            ->paginate(config('pagination.general'))
            ->withQueryString();

        return compact('notifications');
    }

    public function add($userId, $content, $imageUrl = '', $type = '', $redirectLink = '')
    {
        return Notification::create([
            'user_id' => $userId,
            'content' => $content,
            'image_url' => $imageUrl,
            'type' => $type,
            'link' => $redirectLink,
        ]);
    }

    public function seen($notificationId)
    {
        $loginUser = auth()->user();
        $notification = $loginUser->notifications()->findOrFail($notificationId);
        $oldNotifications = $loginUser->notifications()->where('created_at', '<=', $notification->created_at);

        $oldNotifications->push($notification);

        try {
            DB::beginTransaction();

            foreach ($oldNotifications as $oldNotification) {
                $oldNotification->update([
                    'is_seen' => true,
                ]);
            }

            DB::commit();
        } catch (Throwable $e) {
            DB::rollBack();

            Log::error(__CLASS__ . '::' . __FUNCTION__ . '[line: ' . __LINE__ . ']Message: ' . $e->getMessage());

            throw new Exception('Notification seen failed.');
        }
    }

    public function destroy($notificationId)
    {
        $notification = auth()->user()->notifications()->findOrFail($notificationId);

        $notification->delete();
    }
}
