<?php

namespace Database\Factories;

use App\Models\User;
use Illuminate\Database\Eloquent\Factories\Factory;

/**
 * @extends \Illuminate\Database\Eloquent\Factories\Factory<\App\Models\Model>
 */
class EventFactory extends Factory
{
    /**
     * Define the model's default state.
     *
     * @return array<string, mixed>
     */
    public function definition(): array
    {
        $user = User::admin()->inRandomOrder()->first();
        $startTime = fake()->boolean() ? now()->addDays(rand(0, 10)) : now()->subDays(rand(0, 10));
        do {
            $endTime = fake()->boolean() ? now()->addDays(rand(0, 20)) : now()->subDays(rand(0, 20));
        } while ($endTime->lte($startTime));

        return [
            'title' => fake()->realText(60),
            'description' => fake()->realText(),
            'link' => fake()->url(),
            'start_time' => $startTime,
            'end_time' => $endTime,
            'user_id' => $user->id,
        ];
    }
}
