<?php

namespace Database\Seeders;

use App\Models\Category;
use Illuminate\Database\Seeder;

class CategorySeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $data = [
            [
                'id' => 1,
                'name' => 'Stocks',
                'description' => 'Stock market quotes, company news, hedge funds and private equity, stock indexes and ETFs. and more.',
            ],
            [
                'id' => 2,
                'name' => 'Futures/Options',
                'description' => 'Personal strategies, unorthodox trading approaches and some trading tips and tricks that are only used by the pros.',
            ],
            [
                'id' => 3,
                'name' => 'Forex/CFDs',
                'description' => 'Market news covering forex, commodities, and indices, reporting and analysis. Live Forex and economic news.',
            ],
            [
                'id' => 4,
                'name' => 'Crypto',
                'description' => 'Exploring and discuss crypto news about the latest Bitcoin, Ethereum, Blockchain, NFTs, and Altcoin trends and happenings.',
            ],
            [
                'id' => 5,
                'name' => 'News/Education',
                'description' => 'Learn the basics of markets, risk management and money saving to achieve goal of financial freedom.',
            ],
            [
                'id' => 6,
                'name' => 'Scripting',
                'description' => '',
            ],
            [
                'id' => 7,
                'name' => 'LiveTrading',
                'description' => '',
            ],
        ];

        foreach ($data as $category) {
            Category::updateOrCreate(
                ['id' => $category['id']],
                [...$category]
            );
        }
    }
}
