<?php

use Illuminate\Support\Facades\Route;
use App\Http\Controllers\Api\General\PostController;
use App\Http\Controllers\Api\General\UserController;
use App\Http\Controllers\Api\Auth\PasswordController;
use App\Http\Controllers\Api\General\EventController;
use App\Http\Controllers\Api\General\GroupController;
use App\Http\Controllers\Api\General\FriendController;
use App\Http\Controllers\Api\General\CommentController;
use App\Http\Controllers\Api\General\SettingController;
use App\Http\Controllers\Api\General\CommunityController;
use App\Http\Controllers\Api\Auth\RegisteredUserController;
use App\Http\Controllers\Api\General\AnnouncementController;
use App\Http\Controllers\Api\General\ConversationController;
use App\Http\Controllers\Api\General\NotificationController;

Route::get('/', [CommunityController::class, 'index'])->name('community.index');

Route::get('/posts', [PostController::class, 'index'])->name('post.index');
Route::get('/posts/{id}', [PostController::class, 'show'])->name('post.show');
Route::get('/posts/{id}/likes', [PostController::class, 'showLikes'])->name('post.show.likes');
Route::get('/comments/{id}/likes', [CommentController::class, 'showLikes'])->name('comment.show.likes');

Route::get('/users/{id}', [UserController::class, 'show'])->name('user.show');
Route::get('/users/{id}/count', [UserController::class, 'showCount'])->name('user.show.count');
Route::get('/users/{id}/count/{type}', [UserController::class, 'showCountDetail'])->name('user.show.count.detail');

Route::get('/groups', [GroupController::class, 'index'])->name('group.index');
Route::get('/groups/{groupId}', [GroupController::class, 'show'])->name('group.show');

Route::get('/groups/{id}/posts', [PostController::class, 'getByGroup'])->name('group.post.index');
Route::get('/users/{id}/posts', [PostController::class, 'getByUser'])->name('user.post.index');

Route::get('/announcements', [AnnouncementController::class, 'index'])->name('announcement.index');
Route::get('/announcements/{id}', [AnnouncementController::class, 'show'])->name('announcement.show');

Route::get('/events', [EventController::class, 'index'])->name('event.index');
Route::get('/events/{id}', [EventController::class, 'show'])->name('event.show');

Route::middleware(['auth:sanctum', 'verified'])->group(function () {
    Route::post('/users', [RegisteredUserController::class, 'save'])->name('user.save');
    Route::put('/password', [PasswordController::class, 'update'])->name('password.update');
    Route::delete('/users/delete', [UserController::class, 'destroy'])->name('user.destroy');

    Route::get('/notifications', [NotificationController::class, 'index'])->name('notification.index');
    Route::post('/notifications/{notificationId}/seen', [NotificationController::class, 'seen'])->name('notification.seen');
    Route::delete('/notifications/{notificationId}/delete', [NotificationController::class, 'destroy'])->name('notification.destroy');

    Route::get('/settings', [SettingController::class, 'index'])->name('setting.index');
    Route::post('/settings', [SettingController::class, 'save'])->name('setting.save');

    Route::get('/friends', [FriendController::class, 'index'])->name('friend.index');
    Route::get('/friends/unaccepted', [FriendController::class, 'getUnacceptedUsers'])->name('friend.unaccepted.index');
    Route::post('/friends/add/{user}', [FriendController::class, 'add'])->name('friend.add');
    Route::post('/friends/seen/{user}', [FriendController::class, 'seen'])->name('friend.seen');
    Route::post('/friends/accept/{user}', [FriendController::class, 'accept'])->name('friend.accept');
    Route::post('/friends/decline/{user}', [FriendController::class, 'decline'])->name('friend.decline');
    Route::post('/friends/cancel/{user}', [FriendController::class, 'cancel'])->name('friend.cancel');
    Route::delete('/friends/remove/{user}', [FriendController::class, 'remove'])->name('friend.remove');

    Route::get('/messages', [ConversationController::class, 'index'])->name('conversation.index');
    Route::get('/messages/{user}', [ConversationController::class, 'show'])->name('conversation.show');
    Route::post('/messages', [ConversationController::class, 'save'])->name('conversation.save');
    Route::post('/messages/{user}/seen/{messageId}', [ConversationController::class, 'seen'])->name('conversation.seen');
    Route::delete('/messages/{user}/delete/{messageId}', [ConversationController::class, 'deleteMessage'])->name('conversation.message.delete');

    // TODO: Implement Group Messages
    Route::post('/group-messages', [ConversationController::class, 'saveGroup'])->name('conversation.group.save');
    Route::get('/group-messages/{conversationId}', [ConversationController::class, 'showGroup'])->name('conversation.group.show');
    Route::post('/group-messages/{conversationId}', [ConversationController::class, 'saveGroupMessage'])->name('conversation.group.message.save');
    Route::post('/group-messages/{conversationId}/seen/{messageId}', [ConversationController::class, 'seenGroup'])->name('conversation.group.seen');
    Route::post('/group-messages/{conversationId}/leave', [ConversationController::class, 'leaveGroup'])->name('conversation.group.leave');
    Route::delete('/group-messages/{conversationId}/delete/{messageId}', [ConversationController::class, 'deleteGroupMessage'])->name('conversation.group.message.delete');

    Route::delete('/messages/delete/{conversationId}', [ConversationController::class, 'deleteConversation'])->name('conversation.delete');

    Route::post('/posts', [PostController::class, 'save'])->name('post.save');
    Route::delete('/posts/{post}', [PostController::class, 'destroy'])->name('post.destroy');
    Route::put('/posts/{id}', [PostController::class, 'restore'])->name('post.restore');
    Route::post('/posts/{post}/likes', [PostController::class, 'like'])->name('post.like');

    Route::post('/groups', [GroupController::class, 'save'])->name('group.save');
    Route::get('/groups/{groupId}/members', [GroupController::class, 'showMembers'])->name('group.show.members');
    Route::get('/groups/{groupId}/invite/users', [GroupController::class, 'showInviteUsers'])->name('group.show.invite.users');
    Route::post('/groups/invite', [GroupController::class, 'sendInvitation'])->name('group.send.invitation');
    Route::post('/groups/{groupId}/invite/accept', [GroupController::class, 'acceptInvitation'])->name('group.accept.invitation');
    Route::post('/groups/{groupId}/invite/ignore', [GroupController::class, 'ignoreInvitation'])->name('group.ignore.invitation');
    Route::post('/groups/{groupId}/join', [GroupController::class, 'join'])->name('group.user.join');
    Route::post('/groups/{groupId}/request', [GroupController::class, 'userRequest'])->name('group.user.request');
    Route::post('/groups/{groupId}/cancel', [GroupController::class, 'userCancel'])->name('group.user.cancel');
    Route::post('/groups/{groupId}/user-request/{userId}/seen', [GroupController::class, 'userSeen'])->name('group.user.seen');
    Route::post('/groups/{groupId}/user-accept/{userId}', [GroupController::class, 'userAccept'])->name('group.user.accept');
    Route::post('/groups/{groupId}/user-decline/{userId}', [GroupController::class, 'userDecline'])->name('group.user.decline');
    Route::post('/groups/{groupId}/user-remove/{userId}', [GroupController::class, 'userRemove'])->name('group.user.remove');
    Route::post('/groups/{groupId}/leave', [GroupController::class, 'leave'])->name('group.user.leave');
    Route::get('/groups/{id}/posts/unaccepted', [PostController::class, 'getUnacceptedGroupPosts'])->name('group.unaccepted.post.index');
    Route::post('/groups/{groupId}/post-request/{postId}/seen', [GroupController::class, 'postSeen'])->name('group.post.seen');
    Route::post('/groups/{groupId}/post-accept/{postId}', [GroupController::class, 'postAccept'])->name('group.post.accept');
    Route::post('/groups/{groupId}/post-decline/{postId}', [GroupController::class, 'postDecline'])->name('group.post.decline');
    Route::post('/groups/{groupId}/post-remove/{postId}', [GroupController::class, 'postRemove'])->name('group.post.remove');
    Route::delete('/groups/{groupId}', [GroupController::class, 'destroy'])->name('group.destroy');

    Route::post('/comments', [CommentController::class, 'save'])->name('comment.save');
    Route::delete('/comments/{comment}', [CommentController::class, 'destroy'])->name('comment.destroy');
    Route::post('/comments/{comment}/likes', [CommentController::class, 'like'])->name('comment.like');
});
