<?php

namespace App\Http\Controllers\Admin;

use App\Models\Group;
use App\Http\Controllers\AdminController;
use App\Repositories\Admin\GroupRepository;

class GroupController extends AdminController
{
    protected $groupRepository;

    public function __construct(GroupRepository $groupRepository)
    {
        parent::__construct();
        $this->groupRepository = $groupRepository;
    }

    public function index()
    {
        $data = $this->groupRepository->getAll();

        return response()->json($data);
    }

    public function show($id)
    {
        $data = $this->groupRepository->show($id);

        return response()->json($data);
    }

    public function destroy(Group $group)
    {
        $this->groupRepository->destroy($group);

        return response()->noContent();
    }

    public function restore($id)
    {
        $this->groupRepository->restore($id);

        return response()->noContent();
    }
}
