<?php

namespace App\Http\Controllers\General;

use App\Http\Controllers\GeneralController;
use App\Repositories\General\NotificationRepository;

class NotificationController extends GeneralController
{
    protected $notificationRepository;

    public function __construct(NotificationRepository $notificationRepository)
    {
        parent::__construct();
        $this->notificationRepository = $notificationRepository;
    }

    public function index()
    {
        $data = $this->notificationRepository->getAll();

        return response()->json($data);
    }

    public function seen($notificationId)
    {
        $this->notificationRepository->seen($notificationId);

        return response()->noContent();
    }

    public function destroy($notificationId)
    {
        $this->notificationRepository->destroy($notificationId);

        return response()->noContent();
    }
}
