<?php

namespace App\Http\Controllers\General;

use App\Http\Controllers\GeneralController;
use App\Repositories\General\SettingRepository;
use App\Http\Requests\General\SettingSaveRequest;

class SettingController extends GeneralController
{
    protected $settingRepository;

    public function __construct(SettingRepository $settingRepository)
    {
        parent::__construct();
        $this->settingRepository = $settingRepository;
    }

    public function index()
    {
        $data = $this->settingRepository->getAll();

        return response()->json($data);
    }

    public function save(SettingSaveRequest $request)
    {
        $this->settingRepository->save($request);

        return response()->noContent();
    }
}
