<?php

namespace App\Http\Requests\General;

use Illuminate\Validation\Rule;
use Illuminate\Foundation\Http\FormRequest;

class ConversationMessageSaveRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array<mixed>|string>
     */
    public function rules(): array
    {
        return [
            'user_id' => ['required', 'exists:users,id,deleted_at,NULL'],
            'message_id' => ['nullable', 'exists:messages,id,deleted_at,NULL'],
            'content' => ['nullable', 'string', 'max:2000', Rule::requiredIf($this->input('images') == null)],
            'images' => ['nullable', 'array', Rule::requiredIf($this->input('content') == null)],
            'images.*' => ['image', 'max:10000'],
        ];
    }
}
