<?php

namespace Database\Seeders;

use App\Models\User;
use App\Enums\UserRole;
use App\Models\Setting;
use App\Enums\SettingType;
use Illuminate\Database\Seeder;

class UserSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $user = User::create([
            'name' => config('superadmin.auth.name'),
            'email' => config('superadmin.auth.email'),
            'email_verified_at' => now(),
            'password' => config('superadmin.auth.password'),
            'role' => UserRole::ADMIN,
        ]);

        $user->profile()->create([
            'first_name' => '',
            'last_name' => '',
            'gender' => '',
            'phone' => '',
            'country' => '',
            'state' => '',
            'city' => '',
            'address' => '',
            'zip' => '',
        ]);

        $settings = Setting::all();
        foreach ($settings as $setting) {
            switch ($setting->type) {
                case SettingType::BOOLEAN:
                    $setting->users()->save($user, ['value' => true]);
                    break;
                default:
                    $setting->users()->save($user, ['value' => '']);
                    break;
            }
        }
    }
}
