<?php

use Illuminate\Support\Facades\Route;
use App\Http\Controllers\Admin\PostController;
use App\Http\Controllers\Admin\UserController;
use App\Http\Controllers\Admin\GroupController;
use App\Http\Controllers\Admin\DashboardController;
use App\Http\Controllers\Admin\AnnouncementController;
use App\Http\Controllers\Auth\AuthenticatedSessionController;

Route::prefix(config('superadmin.auth.route_prefix'))->name('admin.')->group(function () {
    Route::middleware('guest')->group(function () {
        Route::post('login', [AuthenticatedSessionController::class, 'store'])
            ->name('login');
    });

    Route::middleware(['auth', 'can:admin'])->group(function () {
        Route::get('dashboard/count', [DashboardController::class, 'showCount'])->name('dashboard.show.count');

        Route::get('announcements', [AnnouncementController::class, 'index'])->name('announcement.index');
        Route::get('announcements/{id}', [AnnouncementController::class, 'show'])->name('announcement.show');
        Route::post('announcements', [AnnouncementController::class, 'save'])->name('announcement.save');
        Route::delete('announcements/{announcement}', [AnnouncementController::class, 'destroy'])->name('announcement.destroy');
        Route::put('announcements/{id}', [AnnouncementController::class, 'restore'])->name('announcement.restore');

        Route::get('users', [UserController::class, 'index'])->name('user.index');
        Route::get('users/{id}', [UserController::class, 'show'])->name('user.show');
        Route::delete('users/{id}', [UserController::class, 'destroy'])->name('user.destroy');
        Route::put('users/{id}', [UserController::class, 'restore'])->name('user.restore');

        Route::get('posts', [PostController::class, 'index'])->name('post.index');
        Route::get('posts/{id}', [PostController::class, 'show'])->name('post.show');
        Route::delete('posts/{post}', [PostController::class, 'destroy'])->name('post.destroy');
        Route::put('posts/{id}', [PostController::class, 'restore'])->name('post.restore');

        Route::get('groups', [GroupController::class, 'index'])->name('group.index');
        Route::get('groups/{id}', [GroupController::class, 'show'])->name('group.show');
        Route::delete('groups/{group}', [GroupController::class, 'destroy'])->name('group.destroy');
        Route::put('groups/{id}', [GroupController::class, 'restore'])->name('group.restore');
    });
});
