<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\AdminController;
use App\Repositories\Admin\UserRepository;

class UserController extends AdminController
{
    protected $userRepository;

    public function __construct(UserRepository $userRepository)
    {
        parent::__construct();
        $this->userRepository = $userRepository;
    }

    public function index()
    {
        $data = $this->userRepository->getAll();

        return response()->json($data);
    }

    public function show($id)
    {
        $data = $this->userRepository->show($id);

        return response()->json($data);
    }

    public function destroy($id)
    {
        $this->userRepository->destroy($id);

        return response()->noContent();
    }

    public function restore($id)
    {
        $this->userRepository->restore($id);

        return response()->noContent();
    }
}
