<?php

namespace App\Http\Controllers\General;

use App\Models\Comment;
use App\Http\Controllers\GeneralController;
use App\Repositories\General\CommentRepository;
use App\Http\Requests\General\CommentSaveRequest;

class CommentController extends GeneralController
{
    protected $commentRepository;

    public function __construct(CommentRepository $commentRepository)
    {
        parent::__construct();
        $this->commentRepository = $commentRepository;
    }

    public function save(CommentSaveRequest $request)
    {
        $this->commentRepository->save($request);

        return response()->noContent();
    }

    public function destroy(Comment $comment)
    {
        $this->commentRepository->destroy($comment);

        return response()->noContent();
    }

    public function like(Comment $comment)
    {
        $data = $this->commentRepository->like($comment);

        return response()->json($data);
    }
}
