<?php

namespace App\Http\Controllers\General;

use App\Models\Post;
use App\Http\Controllers\GeneralController;
use App\Repositories\General\PostRepository;
use App\Http\Requests\General\PostSaveRequest;

class PostController extends GeneralController
{
    protected $postRepository;

    public function __construct(PostRepository $postRepository)
    {
        parent::__construct();
        $this->postRepository = $postRepository;
    }

    public function index()
    {
        $data = $this->postRepository->getAll();

        return response()->json($data);
    }

    public function show($id)
    {
        $data = $this->postRepository->show($id);

        return response()->json($data);
    }

    public function save(PostSaveRequest $request)
    {
        $this->postRepository->save($request);

        return response()->noContent();
    }

    public function destroy(Post $post)
    {
        $this->postRepository->destroy($post);

        return response()->noContent();
    }

    public function restore($id)
    {
        $this->postRepository->restore($id);

        return response()->noContent();
    }

    public function like(Post $post)
    {
        $data = $this->postRepository->like($post);

        return response()->json($data);
    }
}
