<?php

namespace App\Http\Requests\Admin;

use App\Models\Announcement;
use Illuminate\Foundation\Http\FormRequest;

class AnnouncementSaveRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        if ($this->input('id')) {
            return Announcement::find($this->input('id'))?->exists();
        }

        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array<mixed>|string>
     */
    public function rules(): array
    {
        return [
            'id' => ['nullable', 'exists:announcements,id,deleted_at,NULL'],
            'title' => ['required', 'string', 'max:120'],
            'description' => ['required', 'string', 'max:2000'],
            'link' => ['nullable', 'string', 'max:120'],
            'start_time' => ['required', 'date', 'before:today'],
            'end_time' => ['nullable', 'date', 'after:start_time'],
            'image' => ['nullable', 'image', 'max:10000'],
        ];
    }
}
