<?php
class gClass
{
    public function __construct()
    {}

    private $username = "FTMForex_Api_2019";
    private $password = "YXFQdWgZ";
    private $api_url = "http://api.ftmglobalmarkets.com/api/mt5manager/";
    private $mail_url = "http://api.ftmglobalmarkets.com/api/mail/";

    //Live Account List
    public function GetLiveAccounts($uid, $con)
    {
        $list = array();
        $users = $this->GetClientsOfIB($con, $uid);

        if (count($users) > 0) {
            for ($i = 0; $i < count($users); $i++) {
                $get = $con->prepare("select * from liveaccount where userId = ?");
                $get->bind_param('s', $users[$i]["uid"]);
                $get->execute();
                $result = $get->get_result();
                if ($result->num_rows > 0) {
                    while ($rows = $result->fetch_assoc()) {
                        array_push($list, array(
                            "account_type" => $rows["account_type"],
                            "leverage" => $rows["leverage"],
                            "balance" => $rows["Balance"],
                            "equity" => $rows["equity"],
                            "login" => $rows["trade_id"],
                            "date" => $rows["Registered_Date"],
                            "type" => "live",
                            "profit" => $rows["profit"],
                        ));
                    }
                }

            }
        }
        return $list;
    }

    //Demo Account List
    public function GetDemoAccounts($uid, $con)
    {
        $list = array();
        $get = $con->prepare("select * from demoaccount where userId = ?");
        $get->bind_param('s', $uid);
        $get->execute();
        $result = $get->get_result();
        if ($result->num_rows > 0) {
            while ($rows = $result->fetch_assoc()) {
                array_push($list, array(
                    "account_type" => $rows["account_type"],
                    "leverage" => $rows["leverage"],
                    "balance" => $rows["Balance"],
                    "equity" => $rows["equity"],
                    "login" => $rows["trade_id"],
                    "date" => $rows["Registered_Date"],
                    "type" => "demo",
                    "phonePwd" => $rows["phone_pwd"],
                ));
            }
        }
        return $list;
    }

    //Account types
    public function GetAccountTypeLive($con, $uid)
    {
        $list = array();
        $get = $con->prepare("select * from account_types where ac_type = 'live'");
        $get->execute();
        $result = $get->get_result();
        if ($result->num_rows > 0) {
            while ($rows = $result->fetch_assoc()) {
                array_push($list, array(
                    "name" => $rows["ac_name"],
                    "min" => $rows["ac_min_deposit"],
                    "max" => $rows["ac_max_deposit"],
                    "leverage" => $rows["ac_max_leverage"],
                ));
            }
        }
        return $list;
    }

    //Account types
    public function GetAccountTypeDemo($con, $uid)
    {
        $list = array();
        $get = $con->prepare("select * from account_types where ac_type = 'demo'");
        $get->execute();
        $result = $get->get_result();
        if ($result->num_rows > 0) {
            while ($rows = $result->fetch_assoc()) {
                array_push($list, array(
                    "name" => $rows["ac_name"],
                    "min" => $rows["ac_min_deposit"],
                    "max" => $rows["ac_max_deposit"],
                    "leverage" => $rows["ac_max_leverage"],
                ));
            }
        }
        return $list;
    }

    //Client Details
    public function GetUserDetails($con, $uid)
    {
        $details = array();
        $get = $con->prepare("select * from ib1 where uid = ?");
        $get->bind_param('s', $uid);
        $get->execute();
        $result = $get->get_result();
        if ($result->num_rows === 1) {
            $rows = $result->fetch_assoc();
            $details = array(
                "email" => $rows["email"],
                "number" => $rows["number"],
                "name" => $rows["name"],
                "country" => $rows["country"],
                "dial_code" => $rows["dial_code"],
                "zipcode" => $rows["zipcode"],
                "address" => $rows["address"],
                "dob" => $rows["dob"],
                "state" => $rows["state"],
                "city" => $rows["city"],
                "ib_ref_code" => $rows["ib_ref_code"],
                "commission" => $rows["commission"],
                "withdraw" => $rows["withdraw"],
            );
        }
        return $details;
    }

    private function GetGroupDetails($con, $name)
    {
        $detail = array("group" => "FTM-B-MICRO-USD", "leverage" => 100);
        $get = $con->prepare("select * from account_types where ac_name = ?");
        $get->bind_param('s', $name);
        $get->execute();
        $result = $get->get_result();
        if ($result->num_rows === 1) {
            $rows = $result->fetch_assoc();
            $detail["group"] = $rows["ac_group"];
            $detail["leverage"] = $rows["ac_max_leverage"];
        }
        return $detail;
    }

    // Create Live account
    public function CreateLiveAccount($con, $type, $leverage = 100, $uid, $date)
    {
        $user = $this->GetUserDetails($con, $uid);
        if (count($user) === 0) {
            return array("login" => 1);
        }

        //Validate Account Group
        $group_details = $this->GetGroupDetails($con, $type);
        $group = $group_details["group"];

        if ($leverage > $group_details["leverage"]) {
            $leverage = 100;
        }

        //MT5 api call for Creating real account
        $data = array(
            "key" => $this->username,
            "password" => $this->password,
            "group" => $group . "-USD",
            "balance" => 0,
            "currency" => "USD",
            "leverage" => $leverage,
            "name" => $user["name"],
            "address" => $user["address"],
            "email" => $user["email"],
            "uid" => $uid,
            "city" => $user["city"],
            "country" => $user["country"],
            "phoneNumber" => $user["number"],
            "zipcode" => $user["zipcode"],
            "state" => $user["state"],
            "tradePassword" => "",
            "investerPassword" => "",
            "phonePassword" => "",
        );

        $callResponse = json_decode($this->CurlCall($data, "CreateLiveAccount", $this->api_url));

        if ($callResponse->login !== 0) {
            $dbStatus = $this->AddLiveAccount($con, $type, $leverage, $data["currency"], $callResponse->login, $uid, $date, $callResponse->tradePassword, $callResponse->investerPassword, $user["email"], $data["group"], $callResponse->phonePassword);
            $data = array(
                "key" => $this->username,
                "password" => $this->password,
                "subject" => "Real Trade Account Created",
                "tempID" => 670579,
                "email" => $user["email"],
                "name" => $user["name"],
                "trade_password" => $callResponse->tradePassword,
                "investor_password" => $callResponse->investerPassword,
                "phone_password" => $callResponse->phonePassword,
                "login" => $callResponse->login,
                "account_type" => "Real",
            );
            $mailStatus = $this->CurlCall($data, "TradeAccountMailSend", $this->mail_url);
            if (!$mailStatus) {
                // Log mail failure
            }
            return array("login" => $callResponse->login);
        }
        return array("login" => 0);
    }

    // Create Demo account
    public function CreateDemoAccount($con, $type, $leverage = 100, $uid, $amount = 10000, $date)
    {
        $user = $this->GetUserDetails($con, $uid);
        if (count($user) === 0) {
            return array("login" => 1);
        }

        //Validate Account Group and Set if required ?????????????????

        //MT5 api call for Creating demo account
        $data = array(
            "key" => $this->username,
            "password" => $this->password,
            "group" => "FTM-DEMO-USD",
            "balance" => $amount,
            "currency" => "USD",
            "leverage" => $leverage,
            "name" => $user["name"],
            "address" => $user["address"],
            "email" => $user["email"],
            "uid" => $uid,
            "city" => $user["city"],
            "country" => $user["country"],
            "phoneNumber" => $user["number"],
            "zipcode" => $user["zipcode"],
            "state" => $user["state"],
            "tradePassword" => "",
            "investerPassword" => "",
            "phonePassword" => "",
        );

        $callResponse = json_decode($this->CurlCall($data, "CreateDemoAccount", $this->api_url));

        if ($callResponse->login !== 0) {
            $dbStatus = $this->AddDemoAccount($con, $type, $leverage, $data["currency"], $callResponse->login, $uid, $date, $amount, $callResponse->tradePassword, $callResponse->investerPassword, $user["email"], $data["group"], $callResponse->phonePassword);
            $data = array(
                "key" => $this->username,
                "password" => $this->password,
                "subject" => "Demo Trade Account Created",
                "tempID" => 670579,
                "email" => $user["email"],
                "name" => $user["name"],
                "trade_password" => $callResponse->tradePassword,
                "investor_password" => $callResponse->investerPassword,
                "phone_password" => $callResponse->phonePassword,
                "login" => $callResponse->login,
                "account_type" => "Demo",
            );
            $mailStatus = $this->CurlCall($data, "TradeAccountMailSend", $this->mail_url);
            if (!$mailStatus) {
                // Log mail failure
            }
            return array("login" => $callResponse->login);
        }

        return array("login" => 0);
    }

    private function AddDemoAccount($con, $type, $leverage, $currency, $login, $uid, $date, $deposit, $tradePassword, $investorPassword, $email, $group, $phonePassword)
    {
        $insert = $con->prepare("insert into demoaccount (account_type, leverage, currency, Balance, trade_id, userId, Registered_Date, deposit, trader_pwd, invester_pwd, email, account_id, accGroup, phone_pwd, equity) values(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)");
        $insert->bind_param('sisdsssdssssssd', $type, $leverage, $currency, $deposit, $login, $uid, $date, $deposit, $tradePassword, $investorPassword, $email, $login, $group, $phonePassword, $deposit);
        $insert->execute();
        if ($insert->affected_rows === 1) {
            return 1;
        }

        return 0;
    }

    private function AddLiveAccount($con, $type, $leverage, $currency, $login, $uid, $date, $tradePassword, $investorPassword, $email, $group, $phonePassword)
    {
        $insert = $con->prepare("insert into liveaccount (account_type, leverage, currency, trade_id, userId, Registered_Date, trader_pwd, invester_pwd, email, account_id, accGroup, phone_pwd) values(?,?,?,?,?,?,?,?,?,?,?,?)");
        $insert->bind_param('sissssssssss', $type, $leverage, $currency, $login, $uid, $date, $tradePassword, $investorPassword, $email, $login, $group, $phonePassword);
        $insert->execute();
        if ($insert->affected_rows === 1) {
            return 1;
        }

        return 0;
    }

    // Upload ID and Address doc
    public function UploadDoc($con, $type, $file, $note = 'noNote', $uid, $date)
    {
        $name = substr($uid, 0, 8) . "_" . time() . "." . $this->GetDocType($file['type']);
        $temp = $file['tmp_name'];
        $location = "../../_docs/";
        $cType = "IB1";
        $user = $this->GetUserDetails($con, $uid);
        if (move_uploaded_file($temp, $location . $name)) {
            $upload = $con->prepare("insert into userdocuments (uid, doc_name, type, doc_type, date, note, uploader_id, email, client_type) values(?,?,?,?,?,?,?,?,?)");
            $upload->bind_param('sssssssss', $uid, $name, $type, $file['type'], $date, $note, $uid, $user["email"], $cType);
            $upload->execute();

            if ($upload->affected_rows > 0) {
                return 1;
            }
        }
        return 0;
    }

    public function GetDocList($con, $uid)
    {
        $list = array();
        $get = $con->prepare("select * from userdocuments where uid = ? order by date desc");
        $get->bind_param('s', $uid);
        $get->execute();
        $result = $get->get_result();
        if ($result->num_rows > 0) {
            while ($rows = $result->fetch_assoc()) {
                array_push($list, array(
                    "doc_name" => $rows["doc_name"],
                    "type" => $rows["type"],
                    "doc_type" => $rows["doc_type"],
                    "status" => $rows["status"],
                    "date" => $rows["date"],
                ));
            }
        }
        return $list;
    }

    public function UpdateProfile($con, $number, $address, $state, $city, $country, $zipcode, $uid)
    {
        $update = $con->prepare("update ib1 set number = ?, address = ?, state = ?, city = ?, country = ?, zipcode = ? where uid = ?");
        $update->bind_param('sssssss', $number, $address, $state, $city, $country, $zipcode, $uid);
        $update->execute();
        if ($update->affected_rows === 1) {
            return 1;
        }
        return 0;
    }

    public function updatePassword($con, $uid, $password)
    {
        $update = $con->prepare("update ib1 set password = ? where uid = ?");
        $update->bind_param('ss', $password, $uid);
        $update->execute();
        if ($update->affected_rows === 1) {
            return 1;
        }
        return 0;
    }

    public function ResetPassword($con, $email, $token, $password)
    {
        $time = time();
        $newToken = substr(sha1(uniqid()), 8);
        $update = $con->prepare("update ib1 set password = ?, emailToken = ?, email_token_time = ? where emailToken = ? and email = ?");
        $update->bind_param('sssss', $password, $newToken, $time, $token, $email);
        $update->execute();
        if ($update->affected_rows === 1) {
            return 1;
        }
        return 0;
    }

    public function PasswordRestRequest($con, $email)
    {
        $token = $this->GetEmailToken($con, $email);
        $data = array(
            "key" => $this->username,
            "password" => $this->password,
            "email" => $email,
            "token" => $token,
            "subject" => "Password Reset Token",
            "tempID" => 699186,
        );
        $res = $this->CurlCall($data, "ResetRequest", $this->mail_url);
        if ($res) {
            return 1;
        }

        return 0;
    }

    public function GetClientsOfIB($con, $uid)
    {
        $list = array();
        $uid = $this->Get_ib_ref_code_from_uid($con, $uid);
        $get = $con->prepare("select * from aspnetusers where ib1 = ?");
        $get->bind_param('s', $uid);
        $get->execute();
        $result = $get->get_result();
        if ($result->num_rows > 0) {
            while ($rows = $result->fetch_assoc()) {
                array_push($list, array(
                    "uid" => $rows["uid"],
                    "name" => $rows["fullname"],
                    "email" => $rows["email"],
                    "number" => $rows["number"],
                    "country" => $rows["country"],
                    "dial_code" => $rows["dial_code"],
                ));
            }
        }
        return $list;
    }

    public function Get_ib_ref_code_from_uid($con, $uid)
    {
        $get = $con->prepare("select ib_ref_code from ib1 where uid = ?");
        $get->bind_param('s', $uid);
        $get->execute();
        $result = $get->get_result();
        if ($result->num_rows === 1) {
            $rows = $result->fetch_assoc();
            return $rows["ib_ref_code"];
        }
        return "no_ib_ref_code";
    }

    public function GetWithdrawDetails($con, $uid)
    {
        $list = array();
        $get = $con->prepare("select * from ib_withdraw where uid = ? order by date desc");
        $get->bind_param('s', $uid);
        $get->execute();
        $result = $get->get_result();
        if ($result->num_rows > 0) {
            while ($rows = $result->fetch_assoc()) {
                array_push($list, array(
                    "order_id" => $rows["orderId"],
                    "amount" => $rows["amount"],
                    "status" => $rows["status"],
                    "gateway" => $rows["gateway"],
                    "date" => $rows["date"],
                    "details" => $rows["withdraw_details"],
                    "updated_amount" =>$rows[ "updated_amount"],
                ));
            }
        }
        return $list;
    }

    public function GetTradeCommission($con, $uid) 
    {
        $list = array();
        $get = $con->prepare( "select * from ib_commessions_report where ibId = ? order by date desc");
        $get->bind_param('s', $uid);
        $get->execute();
        $result = $get->get_result();
        if ($result->num_rows > 0) {
            while ($rows = $result->fetch_assoc()) {
                array_push($list, array(
                    "order_id" => $rows[ "orderID"],
                    "commession" => $rows[ "commession"],
                    "login" => $rows[ "login"],
                    "lot" => $rows[ "lotConversion"],
                    "date" => $rows["date"],
                    "symbol" => $rows[ "symbol"],
                    "open_time" =>$rows[ "openTime"],
                    "close_time" => $rows[ "closeTime"],
                    "position_id" => $rows[ "positionID"],
                ));
            }
        }
        return $list;            
    }

    public function GetAccount($data)
    {
        $data["key"] = $this->username;
        $data["password"] = $this->password;
        return $this->CurlCall($data, "GetAccountDetails", $this->api_url);
    }

    public function CheckAccount($con, $login, $uid, $type)
    {
        if ($type === "live") {
            $qry = "select trade_id from liveaccount where trade_id = ? and userId = ?";
        } else {
            $qry = "select trade_id from demoaccount where trade_id = ? and userId = ?";
        }

        $get = $con->prepare($qry);
        $get->bind_param('ss', $login, $uid);
        $get->execute();
        $result = $get->get_result();
        if ($result->num_rows === 1) {
            return 1;
        }
        return 0;

    }

    public function GetDashboardData($con, $uid)
    {
        $ib = $this->GetUserDetails($con, $uid);
        $users = $this->GetClientsOfIB($con, $uid);
        $accounts = $this->GetLiveAccounts($uid, $con);
        $data = array("ref_code" => $ib["ib_ref_code"], "total_clients" => count($users), "total_accounts" => count($accounts), "commission" => $ib["commission"], "withdraw" => $ib["withdraw"]);
        return $data;
    }

    public function Withdraw($con, $amt, $detail, $uid, $date)
    {
        if ($amt <= 0) {
            return array("type" => "warning", "message" => "Invalid Withdraw Amount");
        }

        if ($amt > 100000) {
            return array("type" => "warning", "message" => "Invalid Withdraw Amount, Maximum 100000 USD Per Time");
        }

        if (!isset($detail) || empty($detail)) {
            return array("type" => "warning", "message" => "Invalid Withdraw Details");
        }

        $account = $this->GetUserDetails($con, $uid);

        if ($amt > $account["commission"]) {
            return array("type" => "warning", "message" => "Cannot Withdraw morethan commission");
        }

        $user = $this->GetUserDetails($con, $uid);
        $orderId = uniqid();
        $gateway = "Withdraw";

        $update = $con->prepare("insert into ib_withdraw (orderId, date, gateway, amount, uid, ib_name, ib_email, withdraw_details) values (?,?,?,?,?,?,?,?)");
        $update->bind_param('sssdssss', $orderId, $date, $gateway, $amt, $uid, $user["name"], $user["email"], $detail);
        $update->execute();

        if ($update->affected_rows > 0) {
            $this->WithdrawCall($con, $amt, $uid);
            return array("type" => "success", "message" => "Withdraw Request Placed, will be processed soon");
        }

        return array("type" => "error", "message" => "Unable to process withdraw, Try again later");
    }

    // ------------------------------------------------------------------------------------------------------------------------------------------------//
    // ------------------------------------------------------------------------------------------------------------------------------------------------//
    // ------------------------------------------------------------ Private Methods -------------------------------------------------------------------//
    // ------------------------------------------------------------------------------------------------------------------------------------------------//
    // ------------------------------------------------------------------------------------------------------------------------------------------------//

    private function UpdateTradePasswordCall($data)
    {
        $data["key"] = $this->username;
        $data["password"] = $this->password;
        return $this->CurlCall($data, "UpdatePassword", $this->api_url);
    }

    private function WithdrawCall($con, $amt, $uid)
    {
        $update = $con->prepare("update ib1 set commission = (commission - ?), withdraw = (withdraw + ?) where uid = ?");
        $update->bind_param('dds', $amt, $amt, $uid);
        $update->execute();
        if ($update->affected_rows === 1) {
            return true;
        }

        return false;
    }

    //Get Email Token
    private function GetEmailToken($con, $email)
    {
        $get = $con->prepare("select emailToken from aspnetusers where email = ?");
        $get->bind_param('s', $email);
        $get->execute();
        $result = $get->get_result();
        if ($result->num_rows === 1) {
            $rows = $result->fetch_assoc();
            return $rows["emailToken"];
        }
        return 0;
    }

    //Curl Call
    private function CurlCall($data, $action, $url)
    {
        $curl = curl_init();

        curl_setopt_array($curl, array(
            CURLOPT_URL => $url . $action,
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_ENCODING => "",
            CURLOPT_MAXREDIRS => 10,
            CURLOPT_TIMEOUT => 30,
            CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
            CURLOPT_CUSTOMREQUEST => "POST",
            CURLOPT_POSTFIELDS => json_encode($data),
            CURLOPT_HTTPHEADER => array(
                "accept: application/json",
                "cache-control: no-cache",
                "content-type: application/json",
            ),
        ));
        $response = curl_exec($curl);
        curl_close($curl);

        return $response;
    }

    private function GetDocType($type)
    {
        if ($type === "image/jpeg") {
            return "jpeg";
        } else if ($type === "image/jpg") {
            return "jpg";
        } else if ($type === "image/png") {
            return "png";
        } else if ($type === "application/pdf") {
            return "pdf";
        } else {
            return "";
        }

    }

}
