var ftm = angular.module("ftm", ['ngRoute', 'ngFileUpload']);
var config = {
	"base": "files/_core/route.php",
	"country_url": "files/assets/js/country.js"
};

/**
 * Angular Controllers
 */
ftm.controller('login', ['$scope', '$http', '$window', function ($scope, $http, $window) {
	$scope.login = function (username, password) {
		let data = {
			"email": username,
			"password": password,
			"request": "login"
		};
		$http.post(config.base, data).then(function (r) {
			$scope.message = r.data.message;
			if (r.data.status === "success")
				$window.location.href = "dashboard.php";
		});
	};
}]);

ftm.controller('register', ['$scope', '$http', '$window', function ($scope, $http, $window) {
	$scope.btn_disable = false;
	$scope.tc = true;
	$scope.tc_checked = true;
	var strength = 0;

	$scope.changetc = function (tc) {
		$scope.btn_disable = !(tc);
	}

	$http.get(config.country_url).then(function (r) {
		$scope.countryList = r.data;
	});

	$scope.updateDialcode = function (country) {
		$scope.dialcode = country.dial_code;
	}

	$scope.checkconfirmpassword = function (password, cpassword) {
		if (password !== cpassword) {
			$scope.cPassword_status = true;
			$scope.cPassword_message = "password mismatch";
		} else {
			$scope.cPassword_status = false;
			$scope.cPassword_message = "";
		}
	}

	$scope.register_user = function (name, email, cpassword, country, dialcode, number) {
		$scope.strength = strength;
		let data = {
			"email": email,
			"name": name,
			"password": cpassword,
			"country": country.name,
			"dialcode": dialcode,
			"number": number,
			"request": "register"
		}
		if (strength > 30) {
			$http.post(config.base, data).then(function (r) {
				if (r.data.status === "success") {
					swal.fire({
						type: "success",
						text: r.data.message,
						confirmButtonColor: '#3085d6',
						confirmButtonText: 'Verify Email Now'
					}).then((result) => {
						if (result.value) {
							$window.location.href = "eVerification.php";
						}
					});
				} else {
					swal.fire({
						type: "error",
						text: r.data.message
					});
				}
			});
		} else {
			$scope.password_strength = "enter a strong password";
			swal.fire({
				type: "warning",
				text: "enter a strong password"
			});
		}
	}

	$scope.checkPassword = function (password) {
		strength = PasswordStrength(password);
		if (strength > 80)
			$scope.password_strength = "Password Strong";
		else if (strength > 60)
			$scope.password_strength = "Password Good";
		else if (strength > 30)
			$scope.password_strength = "Password Weak";
		else
			$scope.password_strength = "enter a strong password";
	}

}]);

ftm.controller('passwordReset', ['$scope', '$http', '$window', function ($scope, $http, $window) {
	$scope.password_strength = "enter a strong password";
	$scope.strength = 0;

	$scope.checkPassword = function (password) {
		strength = PasswordStrength(password);
		if (strength > 80)
			$scope.password_strength = "Password Strong";
		else if (strength > 60)
			$scope.password_strength = "Password Good";
		else if (strength > 30)
			$scope.password_strength = "Password Weak";
		else
			$scope.password_strength = "enter a strong password";
		$scope.strength = strength;
	}

	$scope.reset = function (email, token, password) {
		let data = {
			"request": "reset_password_token",
			"email": email,
			"token": token,
			"password": password
		};
		$http.post(config.base, data).then(function (r) {
			if (r.data.status === "success") {
				swal.fire({
					type: r.data.status,
					text: r.data.message,
					confirmButtonColor: '#3085d6',
					confirmButtonText: 'Login Now'
				}).then((result) => {
					if (result.value) {
						$window.location.href = "login.php";
					}
				});
			} else {
				swal.fire({
					type: r.data.status,
					text: r.data.message
				});
			}
			$scope.token = "";
			$scope.email = "";
			$scope.password = "";
		});
	}

	$scope.resetRequest = function (email) {
		$http.post(config.base, {
			"request": "password_rest_request",
			"email": email
		}).then(function (r) {
			swal.fire({
				type: r.data.status,
				text: r.data.message
			});
			$scope.remail = "";
		});
	}

}]);

ftm.controller('mainView', ['$scope', function ($scope) {
	$scope.selected = 1;
	$scope.selectMenu = function (menu) {
		$scope.selected = menu;
	}
}]);

ftm.controller('dashboard', ['$scope', '$http', function ($scope, $http) {
	MainDetails();
	withdraw_history_list();
	$scope.withdraw_history = [];

	function withdraw_history_list() {
		let data = {
			"request": "GetWithdrawDetails"
		};
		$http.post(config.base, data).then(function (r) {
			$scope.withdraw_history = angular.fromJson(r.data.data);
		});
	}

	function MainDetails() {
		let data = {
			"request": "GetMainDetails"
		};
		$http.post(config.base, data).then(function (r) {
			$scope.main = angular.fromJson(r.data.data);
		});
	}

}]);

ftm.controller('profile', ['$scope', '$http', function ($scope, $http) {
	GetUser();

	function GetUser() {
		let data = {
			"request": "GetUserDetails"
		};
		$http.post(config.base, data).then(function (r) {
			let user = r.data.data;
			$scope.username = user.name;
			$scope.email = user.email;
			$scope.dial_code = user.dial_code;
			$scope.number = user.number;
			$scope.country = user.country;
			$scope.address = user.address;
			$scope.state = user.state;
			$scope.city = user.city;
			$scope.zipcode = user.zipcode;
		});
	}

	$scope.updateProfile = function (number, address, state, city, country, zipcode) {
		let data = {
			"request": "update_profile",
			"number": number,
			"state": state,
			"city": city,
			"address": address,
			"country": country,
			"zipcode": zipcode
		};
		$http.post(config.base, data).then(function (r) {
			if (r.data.status === "success") {
				swal.fire({
					type: 'success',
					title: '',
					text: r.data.message
				});
				GetUser();
			} else {
				swal.fire({
					type: 'error',
					title: '',
					text: r.data.message
				});
			}
		});
	}
}]);

ftm.controller('accounts', ['$scope', '$http', function ($scope, $http) {
	$scope.accounts = [];
	TradeAccounts();

	function TradeAccounts() {
		let data = {
			"request": "GetTradeAccounts"
		};
		$http.post(config.base, data).then(function (r) {
			$scope.accounts = angular.fromJson(r.data.data);
		});
	}

}]);

ftm.controller('verification', ['$scope', '$http', 'Upload', function ($scope, $http, Upload) {
	$scope.docs = [];
	GetDocs();
	$scope.uploadID = function () {
		if ($scope.id.file.$valid && $scope.id_file) {
			$scope.upload($scope.id_file, 'id', $scope.pnote);
		}
	};

	$scope.uploadAddress = function () {
		if ($scope.address.file.$valid && $scope.address_file) {
			$scope.upload($scope.address_file, 'address', $scope.anote);
		}
	};

	$scope.upload = function (file, type, note) {
		Upload.upload({
			url: config.base,
			data: {
				file: file,
				'note': note,
				'request': 'UploadDoc',
				'type': type
			}
		}).then(function (resp) {
			if (type === "id") {
				$scope.pnote = '';
				$scope.id_file = '';
			}
			if (type === "address") {
				$scope.anote = '';
				$scope.address_file = '';
			}
			Swal.fire({
				type: 'success',
				title: '',
				text: 'File Uploaded'
			});
			GetDocs();
		}, function (resp) {
			Swal.fire({
				type: "error",
				title: "",
				text: "Error : File Upload " + resp.data.message
			});
		}, function (evt) {
			var progressPercentage = parseInt(100.0 * evt.loaded / evt.total);
			console.log('progress: ' + progressPercentage + '% ' + evt.config.data.file.name);
		});
	};

	function GetDocs() {
		$http.post(config.base, {
			"request": "GetUserDocs"
		}).then(function (r) {
			$scope.docs = r.data.data;
		});
	}
}]);

ftm.controller('eVerification', ['$scope', '$http', function ($scope, $http) {
	$scope.emailVerify = function (token, email) {
		let data = {
			"request": "email_verification",
			"token": token,
			"email": email
		};
		$http.post(config.base, data).then(function (r) {
			swal.fire({
				type: r.data.status,
				text: r.data.message
			});
			$scope.token = "";
			$scope.email = "";
		});
	}
}]);

ftm.controller('setting', ['$scope', '$http', function ($scope, $http) {
	$scope.password_strength = "enter a strong password";

	$scope.updatePassword = function (password) {
		$http.post(config.base, {
			"request": "Update_Password",
			"password": password
		}).then(function (r) {
			if (r.data.status === "success") {
				swal.fire({
					type: "success",
					text: r.data.message
				});
			} else {
				swal.fire({
					type: "error",
					text: r.data.message
				});
			}
		});
	}

	$scope.checkPassword = function (password) {
		strength = PasswordStrength(password);
		if (strength > 80)
			$scope.password_strength = "Password Strong";
		else if (strength > 60)
			$scope.password_strength = "Password Good";
		else if (strength > 30)
			$scope.password_strength = "Password Weak";
		else
			$scope.password_strength = "enter a strong password";
	}

	$scope.checkconfirmpassword = function (password, cpassword) {
		if (password !== cpassword) {
			$scope.cPassword_status = true;
			$scope.cPassword_message = "password mismatch";
		} else {
			$scope.cPassword_status = false;
			$scope.cPassword_message = "";
		}
	}
}]);

ftm.controller('finance', ['$scope', '$http', 'Upload', function ($scope, $http, Upload) {
	liveaccounts();
	deposiList();

	function liveaccounts() {
		let data = {
			"request": "LiveAccounts"
		};
		$http.post(config.base, data).then(function (r) {
			$scope.live = angular.fromJson(r.data.data);
		});
	}

	function deposiList() {
		let data = {
			"request": "GetDepositDetails"
		};
		$http.post(config.base, data).then(function (r) {
			$scope.deposit = angular.fromJson(r.data.data);
		});
	}

	$scope.DepositManual = function () {
		if ($scope.file) {
			$scope.upload($scope.file, $scope.acc_number, $scope.amount, $scope.deposit_type);
		}
	}

	$scope.upload = function (file, login, amount, dtype) {
		Upload.upload({
			url: config.base,
			data: {
				file: file,
				'request': 'manual_deposit',
				'login': login['login'],
				'amount': amount,
				'type': dtype
			}
		}).then(function (resp) {
			if (resp.data.status === "success") {
				swal.fire({
					type: "success",
					title: "",
					text: "Deposit Done, " + resp.data.message
				});
				$scope.acc_number = "";
				$scope.amount = "";
				$scope.deposit_type = "";
				$scope.file = "";
				deposiList();
			}
			if (resp.data.status === "error") {
				Swal.fire({
					type: "error",
					title: "",
					text: "Deposit Failed, " + resp.data.message
				});
			}
		}, function (resp) {
			Swal.fire({
				type: "error",
				title: "",
				text: "Deposit Failed, " + resp.data.message
			});
		}, function (evt) {
			var progressPercentage = parseInt(100.0 * evt.loaded / evt.total);
			console.log('progress: ' + progressPercentage + '% ' + evt.config.data.file.name);
		});
	};
}]);

ftm.controller('withdraw', ['$scope', '$http', function ($scope, $http) {
	$scope.disabled = false;
	IBWalletDetails();

	function IBWalletDetails() {
		let data = {
			"request": "GetMainDetails"
		};
		$http.post(config.base, data).then(function (r) {
			$scope.account_details = angular.fromJson(r.data.data);
		});
	}

	$scope.WithdrawAmount = function (amount, details) {
		$scope.disabled = true;
		let data = {
			"request": "withdraw",
			"amount": amount,
			"detail": details
		};
		$http.post(config.base, data).then(function (r) {
			$scope.disabled = false;
			swal.fire({
				type: r.data.status,
				text: r.data.message
			});
			if (r.data.status === "success") {
				IBWalletDetails();
				$scope.amount = "";
				$scope.withdrawDetails = "";
			}
		});
	}
}]);

ftm.controller('report', ['$scope', '$http', 'Excel', '$timeout', function ($scope, $http, Excel, $timeout) {
	withdrawList();

	function withdrawList() {
		let data = {
			"request": "GetWithdrawDetails"
		};
		$http.post(config.base, data).then(function (r) {
			$scope.withdraw = angular.fromJson(r.data.data);
		});
	}

	$scope.exportToExcel = function (tableId) {
		var exportHref = Excel.tableToExcel(tableId, 'WireWorkbenchDataExport');
		$timeout(function () {
			location.href = exportHref;
		}, 100);
	}
}]);

ftm.controller('clients', ['$scope', '$http', 'Excel', '$timeout', function ($scope, $http, Excel, $timeout) {
	GetClients();

	function GetClients() {
		let data = {
			"request": "ClientList"
		};
		$http.post(config.base, data).then(function (r) {
			$scope.cnt = angular.fromJson(r.data.data);
		});
	}

	$scope.exportToExcel = function (tableId) {
		var exportHref = Excel.tableToExcel(tableId, 'WireWorkbenchDataExport');
		$timeout(function () {
			location.href = exportHref;
		}, 100);
	}
}]);


ftm.controller('commission_report', ['$scope', '$http', function ($scope, $http) {
	$scope.commissions = [];
	TradeCommission();

	function TradeCommission() {
		let data = {
			"request": "Get_Trade_Commission"
		};
		$http.post(config.base, data).then(function (r) {
			$scope.commissions = angular.fromJson(r.data.data);
		});
	}

	$scope.exportToExcel = function (tableId) {
		var exportHref = Excel.tableToExcel(tableId, 'WireWorkbenchDataExport');
		$timeout(function () {
			location.href = exportHref;
		}, 100);
	}

}]);


/*------------------------------- Global Custom Function -------------------------------*/
function PasswordStrength(pass) {
	var score = 0;
	if (!pass)
		return score;

	// award every unique letter until 5 repetitions
	var letters = new Object();
	for (var i = 0; i < pass.length; i++) {
		letters[pass[i]] = (letters[pass[i]] || 0) + 1;
		score += 5.0 / letters[pass[i]];
	}

	// bonus points for mixing it up
	var variations = {
		digits: /\d/.test(pass),
		lower: /[a-z]/.test(pass),
		upper: /[A-Z]/.test(pass),
		nonWords: /\W/.test(pass),
	}

	variationCount = 0;
	for (var check in variations) {
		variationCount += (variations[check] == true) ? 1 : 0;
	}
	score += (variationCount - 1) * 10;

	return parseInt(score);
}

/*------------------------------- Angular Factory ------------------------------------------------*/

ftm.factory('Excel', function ($window) {
	var uri = 'data:application/vnd.ms-excel;base64,',
		template = '<html xmlns:o="urn:schemas-microsoft-com:office:office" xmlns:x="urn:schemas-microsoft-com:office:excel" xmlns="http://www.w3.org/TR/REC-html40"><head><!--[if gte mso 9]><xml><x:ExcelWorkbook><x:ExcelWorksheets><x:ExcelWorksheet><x:Name>{worksheet}</x:Name><x:WorksheetOptions><x:DisplayGridlines/></x:WorksheetOptions></x:ExcelWorksheet></x:ExcelWorksheets></x:ExcelWorkbook></xml><![endif]--></head><body><table>{table}</table></body></html>',
		base64 = function (s) {
			return $window.btoa(unescape(encodeURIComponent(s)));
		},
		format = function (s, c) {
			return s.replace(/{(\w+)}/g, function (m, p) {
				return c[p];
			})
		};
	return {
		tableToExcel: function (tableId, worksheetName) {
			var table = $(tableId),
				ctx = {
					worksheet: worksheetName,
					table: table.html()
				},
				href = uri + base64(format(template, ctx));
			return href;
		}
	};
});