<?php
//+------------------------------------------------------------------+
//|                                             MetaTrader 5 Web API |
//|                   Copyright 2000-2020, MetaQuotes Software Corp. |
//|                                        http://www.metaquotes.net |
//+------------------------------------------------------------------+
session_start();
error_reporting(0);
include('config.php');
if(strlen($_SESSION['clogin'])==0)
{
  header('location:login.php');
}
class WebPageForm
{
  const VERIFY_CODE_LENGTH = 5;
  private $user;
  private $verify_code;
  private $root_url;
  private $api;
  /**
   * Construct
   */
  function __construct()
  {
    //---- start session
    session_start();
    //---- initialize
    $this->user = array('wallet_amount' => '','deposit' => '');
    //---
    $this->root_url = $_SERVER['HTTP_HOST'] . rtrim(dirname($_SERVER['PHP_SELF']), '/\\');
    //---
    $this->api = new MTWebAPI(AGENT, PATH_TO_LOGS);
    $this->api->SetLoggerWriteDebug(IS_WRITE_DEBUG_LOG);
  }
  /**
   * Create web page
   * @return void
   */
  public function CreatePage()
  {
    //---
    if (isset($_REQUEST['a']) && is_array($_REQUEST['a']))
    {
      //--- extract method name
      $methodName = 'On' . key($_REQUEST['a']);
      //--- call the method
      if (method_exists($this, $methodName)) $this->$methodName();
      return;
    }
    $this->Show();
  }
  /**
   * Send email
   * @return void
   */
  private function OnRegister()
  {
    //--- validation request
    if (!isset($_REQUEST['user']) || !is_array($_REQUEST['user']) || !isset($_REQUEST['verify_code']) || empty($_REQUEST['verify_code']) || !isset($_SESSION['verify_code']) || empty($_SESSION['verify_code']))
    {
      include("");
      exit;
    }
    //--- receive input
    $this->user = $_REQUEST['user'];
    $this->verify_code = $_REQUEST['verify_code'];
    //----
    foreach ($this->user as $key => $value) $value = trim($value);
    //--- validation input
    if ($_SESSION['verify_code'] != $this->verify_code)
    {
      $error = '';
      if ($_SESSION['verify_code'] != $this->verify_code) $error .= 'Invalid verify code<br>';
      //---
      $this->GenerateVerifyCode();
      include("demo_deposit1.php");
      exit;
    }
     //--- put parameters in our structure
      //--- check connection
    if (!$this->api->IsConnected())
    {
      if (($error_code = $this->api->Connect(MT5_SERVER_IP, MT5_SERVER_PORT, 300, MT5_SERVER_WEB_LOGIN, MT5_SERVER_WEB_PASSWORD)) != MTRetCode::MT_RET_OK)
      {
        include("demo_deposit1.php");
        echo "<script>
        alert('something went wrong please try again..');
        </script>";
     
        exit;
      }
    }
    $login=$this->user['trade_id'];
    $new_deposit=$this->user['deposit'];
    $comment='Deposit';
    
    //--- add user
    if (($error_code = $this->api->UserDepositChange($login, $new_deposit, $comment, $type=MTEnDealAction::DEAL_BALANCE)) != MTRetCode::MT_RET_OK)
    {
     return $error_code->DepositChange($login, $new_deposit, $comment, $type);
     include("demo_deposit1.php");
     echo "<script>
     alert('something went wrong please try again ');
     </script>";
   }
   else
   {
     include("dashboard.php");
     echo "<script>
     alert('Successfully deposited to your Demo Trading Account..');
     </script>";
   }
 }
  /**
   * Create user on MT server
   * @param $user MTUser
   * @param $user_server MTUser
   * @return bool
   */

  /**
   * Generate new verify code
   * @return void
   */
  private function GenerateVerifyCode()
  {
    $random_string = '';
    for ($i = 0; $i < self::VERIFY_CODE_LENGTH; $i++)
    {
      $random_string .= rand(0, 9);
    }
    $_SESSION['verify_code'] = $random_string;
  }
  /**
   * View page
   * @return void
   */
  private function Show()
  {
    $this->GenerateVerifyCode();
    //---
    include("demo_deposit1.php");
  }
}
?>