<?php
class auth
{

    private $username = "FTMForex_Api_2019";
    private $password = "YXFQdWgZ";
    private $api_url = "http://api.ftmglobalmarkets.com/api/mt5manager/";
    private $mail_url = "http://api.ftmglobalmarkets.com/api/mail/";

    public function __construct()
    {}

    // Auth Login
    public function CheckLogin($uid, $password, $con)
    {
        $check = $con->prepare("select uid from ib1 where email = ? and password = ?");
        $check->bind_param('ss', $uid, $password);
        $check->execute();
        $res = $check->get_result();
        if ($res->num_rows === 1) {
            $rows = $res->fetch_assoc();
            return $rows["uid"];
        }
        return 0;
    }

    //Check Email verification
    public function CheckEmailVerification($uid, $con)
    {
        $check = $con->prepare("select email_confirmed from ib1 where uid = ?");
        $check->bind_param('s', $uid);
        $check->execute();
        $res = $check->get_result();
        if ($res->num_rows === 1) {
            $rows = $res->fetch_assoc();
            return $rows["email_confirmed"];
        }
        return 0;
    }

    //Register client
    public function Registration($email, $name, $password, $country, $dialcode, $number, $con, $date, $emailToken)
    {
        if ($this->CheckDuplicateUser($email, $con) === 1) {
            return 2;
        }

        $uid = $this->GenerateUID($name, $email);
        $status = 'active';
        $timestamp = time();
        $ref_code = substr($this->GenerateUID($name, $email), 0, 10);

        $register = $con->prepare("insert into ib1 (uid, email, password, number, name, date, status, country, dial_code, emailToken, email_token_time, ib_ref_code) values (?,?,?,?,?,?,?,?,?,?,?,?)");
        $register->bind_param('ssssssssssss', $uid, $email, $password, $number, $name, $date, $status, $country, $dialcode, $emailToken, $timestamp, $ref_code);
        $register->execute();
        if ($register->affected_rows === 1) {
            $data = array(
                "key" => $this->username,
                "password" => $this->password,
                "name" => $name,
                "token" => $emailToken,
                "email" => $email,
                "subject" => "Welcome to FTM Global Markets Pte Ltd",
                "tempID" => 699185,
            );
            $mailStatus = $this->CurlCall($data, "WelcomeMail", $this->mail_url);
            if (!$mailStatus) {
                $this->UpdateJournal($con, "IB Register Account", "Mail Failed on Registration Success", $uid, $date, "System");
            }
            return 1;
        }

        return 0;
    }

    //Request a new email token
    public function NewEmailToken($email, $con, $date)
    {
        $token = $this->GetToken(8);
        $timestamp = time();
        $update = $con->prepare('update ib1 set emailToken = ?, email_token_time = ?');
        $update->bind_param('ss', $token, $timestamp);
        $update->execute();
        if ($update->affected_rows === 1) {
            return $token;
        }
        return 0;
    }

    //Update email verification
    public function EmailVerification($email, $token, $con)
    {
        $newtoken = $this->GetToken(8);
        $timestamp = time();
        $update = $con->prepare("update ib1 set emailToken = ?, email_token_time = ?, email_confirmed = 1 where emailToken = ? and email = ? and email_confirmed = 0");
        $update->bind_param('ssss', $newtoken, $timestamp, $token, $email);
        $update->execute();
        if ($update->affected_rows === 1) {
            return 1;
        }
        return 0;
    }

    //add events on DB Journal
    public function UpdateJournal($con, $type, $message, $uid, $date, $updatedBy)
    {
        $ip = $this->GetIpAddress();
        $add = $con->prepare("insert into journal (uid, date, type, message, updatedBy, ip) values (?,?,?,?,?,?)");
        $add->bind_param('ssssss', $uid, $date, $type, $message, $updatedBy, $ip);
        $add->execute();
        return 0;
    }

    private function GenerateUID($name, $email)
    {
        return strtoupper(substr(sha1(md5($name . $email . uniqid())), 0, 15));
    }

    public function GetToken($length)
    {
        $token = "";
        $codeAlphabet = "ABCDEFGHIJKLMNOPQRSTUVWXYZ";
        $codeAlphabet .= "abcdefghijklmnopqrstuvwxyz";
        $codeAlphabet .= "0123456789";
        $max = strlen($codeAlphabet);

        for ($i = 0; $i < $length; $i++) {
            $token .= $codeAlphabet[rand(0, $max - 1)];
        }

        return $token;
    }

    private function CheckDuplicateUser($email, $con)
    {
        $check = $con->prepare("select email from ib1 where email = ?");
        $check->bind_param('s', $email);
        $check->execute();
        $duplicate = $check->get_result();
        if ($duplicate->num_rows > 0) {
            return 1;
        }

        return 0;
    }
    /**
     * Get the customer's IP address.
     *
     * @return string
     */
    public function GetIpAddress()
    {
        $ipaddress = '';
        if (isset($_SERVER['HTTP_CLIENT_IP'])) {
            $ipaddress = $_SERVER['HTTP_CLIENT_IP'];
        } else if (isset($_SERVER['HTTP_X_FORWARDED_FOR'])) {
            $ipaddress = $_SERVER['HTTP_X_FORWARDED_FOR'];
        } else if (isset($_SERVER['HTTP_X_FORWARDED'])) {
            $ipaddress = $_SERVER['HTTP_X_FORWARDED'];
        } else if (isset($_SERVER['HTTP_FORWARDED_FOR'])) {
            $ipaddress = $_SERVER['HTTP_FORWARDED_FOR'];
        } else if (isset($_SERVER['HTTP_FORWARDED'])) {
            $ipaddress = $_SERVER['HTTP_FORWARDED'];
        } else if (isset($_SERVER['REMOTE_ADDR'])) {
            $ipaddress = $_SERVER['REMOTE_ADDR'];
        } else {
            $ipaddress = 'UNKNOWN';
        }

        return $ipaddress;
    }

    /**
     * Make PHP Curl Method for .net Api call
     */
    private function CurlCall($data, $action, $url)
    {
        $curl = curl_init();

        curl_setopt_array($curl, array(
            CURLOPT_URL => $url . $action,
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_ENCODING => "",
            CURLOPT_MAXREDIRS => 10,
            CURLOPT_TIMEOUT => 30,
            CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
            CURLOPT_CUSTOMREQUEST => "POST",
            CURLOPT_POSTFIELDS => json_encode($data),
            CURLOPT_HTTPHEADER => array(
                "accept: application/json",
                "cache-control: no-cache",
                "content-type: application/json",
            ),
        ));
        $response = curl_exec($curl);
        curl_close($curl);

        return $response;
    }

}
