<?php
session_start();
require_once "_init.php";
/**
 * Check Request Method
 * Check Session Auth
 * Check POST Data Request
 */
$request_method = $_SERVER['REQUEST_METHOD'];

/**
 *  Check Request Method
 */
if ($request_method !== "POST")
{
    $message = "invalid_request_method";
    echo (json_encode(array("status" => "error", "message" => $message)));
    $con = connect_mysql();
    $auth = new auth();
    $auth->UpdateJournal($con, "Direct Route Access", $message, "Request", $date, "System");
    close_mysql($con);
    exit();
}
$postdata = file_get_contents("php://input");
$request = json_decode($postdata);

/**
 * Check Any request on Post Method
 */
if (is_null($request)) {
    $requestType = input_data($_POST['request']);
} else {
    $requestType = input_data($request->request);
}

/**
 * Check Request Param is empty or not
 */ (isset($requestType) && !empty($requestType) ? $access = true : $access = false);
if (!$access) {
    echo (json_encode(array("status" => "error", "message" => "error_request_invalid")));
    exit();
}

/**
 * Check Session or Request is register call or login call or Email Verification call
 */
if (!CheckSession() && ($requestType !== "register") && ($requestType !== "login") && ($requestType !== "email_verification") && ($requestType !== "password_rest_request")) {
    echo (json_encode(array("status" => "error", "message" => "error_auth_invalid")));
    exit();
} else if (($requestType === "register") || ($requestType === "login") || ($requestType === "email_verification") || ($requestType === "password_rest_request")) {
    $uid = null;
} else if (CheckSession()) {
    $uid = $_SESSION["ftm_uid"];
} else {
    echo (json_encode(array("status" => "error", "message" => "error_auth_invalid")));
    exit();
}

//--------------------------------------------------------------------------------------------------------------------------------

if ($requestType === "login") 
{
    $auth = new auth();
    $general = new gClass();

    $uid = input_data($request->email);
    $pass = input_data($request->password);
    $con = connect_mysql();

    $session_id = $auth->CheckLogin($uid, $pass, $con);
    if ($session_id === 0) {
        $message = "Invalid username or password";
        $response = res_sts("error", $message);
    } else {
        if ($auth->CheckEmailVerification($session_id, $con)) {

            $user = $general->GetUserDetails($con, $session_id);
            $_SESSION["ftm_uid"] = $session_id;
            $_SESSION["ftm_email_id"] = $user["email"];
            $_SESSION["ftm_name"] = $user["name"];
            $message = "Login Success";
            $response = res_sts("success", $message);
        } else {
            $message = "Email verification pending";
            $response = res_sts("error", $message);
        }
    }

    //Update Log
    $auth->UpdateJournal($con, "Login", $message, $uid, $date, "System");

    //Add Login notification mail method

    close_mysql($con);
}

if ($requestType === "register") 
{
    $auth = new auth();
    $emailToken = $auth->GetToken(8);

    $email = input_data($request->email);
    $name = input_data($request->name);
    $password = input_data($request->password);
    $country = input_data($request->country);
    $dialcode = input_data($request->dialcode);
    $number = input_data($request->number);
    $con = connect_mysql();

    $res_status = $auth->Registration($email, $name, $password, $country, $dialcode, $number, $con, $date, $emailToken);
    if ($res_status === 0) {
        $message = "registration_failed";
        $response = res_sts("error", $message);
    } else if ($res_status === 1) {
        $message = "account_created";
        $response = res_sts("success", $message);
    } else if ($res_status === 2) {
        $message = "duplicate_account";
        $response = res_sts("error", $message);
    } else {
        $message = "internal_error";
        $response = res_sts("error", $message);
    }

    //Update Log
    $auth->UpdateJournal($con, "Register Account", $message, $email, $date, "System");
    close_mysql($con);
}

if ($requestType === "GetTradeAccounts") 
{
    $general = new gClass();

    $con = connect_mysql();
    $list = $general->GetLiveAccounts($uid, $con);
    $response = res_sts("success", "liveAccountList", json_encode($list));
    close_mysql($con);
}

if ($requestType === "AccountTypesLive") 
{
    $general = new gClass();

    $con = connect_mysql();
    $list = $general->GetAccountTypeLive($con, $uid);
    $response = res_sts("success", "accountTypes", json_encode($list));
    close_mysql($con);
}

if ($requestType === "GetMainDetails") {
    $general = new gClass();

    $con = connect_mysql();
    $list = $general->GetDashboardData($con, $uid);
    $response = res_sts("success", "Main Dashboard Details", json_encode($list));
    close_mysql($con);
}

if ($requestType === "AccountTypesDemo") {
    $general = new gClass();

    $con = connect_mysql();
    $list = $general->GetAccountTypeDemo($con, $uid);
    $response = res_sts("success", "accountTypes", json_encode($list));
    close_mysql($con);
}

if ($requestType === "createLiveAccount") 
{
    $accType = input_data($request->type);
    $leverage = input_data($request->leverage);

    $general = new gClass();
    $con = connect_mysql();

    $account = $general->CreateLiveAccount($con, $accType, $leverage, $uid, $date);

    if ($account["login"] === 0) {
        $response = res_sts("error", "unable to create live account");
    }

    if ($account["login"] === 1) {
        $response = res_sts("error", "invalid user details, try again later");
    }

    if ($account["login"] > 1) {
        $response = res_sts("success", "New Live Account Created");
    } else {
        $response = res_sts("error", "unable to create live account");
    }

    close_mysql($con);
}

if ($requestType === "createDemoAccount") {
    $accType = input_data($request->type);
    $leverage = input_data($request->leverage);
    $amount = input_data($request->amount);

    $general = new gClass();
    $con = connect_mysql();

    if ($amount < 1000) {
        $amount = 1000;
    }

    $account = $general->CreateDemoAccount($con, $accType, $leverage, $uid, $amount, $date);

    if ($account["login"] === 0) {
        $response = res_sts("error", "unable to create demo account");
    }

    if ($account["login"] === 1) {
        $response = res_sts("error", "invalid user details, try again later");
    }

    if ($account["login"] > 1) {
        $response = res_sts("success", "New Demo Account Created");
    } else {
        $response = res_sts("error", "unable to create demo account");
    }

    close_mysql($con);
}

if ($requestType === "GetUserDetails") {

    $general = new gClass();
    $con = connect_mysql();
    $user = $general->GetUserDetails($con, $uid);
    $response = res_sts("success", "client details", $user);
    close_mysql($con);
}

if ($requestType === "GetUserDocs") {
    $general = new gClass();
    $con = connect_mysql();
    $list = $general->GetDocList($con, $uid);
    $response = res_sts("success", "Documents Report", $list);
    close_mysql($con);
}

if ($requestType === "update_profile") {
    $number = input_data($request->number);
    $state = input_data($request->state);
    $city = input_data($request->city);
    $address = input_data($request->address);
    $country = input_data($request->country);
    $zipcode = input_data($request->zipcode);

    $general = new gClass();
    $con = connect_mysql();
    $res = $general->UpdateProfile($con, $number, $address, $state, $city, $country, $zipcode, $uid);
    if ($res === 1) {
        $response = res_sts("success", "Profile Updated");
    } else {
        $response = res_sts("error", "Profile Not Updated");
    }
    close_mysql($con);
}

if ($requestType === "reset_password" || $requestType === "Update_Password") {
    $pwd = input_data($request->password);
    $general = new gClass();
    $con = connect_mysql();
    $res = $general->updatePassword($con, $uid, $pwd);
    if ($res === 1) {
        $response = res_sts("success", "Password Updated");
    } else {
        $response = res_sts("error", "Password Not Updated");
    }
    close_mysql($con);
}

if ($requestType === "reset_password_token") {

    $email = input_data($request->email);
    $token = input_data($request->token);
    $password = input_data($request->password);

    $general = new gClass();
    $con = connect_mysql();
    $res = $general->ResetPassword($con, $email, $token, $password);
    if ($res === 1) {
        $response = res_sts("success", "Password Updated");
    } else {
        $response = res_sts("error", "Password Not Updated");
    }
    close_mysql($con);
}

if ($requestType === "password_rest_request") {

    $email = input_data($request->email);

    $general = new gClass();
    $con = connect_mysql();
    $res = $general->PasswordRestRequest($con, $email);
    if ($res === 1) {
        $response = res_sts("success", "Password Reset Request Send");
    } else {
        $response = res_sts("error", "Unable to Send Reset Request or Invalid Email");
    }
    close_mysql($con);
}

if ($requestType === "UploadDoc") {
    $file = $_FILES['file'];
    $type = input_data($_POST['type']);
    $note = input_data($_POST['note']);
    $message = 0;

    if (!isset($file) || empty($file)) {
        $message = 1;
    }

    if ($type !== "id" && $type !== "address") {
        $message = 2;
    }

    if ($file['type'] !== "image/png" && $file['type'] !== "image/jpg" && $file['type'] !== "image/jpeg" && $file['type'] !== "application/pdf") {
        $message = 3;
    }

    if ($file['size'] > 4000000) {
        $message = 4;
    }

    if ($message === 0 && $file['error'] === 0) {
        $general = new gClass();
        $con = connect_mysql();
        $res = $general->UploadDoc($con, $type, $file, $note, $uid, $date);
        close_mysql($con);

        if ($res === 1) {
            $message = 5;
        } else {
            $message = 6;
        }
    }

    switch ($message) {
        case 1:
            $response = res_sts("error", "Invalid File");
            break;
        case 2:
            $response = res_sts("error", "Invalid Request Type");
            break;
        case 3:
            $response = res_sts("error", "Invalid File Type");
            break;
        case 4:
            $response = res_sts("error", "Invalid File Size");
            break;
        case 5:
            $response = res_sts("success", "File Uploaded");
            break;
        case 6:
            $response = res_sts("error", "Invalid File Upload Error");
            break;
        default:
            $response = res_sts("error", "Invalid File Upload Error");
    }
}

if ($requestType === "email_verification") {

    $email = input_data($request->email);
    $token = input_data($request->token);

    $auth = new auth();
    $con = connect_mysql();
    $res = $auth->EmailVerification($email, $token, $con);
    if ($res === 1) {
        $response = res_sts("success", "Email Verified, Login now");
    } else {
        $response = res_sts("error", "Email Verification Failed or Email already verified");
    }
    close_mysql($con);
}

if ($requestType === "update_trade_password") {

    $password = input_data($request->password);
    $login = input_data($request->login);
    $type = input_data($request->type);

    if (empty($password)) {
        $response = res_sts("error", "Trade Password Empty");
    } else {
        $general = new gClass();
        $con = connect_mysql();
        $res = $general->updateTradePassword($con, $uid, $password, $login, $type);
        if ($res === 1) {
            $response = res_sts("success", "Trade Password Updated");
        } else {
            $response = res_sts("error", "Trade Password Not Updated");
        }
        close_mysql($con);
    }
}

if ($requestType === "update_investor_password") {

    $password = input_data($request->password);
    $login = input_data($request->login);
    $type = input_data($request->type);

    if (empty($password)) {
        $response = res_sts("error", "Investor Password Empty");
    } else {
        $general = new gClass();
        $con = connect_mysql();
        $res = $general->updateInvestorPassword($con, $uid, $password, $login, $type);
        if ($res === 1) {
            $response = res_sts("success", "Investor Password Updated");
        } else {
            $response = res_sts("error", "Investor Password Not Updated");
        }
        close_mysql($con);
    }
}

if ($requestType === "manual_deposit") {
    $file = $_FILES['file'];
    $type = input_data($_POST['type']);
    $login = input_data($_POST['login']);
    $amount = input_data($_POST['amount']);
    $message = 0;

    if (!isset($file) || empty($file)) {
        $message = 1;
    }

    if ($file['type'] !== "image/png" && $file['type'] !== "image/jpg" && $file['type'] !== "image/jpeg" && $file['type'] !== "application/pdf") {
        $message = 3;
    }

    if ($file['size'] > 4000000) {
        $message = 4;
    }

    if ($amount < 100 || $amount > 50000) {
        $message = 7;
    }

    if ($message === 0 && $file['error'] === 0) {
        $general = new gClass();
        $con = connect_mysql();
        $res = $general->ManualDeposit($con, $type, $file, $login, $uid, $date, $amount);
        close_mysql($con);

        if ($res === 1) {
            $message = 5;
        } else {
            $message = 6;
        }
    }

    switch ($message) {
        case 1:
            $response = res_sts("error", "Invalid File");
            break;
        case 2:
            $response = res_sts("error", "Invalid Request Type");
            break;
        case 3:
            $response = res_sts("error", "Invalid File Type");
            break;
        case 4:
            $response = res_sts("error", "Invalid File Size");
            break;
        case 5:
            $response = res_sts("success", "File Uploaded");
            break;
        case 6:
            $response = res_sts("error", "Invalid File Upload Error");
            break;
        case 7:
            $response = res_sts("error", "Invalid Amount");
            break;
        default:
            $response = res_sts("error", "Invalid File Upload Error");
    }
}

if ($requestType === "GetWithdrawDetails") {

    $general = new gClass();
    $con = connect_mysql();
    $list = $general->GetWithdrawDetails($con, $uid);
    $response = res_sts("success", "withdraw details", $list);
    close_mysql($con);
}

if ($requestType === "Get_Trade_Commission") {

    $general = new gClass();
    $con = connect_mysql();
    $list = $general->GetTradeCommission($con, $uid);
    $response = res_sts("success", "Trade Commission Report", $list);
    close_mysql($con);
}

if ($requestType === "GetAccountDetails") {

    $login = input_data($request->login);
    $type = input_data($request->type);

    $general = new gClass();
    $con = connect_mysql();

    if ($general->CheckAccount($con, $login, $uid, $type)) {

        $data = array(
            "key" => "",
            "password" => "",
            "login" => $login,
        );

        $details = $general->GetAccount($data, $con);
        $response = res_sts("success", "Account Details", $details);
    } else {
        $response = res_sts("success", "Account Details", array());
    }

    close_mysql($con);
}

if ($requestType === "ClientList") {

    $general = new gClass();
    $con = connect_mysql();
    $list = $general->GetClientsOfIB($con, $uid);
    $response = res_sts("success", "client list", $list);
    close_mysql($con);
}

if ($requestType === "withdraw") {

    $amt = input_data($request->amount);
    $detail = input_data($request->detail);

    $general = new gClass();
    $con = connect_mysql();

    $rtnCall = $general->Withdraw($con, $amt, $detail, $uid, $date);
    $response = res_sts($rtnCall["type"], $rtnCall["message"]);

    close_mysql($con);
}

echo json_encode($response);
?>

<?php
function CheckSession()
{
    if (isset($_SESSION["ftm_uid"]) && !empty($_SESSION["ftm_uid"])) {
        return true;
    }
    return false;
}

function res_sts($sts, $message, $data = array())
{
    return array("status" => $sts, "message" => $message, "data" => $data);
}

function input_data($data)
{
    if (is_numeric($data) || is_bool($data)) {
        return $data;
    }

    if (empty($data) || !isset($data)) {
        $data = "";
    }

    $data = trim($data);
    $data = stripslashes($data);
    $data = htmlspecialchars($data);
    return $data;
}

function filterEmail()
{ }
?> 