<?php
//+------------------------------------------------------------------+
//|                                             MetaTrader 5 Web API |
//|                   Copyright 2000-2020, MetaQuotes Software Corp. |
//|                                        http://www.metaquotes.net |
//+------------------------------------------------------------------+
session_start();
error_reporting(0);
include('config.php');
if(strlen($_SESSION['clogin'])==0)
{
  header('location:login.php');
}
class WebPageForm
{
  const VERIFY_CODE_LENGTH = 5;
  private $user;
  private $verify_code;
  private $root_url;
  private $api;
  /**
   * Construct
   */
  function __construct()
  {
    //---- start session
    session_start();
    //---- initialize
    $this->user = array('trade_id' => '','trader_password' => '');
    //---
    $this->root_url = $_SERVER['HTTP_HOST'] . rtrim(dirname($_SERVER['PHP_SELF']), '/\\');
    //---
    $this->api = new MTWebAPI(AGENT, PATH_TO_LOGS);
    $this->api->SetLoggerWriteDebug(IS_WRITE_DEBUG_LOG);
  }
  /**
   * Create web page
   * @return void
   */
  public function CreatePage()
  {
    //---
    if (isset($_REQUEST['a']) && is_array($_REQUEST['a']))
    {
      //--- extract method name
      $methodName = 'On' . key($_REQUEST['a']);
      //--- call the method
      if (method_exists($this, $methodName)) $this->$methodName();
      return;
    }
    $this->Show();
  }
  /**
   * Send email
   * @return void
   */
  private function OnRegister()
  {
    //--- validation request
    if (!isset($_REQUEST['user']) || !is_array($_REQUEST['user']) || !isset($_REQUEST['verify_code']) || empty($_REQUEST['verify_code']) || !isset($_SESSION['verify_code']) || empty($_SESSION['verify_code']))
    {
      include("");
      exit;
    }
    //--- receive input
    $this->user = $_REQUEST['user'];
    $this->verify_code = $_REQUEST['verify_code'];
    //----
    foreach ($this->user as $key => $value) $value = trim($value);
    //--- validation input
    if ($_SESSION['verify_code'] != $this->verify_code)
    {
      $error = '';
      if ($_SESSION['verify_code'] != $this->verify_code) $error .= 'Invalid verify code<br>';
      include("password_update1.php");
      exit;
    }
     if ($this->user['password'] != $this->user['confirm_password'])
     {
      $error= 'Password not confirm<br>';
       include("password_update1.php");
      exit;
     }
    if (empty($this->user['password']))
    {
      $error = 'Empty Password <br>';
       include("password_update1.php");
      exit;
    }
    if (!$this->CheckPassword($this->user['password']))
    {
      $error= 'Password should be Alpha numeric and min 5 words ex: Test@1990,  <br>';
       include("password_update1.php");
      exit;
    }
      //---
      $this->GenerateVerifyCode();
  
    //--- put parameters in our structure
    //--- check connection
    if (!$this->api->IsConnected())
    {
      if (($error_code = $this->api->Connect(MT5_SERVER_IP, MT5_SERVER_PORT, 300, MT5_SERVER_WEB_LOGIN, MT5_SERVER_WEB_PASSWORD)) != MTRetCode::MT_RET_OK)
      {
        include("password_update1.php");
        echo "<script>
        alert('something went wrong please try again..');
        </script>";
        exit;
      }
    }

 //--- Update trader password
    $password_type=$this->user['password_type'];
    if($password_type=='mainpassword')
    {
        $login=$this->user['trade_id'];
        $new_password = $this->user['password'];
        if (($error_code = $this->api->UserPasswordChange($login, $new_password, $type = MTProtocolConsts::WEB_VAL_USER_PASS_MAIN)) != MTRetCode::MT_RET_OK)
          {
           return $mt_user->PasswordChange($login, $new_password, $type);
          }
         else
         {
           include("password_update1.php");
             // update trader password to database
          $login=$this->user['trade_id'];
          $new_password = $this->user['password'];
          $sql = "update demoaccount set trader_pwd=:new_password WHERE trade_id=:login";
          $query = $dbh->prepare($sql);
          $query->bindParam(':new_password',$new_password,PDO::PARAM_STR);
          $query->bindParam(':login',$login,PDO::PARAM_STR);
          $query->execute();
          $lastInsertId = $dbh->lastInsertId();
           echo "<script>
           alert('Your Trader Password Updated Successfully..');
           </script>";
         }
    }
    
     //--- Update trader password
    if($password_type=='investerpassword')
    {
        $login=$this->user['trade_id'];
        $new_password = $this->user['password'];
        if (($error_code = $this->api->UserPasswordChange($login, $new_password, $type = MTProtocolConsts::WEB_VAL_USER_PASS_INVESTOR)) != MTRetCode::MT_RET_OK)
          {
           return $mt_user->PasswordChange($login, $new_password, $type);
          }
         else
         {
           include("password_update1.php");
          // update invester password to database
          $login=$this->user['trade_id'];
          $new_password = $this->user['password'];
          $sql = "update demoaccount set invester_pwd=:new_password WHERE trade_id=:login";
          $query = $dbh->prepare($sql);
          $query->bindParam(':new_password',$new_password,PDO::PARAM_STR);
          $query->bindParam(':login',$login,PDO::PARAM_STR);
          $query->execute();
          $lastInsertId = $dbh->lastInsertId();  
           echo "<script>
           alert('Your Invester Password Updated Successfully..');
           </script>";
         }
    }
 }

 /**
   * Check password
   * @param $password string
   * @return bool
   */
  function CheckPassword($password)
  {
    $digit = 0;
    $upper = 0;
    $lower = 0;
    //--- check password size
    if (strlen($password) < 5) return (false);
    //--- check password
    for ($i = 0; $i < strlen($password); $i++)
    {
      if (ctype_digit($password[$i])) $digit = 1;
      if (ctype_lower($password[$i])) $lower = 1;
      if (ctype_upper($password[$i])) $upper = 1;
    }
    //--- final check
    return (($digit + $upper + $lower) >= 2);
  }
  /**
   * Create user on MT server
   * @param $user MTUser
   * @param $user_server MTUser
   * @return bool
   */

  /**
   * Generate new verify code
   * @return void
   */
  private function GenerateVerifyCode()
  {
    $random_string = '';
    for ($i = 0; $i < self::VERIFY_CODE_LENGTH; $i++)
    {
      $random_string .= rand(0, 9);
    }
    $_SESSION['verify_code'] = $random_string;
  }
  /**
   * View page
   * @return void
   */
  private function Show()
  {
    $this->GenerateVerifyCode();
    //---
    include("password_update1.php");
  }
}
?>