var bgd = angular.module("bgd", ['ngRoute', 'ngFileUpload']);
var config = {
	"base": "files/_core/controller/route.php",
	"country_url": "files/assets/js/country.js"
};

/**
 * Angular Controllers
 */
bgd.controller('login', ['$scope', '$http', '$window', '$timeout', function ($scope, $http, $window, $timeout) {
	$scope.login = function (username, password) {
		let data = {
			"email": username,
			"password": password,
			"request": "login"
		};
		$http.post(config.base, data).then(function (r) {
			$scope.message = r.data.message;
			if (r.data.status === "success")
				$window.location.href = "dashboard.php";
		});
	};
	$scope.ButtonText = "LOGIN";
	$scope.test = "true";

	$scope.search = function () {
		$scope.test = "false";
		$scope.ButtonText = "Loading";
	
		$timeout(function () {
			$scope.ButtonText = "LOGIN";
		}, 100);
	};
}]);

bgd.controller('passwordReset', ['$scope', '$http', '$window', function ($scope, $http, $window) {
	$scope.password_strength = "enter a strong password";
	$scope.strength = 0;

	$scope.checkPassword = function (password) {
		strength = PasswordStrength(password);
		if (strength > 80)
			$scope.password_strength = "Password Strong";
		else if (strength > 60)
			$scope.password_strength = "Password Good";
		else if (strength > 30)
			$scope.password_strength = "Password Weak";
		else
			$scope.password_strength = "enter a strong password";
		$scope.strength = strength;
	}

	$scope.reset = function (email, token, password) {
		let data = {
			"request": "reset_password_token",
			"email": email,
			"token": token,
			"password": password
		};
		$http.post(config.base, data).then(function (r) {
			if (r.data.status === "success") {
				swal.fire({
					type: r.data.status,
					text: r.data.message,
					confirmButtonColor: '#3085d6',
					confirmButtonText: 'Login Now'
				}).then((result) => {
					if (result.value) {
						$window.location.href = "login.php";
					}
				});
			} else {
				swal.fire({
					type: r.data.status,
					text: r.data.message
				});
			}
			$scope.token = "";
			$scope.email = "";
			$scope.password = "";
		});
	}

	$scope.resetRequest = function (email) {
		$http.post(config.base, {
			"request": "password_rest_request",
			"email": email
		}).then(function (r) {
			swal.fire({
				type: r.data.status,
				text: r.data.message
			});
			$scope.remail = "";
		});
	}
}]);

bgd.controller('mainView', ['$scope', function ($scope) {
	$scope.selected = 1;
	$scope.selectMenu = function (menu) {
		$scope.selected = menu;
	}

	$('#sidebarCollapse').on('click', function () {
		$('#sidebar').toggleClass('active');
	});	
}]);

bgd.controller('dashboard', ['$scope', '$http', function ($scope, $http) {
	$scope.pDeposit = [];
	$scope.pWithdraw = [];
	$scope.ib_withdraw_pending_list = [];
	var year = new Date().getFullYear();
	$scope.deposit_history = [];
	$scope.withdraw_history = [];

	pendingDeposit();
	pendingWithdraw();
	pendingIBWithdraw();
	update_chart();

	$scope.years = cal_years();
	$scope.get_deposit_withdraw_chart = function (year) {
		let data = {
			'request': 'get_deposit_and_withdraw_chart',
			'year': year
		};
		$http.post(config.base, data).then(function (r) {
			$scope.deposit_history = r.data.data.deposit;
			$scope.withdraw_history = r.data.data.withdraw;

			update_chart($scope.deposit_history, $scope.withdraw_history);
		});
	}
	$scope.get_deposit_withdraw_chart(year);

	function update_chart(deposit_h, withdraw_h) {
		function createChart() {
			var chart = Highcharts.stockChart('container', {
				rangeSelector: {
					enabled: false,
				},
				chart: {
					type: 'column'
				},
				xAxis: {
					type: 'datetime',
					dateTimeLabelFormats: {
						month: ' %B',
						year: '%b'
					},
					title: {
						text: 'Date'
					},
				},
				yAxis: {
					opposite: false,
					title: {
						text: 'Deposit and Withdraw'
					},
				},
				tooltip: {
					xDateFormat: '%e. %B',
					shared: true,
					split: false,
					enabled: true
				},
				scrollbar: {
					enabled: false
				},
				credits: {
					enabled: false
				},
				navigator: {
					enabled: false
				},
				series: [{
					name: 'Deposit',
					data: process_to_array_deposit(deposit_h),
					color: '#FF0000',
					grouping: true,
				}, {
					name: 'Withdraw',
					data: process_to_array_withdraw(withdraw_h),
					color: '#008000',
					grouping: true,

				}],
			});
		}
		createChart();
	
		function process_to_array_deposit(data) {
			let arr = [];
			if (data) {
				for (i = 0; i < data.length; i++) {
					arr.push([(data[i].month) * 7000 * 4 * 24 * 3600  , parseFloat(data[i].deposit)]);
				}
				return arr;
			}
			return data;
		}

		function process_to_array_withdraw(data) {
			let arr = [];
			if (data) {
				for (i = 0; i < data.length; i++) {
					arr.push([(data[i].month) * 7000 * 4 * 24 * 3600  , parseFloat(data[i].withdraw)]);
				}
				return arr;
			}
			return data;
		}
	}

	function pendingDeposit() {
		let data = {
			"request": "GetPendingDeposit"
		};
		$http.post(config.base, data).then(function (r) {
			$scope.pDeposit = angular.fromJson(r.data.data);

		});
	}

	function pendingWithdraw() {
		let data = {
			"request": "GetPendingWithdraw"
		};
		$http.post(config.base, data).then(function (r) {
			$scope.pWithdraw = angular.fromJson(r.data.data);

		});
	}

	function pendingIBWithdraw() {
		let data = {
			"request": "GetPendingIBWithdraw"
		};
		$http.post(config.base, data).then(function (r) {
			$scope.ib_withdraw_pending_list = angular.fromJson(r.data.data);

		});
	}

	function UpdateAllAccounts() {
		let data = {
			"request": "Update_All_Accounts"
		};
		$http.post(config.base, data).then(function (r) {});
	}

	$scope.openModal = function (v, type) {
		if (type === "deposit") {
			$scope.vfd = v;
			$("#pendingDeposit").modal('show');
		}

		if (type === "withdraw") {
			$scope.vfw = v;
			$("#pendingWithdraw").modal('show');
		}

		if (type === "ib") {
			$scope.ibp = v;
			$("#pendingIBWithdraw").modal('show');
		}
	}

	$scope.process_deposit = function (type, v) {
		let data = {
			"request": "Process_Deposit",
			"email": v.email,
			"login": v.login,
			"deposit_amount": $scope.deposit || v.amount,
			"comment": $scope.dcomment,
			"type": type,
			"uniqueID": v.uniqueId
		};
		$http.post(config.base, data).then(function (r) {
			$("#pendingDeposit").modal('hide');
			swal.fire({
				type: r.data.status,
				text: r.data.message
			});
			$scope.dcomment = "";
			pendingDeposit();
		});
	}

	$scope.process_withdraw = function (type, v) {
		let data = {
			"request": "Process_Withdraw",
			"email": v.email,
			"login": v.login,
			"withdraw_amount": $scope.withdraw || v.amount,
			"comment": $scope.wcomment,
			"type": type,
			"uniqueID": v.orderId
		};
		$http.post(config.base, data).then(function (r) {
			$("#pendingWithdraw").modal('hide');
			swal.fire({
				type: r.data.status,
				text: r.data.message
			});
			$scope.wcomment = "";
			pendingWithdraw();
		});
	}

	$scope.process_ib_withdraw = function (type, v) {
		let data = {
			"request": "Process_IB_Withdraw",
			"email": v.email,
			"name": v.name,
			"withdraw_amount": $scope.withdraw || v.amount,
			"comment": $scope.wcomment,
			"type": type,
			"uniqueID": v.orderId
		};
		$http.post(config.base, data).then(function (r) {
			$("#pendingIBWithdraw").modal('hide');
			swal.fire({
				type: r.data.status,
				text: r.data.message
			});
			$scope.wcomment = "";
			pendingIBWithdraw();
		});
	}
}]);

bgd.controller('Clients', ['$scope', '$http', function ($scope, $http) {
	$scope.cList = [];
	GetClients();
	$scope.startDate = new Date('01/01/19');
	$scope.endDate = new Date();

	$scope.currentPage = 0;
	$scope.itemsPerPage = 10;
	$scope.pagingOptions = [10, 25, 50, 100];
	$scope.totalItems = $scope.cList.length;
	$scope.pages = function () {
		return Math.ceil($scope.cList.length / $scope.itemsPerPage);
	};

	function GetClients() {
		let data = {
			"request": "GetClients"
		};
		$http.post(config.base, data).then(function (r) {
			$scope.cList = angular.fromJson(r.data.data);
		});
	}

	function GetIBAccounts(ib_level) {
		let data = {
			"request": "Get_IB_Accounts_Setting",
			"c_type": ib_level
		};
		$http.post(config.base, data).then(function (r) {
			$scope.ib_accounts = r.data.data;
		});
	}

	$scope.open_ib_setting = function (client) {
		$scope.cnt = client;
		GetIBAccounts("ib1");
		$("#IB_Setting").modal('show');
	}

	$scope.get_ib_list = function (ib_type) {
		GetIBAccounts(ib_type);
	}

	$scope.update_client_ib = function (ib_email, client_email, ib_type = 'ib1') {
		let data = {
			"request": "Update_Client_IB",
			"ib_email": ib_email,
			"client_email": client_email,
			"ib_type": ib_type,
		};
		$http.post(config.base, data).then(function (r) {
			swal.fire({
				type: r.data.status,
				text: r.data.message,
			});
			if (r.data.status === "success") {
				GetClients();
				$("#IB_Setting").modal('hide');
				$scope.ib_type = "";
			}
		});
	}
}]);

bgd.controller('profile', ['$scope', '$http', function ($scope, $http) {
	$scope.timerOn = false;
	GetUser();

	$http.get(config.country_url).then(function (r) {
		$scope.countryList = r.data;
	});

	$scope.updateDialcode = function (country) {
		$scope.dialcode = country.dial_code;
	}

	function GetUser() {
		let data = {
			"request": "GetUserDetails"
		};
		$http.post(config.base, data).then(function (r) {
			let user = r.data.data;
			$scope.username = user.name;
			$scope.email = user.email;
			$scope.dial_code = user.dial_code;
			$scope.number = user.number;
			$scope.country = user.country;
			$scope.address = user.address;
			$scope.state = user.state;
			$scope.city = user.city;
			$scope.zipcode = user.zipcode;
		});
	}
	$scope.openModal = function (otp_number, type) {
		if (type === "verify") {
			$scope.otp_number = otp_number;
			$("#verifyNumber").modal('show');
		}
		$scope.timerOn = true;
		$scope.timer(300);
	}

	$scope.timer = function (remaining) {
		var m = Math.floor(remaining / 60);
		var s = remaining % 60;

		s = s < 10 ? '0' + s : s;
		$("#timer").html(m + ':' + s);
		remaining -= 1;
		if (remaining >= 0 && $scope.timerOn) {
			setTimeout(function () {
				$scope.timer(remaining);
			}, 1000);
		}
	}

	$scope.resend_otp = function () {
		$scope.timerOn = true;
		$scope.timer(300);
	}


	$scope.verify_number = false;

	$scope.isVerify = function (verify_number) {
		if (verify_number)
			$scope.verify_number = false;
		else
			$scope.verify_number = true;
	}

	$scope.updateProfile = function (number, address, state, city, country, zipcode) {
		if (typeof (country) === 'object') {
			country = country.name;
			dial_code = country.dial_code;
		} else {
			country = $scope.country;
			dial_code = $scope.dial_code;
		}
		let data = {
			"request": "update_profile",
			"number": number,
			"state": state,
			"city": city,
			"address": address,
			"country": country,
			"dial_code": dial_code,
			"zipcode": zipcode
		};
		$http.post(config.base, data).then(function (r) {
			if (r.data.status === "success") {
				swal.fire({
					type: 'success',
					title: '',
					text: r.data.message
				});
				GetUser();
			} else {
				swal.fire({
					type: 'error',
					title: '',
					text: r.data.message
				});
			}
		});
	}
}]);

bgd.controller('live', ['$scope', '$http', function ($scope, $http) {
	$scope.live = [];
	$scope.currentPage = 0;
	$scope.itemsPerPage = 10;
	$scope.pagingOptions = [10, 25, 50, 100, 250, 500, 1000];
	$scope.totalItems = $scope.live.length;
	$scope.pages = function () {
		return Math.ceil($scope.live.length / $scope.itemsPerPage);
	};
	liveaccounts();

	function liveaccounts() {
		let data = {
			"request": "LiveAccounts"
		};
		$http.post(config.base, data).then(function (r) {
			$scope.live = angular.fromJson(r.data.data);
		});
	}

	$scope.account_setting = function () {}
}]);

bgd.controller('demo', ['$scope', '$http', function ($scope, $http) {
	$scope.demo = [];
	demoaccounts();
	$scope.currentPage = 0;
	$scope.itemsPerPage = 10;
	$scope.pagingOptions = [10, 25, 50, 100, 250, 500, 1000];
	$scope.totalItems = $scope.demo.length;
	$scope.pages = function () {
		return Math.ceil($scope.demo.length / $scope.itemsPerPage);
	};

	function demoaccounts() {
		let data = {
			"request": "DemoAccounts"
		};
		$http.post(config.base, data).then(function (r) {
			$scope.demo = angular.fromJson(r.data.data);
		});
	}

	$scope.account_setting = function () {}
}]);

bgd.controller('verification', ['$scope', '$http', 'Upload', function ($scope, $http, Upload) {
	$scope.docs = [];

	GetDocs();
	$scope.startDate = new Date('01/01/19');
	$scope.endDate = new Date();

	$scope.current_page = 0;
	$scope.itemsPerPage = 10;
	$scope.paging_options = [10, 25, 50, 100];
	$scope.totalItems = $scope.docs.length;
	$scope.pages1 = function () {
		return Math.ceil($scope.docs.length / $scope.itemsPerPage);
	};
	$scope.start_date = new Date('01/01/19');
	$scope.end_date = new Date();
	$scope.adocs = [];
	$scope.current_page1 = 0;
	$scope.itemsPerPage2 = 10;
	$scope.paging_options2 = [10, 25, 50, 100];
	$scope.totalItems2 = $scope.adocs.length;
	$scope.pages2 = function () {
		return Math.ceil($scope.adocs.length / $scope.itemsPerPage2);
	};
	$scope.sortColumn = "type";
	$scope.reverseSort = false;

	$scope.sortData = function (column) {
		$scope.reverseSort = ($scope.sortColumn == column) ? !$scope.reverseSort : false;
		$scope.sortColumn = column;

	}

	$scope.getSortClass = function (column) {
		if ($scope.sortColumn == column) {
			return $scope.reverseSort ? 'fas fa-long-arrow-alt-down' : 'fas fa-long-arrow-alt-up';
		}
		return '';
	}

	function GetDocs() {
		$http.post(config.base, {
			"request": "GetUserDocs"
		}).then(function (r) {
			$scope.docs = r.data.data;
		});

		$http.post(config.base, {
			"request": "GetUserDocsAll"
		}).then(function (r) {
			$scope.adocs = r.data.data;
		});
	}

	$scope.view_full_detail = function (v) {
		$("#modal").modal('show');
		$scope.vfd = v;
	}

	$scope.VerifyDoc = function (type, v) {
		let data = {
			"request": "DocVerification",
			"email": v.email,
			"doc_name": v.doc_name,
			"comment": $scope.comment,
			"type": type
		};
		$http.post(config.base, data).then(function (r) {
			$("#modal").modal('hide');
			swal.fire({
				type: r.data.status,
				text: r.data.message
			});
			$scope.comment = "";
			GetDocs();
		});
	}
}]);

bgd.controller('setting', ['$scope', '$http', function ($scope, $http) {
	$scope.password_strength = "enter a strong password";
	$scope.ex_password = "(ex: Example@1234$)"

	$scope.updatePassword = function (password) {
		$http.post(config.base, {
			"request": "Update_Password",
			"password": password
		}).then(function (r) {
			if (r.data.status === "success") {
				swal.fire({
					type: "success",
					text: r.data.message
				});
			} else {
				swal.fire({
					type: "error",
					text: r.data.message
				});
			}
		});
	}

	$scope.checkPassword = function (password) {
		strength = PasswordStrength(password);
		if (strength > 80)
			$scope.password_strength = "Password Strong";
		else if (strength > 60)
			$scope.password_strength = "Password Good";
		else if (strength > 30)
			$scope.password_strength = "Password Weak";
		else
			$scope.password_strength = "enter a strong password";
	}

	$scope.checkconfirmpassword = function (password, cpassword) {
		if (password !== cpassword) {
			$scope.cPassword_status = true;
			$scope.cPassword_message = "password mismatch";
		} else {
			$scope.cPassword_status = false;
			$scope.cPassword_message = "";
		}
	}
}]);

bgd.controller('finance', ['$scope', '$http', 'Upload', function ($scope, $http, Upload) {
	GetClientList();
	$scope.clients = [];
	$scope.accounts = [];
	$scope.disabled = false;
	$scope.started = false;
	$scope.email = "";

	function GetClientList() {
		let data = {
			"request": "GetClients"
		};
		$http.post(config.base, data).then(function (r) {
			$scope.clients = angular.fromJson(r.data.data);
		});
	}

	$scope.GetAccountList = function (email, name) {
		let data = {
			"request": "GetAccountList",
			"email": email,
			"name" : name
		};
		$http.post(config.base, data).then(function (r) {
			$scope.accounts = angular.fromJson(r.data.data);
		});
		$scope.email = email;
		$scope.name = name;
	}

	$scope.accountCheck = function (login) {
		let data = {
			"request": "GetAccountDetails",
			"login": login,
			"type": "live"
		};
		$http.post(config.base, data).then(function (r) {
			$scope.account_details = angular.fromJson(r.data.data);
		});
	}

	$scope.Deposit = function (operation, email, login, amount, note) {
		$scope.disabled = true;
		let data = {
			"request": "DirectDeposit",
			"login": login,
			"operation": (operation === 1 ? 'balance' : 'credit'),
			"email": $scope.email,
			"amount": amount,
			"comment": note
		};
		$http.post(config.base, data).then(function (r) {
			$scope.disabled = false;
			swal.fire({
				type: r.data.status,
				text: r.data.message
			});
			$scope.amount = "";
			$scope.note = "";
		});
	}

	$scope.WithdrawAmount = function (login, amount, comment, operation) {
		$scope.disabled = true;
		let data = {
			"request": "withdraw",
			"login": login,
			"amount": amount,
			"detail": comment,
			"email": $scope.email,
			"operation": (operation === 1 ? 'balance' : 'credit'),
		};
		$http.post(config.base, data).then(function (r) {
			$scope.disabled = false;
			swal.fire({
				type: r.data.status,
				text: r.data.message
			});
			$scope.amount = "";
			$scope.note = "";
		});
	}
}]);

bgd.controller('report_deposit', ['$scope', '$http', function ($scope, $http) {
	$scope.report = [];
	depositReport();
	$scope.startDate = new Date('01/01/19');
	$scope.endDate = new Date();
	$scope.currentPage = 0;
	$scope.itemsPerPage = 10;
	$scope.pagingOptions = [10, 25, 50, 100];
	$scope.totalItems = $scope.report.length;
	$scope.pages = function () {
		return Math.ceil($scope.report.length / $scope.itemsPerPage);
	};

	function depositReport() {
		let data = {
			"request": "GetDepositDetailsAll"
		};
		$http.post(config.base, data).then(function (r) {
			$scope.report = angular.fromJson(r.data.data);
		});
	}

	$scope.view_full_detail = function (v) {}
}]);

bgd.controller('report_withdraw', ['$scope', '$http', function ($scope, $http) {
	$scope.report = [];
	withdrawReport();
	$scope.startDate = new Date('01/01/19');
	$scope.endDate = new Date();
	$scope.currentPage = 0;
	$scope.itemsPerPage = 10;
	$scope.pagingOptions = [10, 25, 50, 100];
	$scope.totalItems = $scope.report.length;
	$scope.pages = function () {
		return Math.ceil($scope.report.length / $scope.itemsPerPage);
	};

	function withdrawReport() {
		let data = {
			"request": "GetWithdrawDetailsAll"
		};
		$http.post(config.base, data).then(function (r) {
			$scope.report = angular.fromJson(r.data.data);
		});
	}

	$scope.view_full_detail = function (v) {}
}]);

bgd.controller('ib_commission_report', ['$scope', '$http', function ($scope, $http) {
	$scope.ib_commission_list = [];
	GetIBCommission();

	function GetIBCommission() {
		let data = {
			"request": "Get_IB_Commission"
		};
		$http.post(config.base, data).then(function (r) {
			$scope.ib_commission_list = r.data.data;
		});
	}
}]);

bgd.controller('ib_accounts', ['$scope', '$http', function ($scope, $http) {
	$scope.ib_accounts = [];
	GetIBAccounts();
	$scope.startDate = new Date('01/01/19');
	$scope.endDate = new Date();

	$scope.currentPage = 0;
	$scope.itemsPerPage = 10;
	$scope.pagingOptions = [10,15, 25, 50, 100, 500, 1000];
	$scope.totalItems = $scope.ib_accounts.length;
	$scope.pages = function () {
		return Math.ceil($scope.ib_accounts.length / $scope.itemsPerPage);
	};

	function GetIBAccounts() {
		let data = {
			"request": "Get_IB_Accounts"
		};
		$http.post(config.base, data).then(function (r) {
			$scope.ib_accounts = r.data.data;
		});
	}
}]);

bgd.controller('ib_verification', ['$scope', '$http', function ($scope, $http) {
	$scope.docs = [];

	GetIBDocs();
	$scope.startDate = new Date('01/01/2019');
	$scope.endDate = new Date();
	$scope.currentPage1 = 0;
	$scope.itemsPerPage1 = 10;
	$scope.pagingOptions1 = [10, 25, 50, 100];
	$scope.totalItems1 = $scope.docs.length;
	$scope.pages1 = function () {
		return Math.ceil($scope.docs.length / $scope.itemsPerPage1);
	};
	$scope.sStartDate = new Date('01/01/2019');
	$scope.eEndDate = new Date();
	$scope.adocs = [];
	$scope.currentPage2 = 0;
	$scope.itemsPerPage2 = 10;
	$scope.pagingOptions2 = [10, 25, 50, 100];
	$scope.totalItems2 = $scope.adocs.length;
	$scope.pages2 = function () {
		return Math.ceil($scope.adocs.length / $scope.itemsPerPage2);
	};

	function GetIBDocs() {
		$http.post(config.base, {
			"request": "GetIBDocs"
		}).then(function (r) {
			$scope.docs = r.data.data;
		});

		$http.post(config.base, {
			"request": "GetIBDocsAll"
		}).then(function (r) {
			$scope.adocs = r.data.data;
		});
	}

	$scope.view_full_detail = function (v) {
		$("#modal").modal('show');
		$scope.vfd = v;
	}

	$scope.VerifyDoc = function (type, v) {
		let data = {
			"request": "IB_Doc_Verification",
			"email": v.email,
			"doc_name": v.doc_name,
			"comment": $scope.comment,
			"type": type
		};
		$http.post(config.base, data).then(function (r) {
			$("#modal").modal('hide');
			swal.fire({
				type: r.data.status,
				text: r.data.message
			});
			$scope.comment = "";
			GetIBDocs();
		});
	}
}]);

bgd.controller('ib_report_withdraw', ['$scope', '$http', function ($scope, $http) {
	$scope.report_withdraw = [];
	withdrawReport();
	$scope.currentPage = 0;
	$scope.itemsPerPage = 10;
	$scope.pagingOptions = [10, 25, 50, 100];
	$scope.totalItems = $scope.report_withdraw.length;
	$scope.pages = function () {
		return Math.ceil($scope.report_withdraw.length / $scope.itemsPerPage);
	};

	function withdrawReport() {
		let data = {
			"request": "Get_IB_Withdraw_Details_All"
		};
		$http.post(config.base, data).then(function (r) {
			$scope.report_withdraw = angular.fromJson(r.data.data);
		});
	}

	$scope.view_full_detail = function (v) {}
}]);

bgd.controller('commission_report', ['$scope', '$http', function ($scope, $http) {
	$scope.commissions = [];
	$scope.ib_accounts = [];
	$scope.client_accounts = [];
	$scope.trade_accounts = [];	

	$scope.currentPage = 0;
	$scope.itemsPerPage = 10;
	$scope.pagingOptions = [10, 25, 50, 100];
	$scope.totalItems = $scope.commissions.length;
	$scope.pages = function () {
		return Math.ceil($scope.commissions.length / $scope.itemsPerPage);
	};

	//Get IB list by IB Level type
	$scope.get_ib_list = function (type) {
		GetIBAccounts(type);
	}

	//Get Clients by select IB
	$scope.get_clients_by_ib = function (ib_email, type) {
		GetClientAccounts(ib_email, type);
	}

	//Get Trading account by selected client
	$scope.get_trade_account_by_client = function (client_email) {
		GetTradeAccounts(client_email);
	}

	//Get Commission history by login 
	$scope.get_ib_commission = function (login, type) {
		TradeCommission(login, type);
	}	

	function GetIBAccounts(type) {
		let data = {
			"request": "get_ib_accounts_by_level",
			"level": type,
		};
		$http.post(config.base, data).then(function (r) {
			$scope.ib_accounts = r.data.data;
		});
	}

	function GetClientAccounts(ib_email, type) {
		let data = {
			"request": "get_client_accounts_by_ib",
			"ib": ib_email,
			"level": type,
		};
		$http.post(config.base, data).then(function (r) {
			$scope.client_accounts = r.data.data;
		});
	}	

	function GetTradeAccounts(email) {
		let data = {
			"request": "get_trade_accounts_by_client",
			"email": email,
		};
		$http.post(config.base, data).then(function (r) {
			$scope.trade_accounts = r.data.data;
		});
	}	

	function TradeCommission(login, type) {
		let data = {
			"request": "Get_Trade_Commission",
			"login": login,
			"level": type,
		};
		$http.post(config.base, data).then(function (r) {
			$scope.commissions = angular.fromJson(r.data.data);
		});
	}

	$scope.exportToExcel = function (tableId) {
		var exportHref = Excel.tableToExcel(tableId, 'WireWorkbenchDataExport');
		$timeout(function () {
			location.href = exportHref;
		}, 100);
	}
}]);

bgd.controller('ib_settings', ['$scope', '$http', function($scope, $http) {
	$scope.commissions = [];
	$scope.ib_accounts = [];

	$scope.ib_accounts_ta = [];
	$scope.client_accounts = [];
	$scope.trade_accounts = [];	

	$scope.ib_commission = 0;

	$scope.btn_disabled = false;
	$scope.cp_btn_disabled = false;

	$scope.ib1_commission = 0;
	$scope.ib2_commission = 0;
	$scope.ib3_commission = 0;
	$scope.ib4_commission = 0;	

	//Get IB list by IB Level type
	$scope.get_ib_list = function (type) {
		GetIBAccounts(type);
	}	

	function GetIBAccounts(type) {
		let data = {
			"request": "get_ib_accounts_by_level",
			"level": type,
		};
		$http.post(config.base, data).then(function (r) {
			$scope.ib_accounts = r.data.data;
		});
	}	

	$scope.get_ib_commission = function (email, ib_level) {
		let data = {
			"request": "get_ib_commission",
			"ib_level": ib_level,
			"ib_email": email,
		};
		$http.post(config.base, data).then(function(r){
			$scope.ib_commission = r.data.message;
		});
	}

	$scope.update_ib_commission = function (type, amount, comment, ib_email, ib_level, current_commission) {
		$scope.btn_disabled = true;

		if (ib_level === undefined) {
			show_alert("Select IB Type", "warning");
			return;
		}
		if (ib_email === undefined) {
			show_alert("Select IB Account", "warning");
			return;
		}
		if (amount <= 0 || amount === undefined) {
			show_alert("enter valid amount", "warning");
			return;
		}
		if (comment === undefined) {
			show_alert("enter comment", "warning");
			return;
		}

		let data = {
			"request": "update_ib_commission",
			 "amount": amount,
			 "comment": comment,
			 "ib_email": ib_email,
			 "ib_level": ib_level,
			 "current_commission": current_commission,
			 "operation_type": type,
		};
		$http.post(config.base, data).then(function(r) {
			if (r.data.status === "success") {
				$scope.ib_commission = 0;
				$scope.amount = 0;
				$scope.comment = "";
				$scope.ib_type = null;
				$scope.ib_email = null;
			}
			$scope.btn_disabled = false;
			show_alert(r.data.message, r.data.status);
		});
	}

	$scope.get_ib_list_ta = function (type) {
		get_ib_accounts(type);
	}

	function get_ib_accounts(type) {
		let data = {
			"request": "get_ib_accounts_by_level",
			"level": type,
		};
		$http.post(config.base, data).then(function (r) {
			$scope.ib_accounts_ta = r.data.data;
		});
	}

	//Get Clients by select IB
	$scope.get_clients_by_ib = function (ib_email, type) {
		GetClientAccounts(ib_email, type);
	}

	function GetClientAccounts(ib_email, type) {
		let data = {
			"request": "get_client_accounts_by_ib",
			"ib": ib_email,
			"level": type,
		};
		$http.post(config.base, data).then(function (r) {
			$scope.client_accounts = r.data.data;
		});
	}	

	//Get Trading account by selected client
	$scope.get_trade_account_by_client = function (client_email) {
		GetTradeAccounts(client_email);
	}

	function GetTradeAccounts(email) {
		let data = {
			"request": "get_trade_accounts_by_client",
			"email": email,
		};
		$http.post(config.base, data).then(function (r) {
			$scope.trade_accounts = r.data.data;
		});
	}

	$scope.get_ib_commission_on_trade_account = function (login) {
		let data = {
			"request": "get_ib_commission_on_trade_account",
			"login": login,
		};
		$http.post(config.base, data).then(function(r) {
			$scope.ib1_commission = r.data.data.ib1;
			$scope.ib2_commission = r.data.data.ib2;
			$scope.ib3_commission = r.data.data.ib3;
			$scope.ib4_commission = r.data.data.ib4;
		});
	}

	$scope.update_ib_commission_on_trade_account = function (ib1, ib2, ib3, ib4, login = 0) {
		if (login === undefined) {
			show_alert("Select Trade Account", "warning");
			return;
		}

		$scope.cp_btn_disabled = true;
		let data = {
			"request": "update_ib_commission_on_trade_account",
			"ib1": ib1,
			"ib2": ib2,
			"ib3": ib3,
			"ib4": ib4,
			"login": login,
		};
		$http.post(config.base, data).then(function(r) {
			if (r.data.status === "success") {
				$scope.ib1_commission = 0;
				$scope.ib2_commission = 0;
				$scope.ib3_commission = 0;
				$scope.ib4_commission = 0;	
				
				$scope.ib_type_ta = "";
				$scope.ib_accounts_ta = [];
				$scope.client_accounts = [];
				$scope.trade_accounts = [];				
			}
			$scope.cp_btn_disabled = false;
			show_alert(r.data.message, r.data.status);
		});
	}

}]);

bgd.controller('pamm_manager_list', ['$scope', '$http', function ($scope, $http) {
	$scope.pamm_manager_list = [];

	$scope.currentPage = 0;
	$scope.itemsPerPage = 10;
	$scope.pagingOptions = [10, 25, 50, 100];
	$scope.totalItems = $scope.pamm_manager_list.length;

	$scope.pages = function () {
		return Math.ceil($scope.pamm_manager_list.length / $scope.itemsPerPage);
	};

	$scope.startDate = new Date('01/01/2019');
	$scope.endDate = new Date();

	get_pamm_manager();

	function get_pamm_manager() {
		let data = {
			'request': 'get_pamm_manager_list'
		};
		$http.post(config.base, data).then(function (r) {
			$scope.pamm_manager_list = r.data.data;

		});
	}
}]);

bgd.controller('pamm_manager_detail_analysis', ['$scope', '$http', '$routeParams', function ($scope, $http, $routeParams) {
	$scope.view_full_detail = function (v) {
		$("#modal").modal('show');
		$scope.container = v;
	}

	function ctrl($scope) {
		$scope.toggle = function () {
			$scope.state = !$scope.state;
		};
	}
	ctrl($scope);
	Highcharts.chart('container', {

		title: {
			text: 'Profit and Withdrawl'
		},
		yAxis: {
			title: {
				text: 'Profit And Loss'
			}
		},
		credits: {
			enabled: false
		},
		series: [{
			name: 'Deposit',
			data: [43934, 52503, 57177, 69658, 97031, 119931, 137133, 154175]
		}, {
			name: 'Equity',
			data: [24916, 24064, 29742, 29851, 32490, 30282, 38121, 40434]
		}],
	});
	Highcharts.chart('columnContainer', {
		chart: {
			type: 'column'
		},
		title: {
			text: 'Deposit And Withdrawl'
		},
		credits: {
			enabled: false
		},
		xAxis: {
			categories: [
				'Jan',
				'Feb',
				'Mar',
				'Apr',
				'May',
				'Jun',
				'Jul',
				'Aug',
				'Sep',
				'Oct',
				'Nov',
				'Dec'
			],
			crosshair: true
		},
		yAxis: {
			min: 0,
			title: {
				text: 'profit and Equity'
			}
		},
		series: [{
			name: 'Withdrawl',
			data: [49.9, 71.5, 106.4, 129.2, 144.0, 176.0, 135.6, 148.5, 216.4, 194.1, 95.6, 54.4]

		}]
	});
	Highcharts.chart('pieContainer', {
		chart: {
			plotBackgroundColor: null,
			plotBorderWidth: null,
			plotShadow: false,
			type: 'pie'
		},
		title: {
			text: 'Browser market shares in January, 2019'
		},
		tooltip: {
			pointFormat: '{series.name}: <b>{point.percentage:.1f}%</b>'
		},
		credits: {
			enabled: false
		},
		series: [{
			name: 'Brands',
			colorByPoint: true,
			data: [{
				name: 'Chrome',
				y: 62,
				sliced: true,
				selected: true
			}, {
				name: 'Opera',
				y: 2
			}, {
				name: 'Internet Explorer',
				y: 12
			}, {
				name: 'Edge',
				y: 8
			}, {
				name: 'Firefox',
				y: 11
			}, {
				name: 'Safari',
				y: 5
			}]
		}]
	});
}]);

bgd.controller('pamm_clients_list', ['$scope', '$http', '$routeParams', function ($scope, $http, $routeParams) {
	$scope.pamm_clients_list = [];
	$scope.pamm_manager_uid = $routeParams.pamm_manager_uid || 'all';
	$scope.currentPage = 0;
	$scope.itemsPerPage = 10;
	$scope.pagingOptions = [10, 25, 50, 100];
	$scope.totalItems = $scope.pamm_clients_list.length;

	$scope.pages = function () {
		return Math.ceil($scope.pamm_clients_list.length / $scope.itemsPerPage);
	};

	$scope.startDate = new Date('01/01/2019');
	$scope.endDate = new Date();

	get_pamm_client();

	function get_pamm_client() {
		let data = {
			'request': 'get_pamm_client_list',
			'pamm_manager_uid': $scope.pamm_manager_uid,
		};
		$http.post(config.base, data).then(function (r) {
			$scope.pamm_clients_list = r.data.data;
		});
	}
}]);

bgd.controller('investment_clients_list', ['$scope', '$http', function ($scope, $http) {
	$scope.investment_clients_list = [];

	$scope.currentPage = 0;
	$scope.itemsPerPage = 10;
	$scope.pagingOptions = [10, 25, 50, 100];
	$scope.totalItems = $scope.investment_clients_list.length;

	$scope.pages = function () {
		return Math.ceil($scope.investment_clients_list.length / $scope.itemsPerPage);
	};

	$scope.startDate = new Date('01/01/2019');
	$scope.endDate = new Date();

	get_investment_client();

	function get_investment_client() {
		let data = {
			'request': 'get_investment_client_list'
		};
		$http.post(config.base, data).then(function (r) {
			$scope.investment_clients_list = r.data.data;
		});
	}

}]);

bgd.controller('investment_plans', ['$scope', '$http', function ($scope, $http) {
	$scope.investment_plans_list = [];
	$scope.currentPage = 0;
	$scope.itemsPerPage = 10;
	$scope.pagingOptions = [10, 25, 50, 100];
	$scope.totalItems = $scope.investment_plans_list.length;

	$scope.pages = function () {
		return Math.ceil($scope.investment_plans_list.length / $scope.itemsPerPage);
	};

	$scope.startDate = new Date('01/01/2019');
	$scope.endDate = new Date();

	get_investment_plans();

	function get_investment_plans() {
		let data = {
			'request': 'get_investment_plans'
		};
		$http.post(config.base, data).then(function (r) {
			$scope.investment_plans_list = r.data.data;
		});
	}

	$scope.create_new_investment = function (name, monthly_return, min_deposit, rrp) {
		let data = {
			'request': 'create_new_investment',
			'investment_name': name,
			'monthly_return': monthly_return,
			'min_deposit': min_deposit,
			'rrp': rrp,
		};
		$http.post(config.base, data).then(function (r) {
			swal.fire({
				type: r.data.status,
				text: r.data.message
			});

			if (r.data.status === "success") {
				get_investment_plans();
			}
		});
	}

}]);

/*------------------------------- Global Custom Function -------------------------------*/
function PasswordStrength(pass) {
	var score = 0;
	if (!pass)
		return score;

	// award every unique letter until 5 repetitions
	var letters = new Object();
	for (var i = 0; i < pass.length; i++) {
		letters[pass[i]] = (letters[pass[i]] || 0) + 1;
		score += 5.0 / letters[pass[i]];
	}

	// bonus points for mixing it up
	var variations = {
		digits: /\d/.test(pass),
		lower: /[a-z]/.test(pass),
		upper: /[A-Z]/.test(pass),
		nonWords: /\W/.test(pass),
	}

	variationCount = 0;
	for (var check in variations) {
		variationCount += (variations[check] == true) ? 1 : 0;
	}
	score += (variationCount - 1) * 10;

	return parseInt(score);
}

function toggleFullScreen() {
	var a = $(window).height() - 10;

	if (!document.fullscreenElement && !document.mozFullScreenElement && !document.webkitFullscreenElement) {
		if (document.documentElement.requestFullscreen) {
			document.documentElement.requestFullscreen();
		} else if (document.documentElement.mozRequestFullScreen) {
			document.documentElement.mozRequestFullScreen();
		} else if (document.documentElement.webkitRequestFullscreen) {
			document.documentElement.webkitRequestFullscreen(Element.ALLOW_KEYBOARD_INPUT);
		}
	} else {
		if (document.cancelFullScreen) {
			document.cancelFullScreen();
		} else if (document.mozCancelFullScreen) {
			document.mozCancelFullScreen();
		} else if (document.webkitCancelFullScreen) {
			document.webkitCancelFullScreen();
		}
	}
	$('.full-screen').toggleClass('icon-maximize');
	$('.full-screen').toggleClass('icon-minimize');
}

function cal_years() {
	var year = new Date().getFullYear();
	var range = [];
	range.push(year);
	for (var i = 1; i < 5; i++) {
		range.push(year - i);
	}
	return range;
}

function show_alert(text, type) {
	swal.fire({
		text: text,
		type: type,
	})
}

/***************** Angular Filter Custom Functions *********************/

/* Pagination Filter */
bgd.filter('page_from', function () {
	return function (input, start) {
		if (!input || !input.length) {
			return;
		}
		start = +start; //parse to int
		return input.slice(start);
	}
});

/* Date Filter */
bgd.filter("date_filter", function ($filter) {
	return function (data, sDate, eDate, date_param) {
		return $filter('filter')(data, date_param, function (v) {
			var date = moment(v);
			return date >= moment(sDate) && date <= moment(eDate);
		});
	};
});

/* Total Sum filter */
bgd.filter('sum_by_column', function () {
	return function (collection, column) {
		var total = 0;
		collection.forEach(function (item) {
			total += parseInt(item[column]);
		});
		return total;
	};
})