<?php
session_start();
error_reporting(0);
include('config.php');
if(strlen($_SESSION['alogin'])==0)
{
  header('location:index.php');
}
else
{
  if(isset($_POST['addpayments']))
  {
    $eid=intval($_GET['pid']);
    $payment_mode=$_POST['payment_mode'];
    $bank_name=$_POST['bank_name'];
    $account_holdername=$_POST['account_holdername'];
    $account_detail=$_POST['account_detail'];
    $account_type=$_POST['account_type'];
    $sql="update available_payment set payment_mode=:payment_mode,bank_name=:bank_name,account_holdername=:account_holdername,account_detail=:account_detail,account_type=:account_type where id=:eid";
    $query = $dbh->prepare($sql);
    $query->bindParam(':payment_mode',$payment_mode,PDO::PARAM_STR);
    $query->bindParam(':bank_name',$bank_name,PDO::PARAM_STR);
    $query->bindParam(':account_holdername',$account_holdername,PDO::PARAM_STR);
    $query->bindParam(':account_detail',$account_detail,PDO::PARAM_STR);
    $query->bindParam(':account_type',$account_type,PDO::PARAM_STR);
    $query->bindParam(':eid',$eid,PDO::PARAM_STR);
    $query->execute();
    echo "<script>
      alert('Perfect Money Payment Gateway Updated Successfully');
      </script>";
} 
?>
  <?php include('header.php');?>

  <body>
    <!-- Preloader End Here -->
    <div id="wrapper" class="wrapper bg-ash">
      <?php include('main_header.php');?>
      <!-- Page Area Start Here -->
      <div class="dashboard-page-one">
        <?php include('side_header.php');?>
        <!-- Sidebar Area End Here -->
        <div class="dashboard-content-one">
          <!-- Breadcubs Area End Here --><br>
          <div class="row gutters-20">
            <div class="col-xl-12 col-sm-12 col-12">
              <div class="dashboard-summery-one mg-b-20">
                <div class="row align-items-center">
                  <div class="col-6">
                    <button type="button" class="btn-fill-lmd radius-30 text-light shadow-dark-pastel-green bg-dark-pastel-green">Payment Gateway Account</button>
                  </div>
                  <div class="col-6">
                    <div class="item-content">
                      <a href="dashboard.php" class="btn-fill-lmd radius-30 text-light shadow-dodger-blue bg-orange-peel">Get Back</a>
                    </div>
                  </div>
                </div>
              </div>
            </div>
          </div>
          <div class="row">
            <div class="col-md-7">
              <div class="row">
                <div class="col-md-12 card card-body">
                  <ul class="nav nav-pills nav-pills-primary" id="pills-tab" role="tablist" style="box-shadow: 0 4px 8px 0 rgba(0, 0, 0, 0.08), 0 6px 20px 0 rgba(0, 0, 0, 0) !important;padding-left: 20px;padding-top: 10px;padding-bottom: 10px;">
                    <li class="nav-item">
                      <a class="nav-link active" id="pills-home-tab" data-toggle="pill" href="#ewallet" role="tab" aria-controls="pills-home" aria-selected="true">
                    Update Perfect Money Gateway
                  </a>
                    </li>
                  </ul>
                  <br>
                  <div class="tab-content" id="pills-tabContent" style="border: 0px solid #c9ccd7;">
                    <div class="tab-pane fade active show" id="ewallet" role="tabpanel" aria-labelledby="pills-home-tab">
                      <?php
                      $eid=intval($_GET['pid']);
                      $sql = "SELECT * from  available_payment where id=:eid";
                      $query = $dbh -> prepare($sql);
                      $query -> bindParam(':eid',$eid, PDO::PARAM_STR);
                      $query->execute();
                      $results=$query->fetchAll(PDO::FETCH_OBJ);
                      $cnt=1;
                      if($query->rowCount() > 0)
                      {
                        foreach($results as $result)
                      {?>
                        <form method="post" enctype="multipart/form-data">
                          <div class="form-group">
                            <label class="form-label">Select Payment Mode</label>
                            <select name="payment_mode" class="form-control mb-1" style="border:1px solid #e3ebf3;" required>
                        <option value="<?php echo htmlentities($result->payment_mode);?>"><?php echo htmlentities($result->payment_mode);?></option>
                        <option value="Neteller">Neteller</option>
                        <option value="Skrill">Skrill</option>
                        <option value="Perfectmoney">Perfectmoney</option>
                        <option value="Bitcoin">Bitcoin</option>
                      </select>
                          </div>
                          <div class="form-group">
                            <label class="form-label">Name</label>
                            <input type="text" value="<?php echo htmlentities($result->bank_name);?>" class="form-control" autocomplete="off" name="bank_name" maxlength="300">
                          </div>
                          <div class="form-group">
                            <label class="form-label">Account Holder Name</label>
                            <input type="text" value="<?php echo htmlentities($result->account_holdername);?>" class="form-control" autocomplete="off" name="account_holdername" maxlength="300">
                          </div>
                          <div class="form-group">
                            <label class="form-label">ewallet Address</label>
                            <input type="text" value="<?php echo htmlentities($result->account_detail);?>" class="form-control" autocomplete="off" name="account_detail" maxlength="300">
                          </div>
                          <div class="form-group">
                            <label class="form-label">Select Currency</label>
                            <select name="account_type" class="form-control mb-1" style="border:1px solid #e3ebf3;" required>
                        <option value="<?php echo htmlentities($result->account_type);?>"><?php echo htmlentities($result->account_type);?></option>
                        <option value="INR">INR</option>
                        <option value="USD">USD</option>
                        <option value="EUR">EUR</option>
                      </select>
                          </div>
                          <input type='submit' name="addpayments" style="padding: 5px 20px;font-size: 15px;" class="btn btn-success mt-2" value='Update Perfect Money Payment Gateway'>
                        </form> <br>
                        <?php }}?>
                    </div>
                  </div>
                </div>
              </div>
            </div>
            <div class="col-md-5" style="margin-top: 10px;">
              <div class="row">
                <?php
          $sql = "SELECT id from available_payment";
          $query = $dbh -> prepare($sql);
          $query->execute();
          $results=$query->fetchAll(PDO::FETCH_OBJ);
          $branchcount=$query->rowCount();
          ?>
                  <div class="col-md-12">
                    <div class="dashboard-summery-one mg-b-20" style="border-left:5px solid #1de9b6;">
                      <a href="update_paymentgateway.php">
                        <div class="row align-items-center">
                          <div class="col-4">
                            <div class="item-icon bg-light-blue">
                              <i class="flaticon-multiple-users-silhouette text-blue"></i>
                            </div>
                          </div>
                          <div class="col-8">
                            <div class="item-content">
                              <div class="item-title"><b>Total Payment Methods</b></div>
                              <div class="item-number" style="font-size:16px;">
                                <span class="counter" data-num="193000"><?php echo htmlentities($branchcount);?></span>
                              </div>
                            </div>
                          </div>
                        </div>
                      </a>
                    </div>
                  </div>
                  <div class="col-sm-12">
                    <div class="dashboard-summery-one mg-b-20" style="border-left:5px solid #1de9b6;">
                      <a href="update_paymentgateway.php">
                        <div class="row align-items-center">
                          <div class="col-4">
                            <div class="item-icon bg-light-blue">
                              <i class="flaticon-multiple-users-silhouette text-blue"></i>
                            </div>
                          </div>
                          <div class="col-8">
                            <div class="item-content">
                              <div class="item-title"><b>Update Payment Gateway</b></div>
                              <div class="item-number" style="font-size:16px;">
                                <span class="counter" data-num="193000"></span>
                              </div>
                            </div>
                          </div>
                        </div>
                      </a>
                    </div>
                  </div>
              </div>
            </div>
          </div>
          <?php include('footer.php');?>
          <?php } ?>