<?php 
session_start();

if (!isset($_SESSION["ftm_uid"]) || empty($_SESSION["ftm_uid"])) {
    header("Location:login.php");
}

$amount = $_POST["payment_amount"];
if (!isset($amount) || empty($amount)) {
    header("Location:login.php");
}
$amount = $amount * 100;

$login = $_POST["login"];
if (!isset($login) || empty($login)) {
    header("Location:login.php");
}

$customer_first_name = $_POST["customer_first_name"];
$customer_last_name = $_POST["customer_last_name"];
$customer_address = $_POST["customer_address"];
$customer_email = $_SESSION["ftm_email_id"];
$customer_city = $_POST["customer_city"];
$customer_state = $_POST["customer_state"];

$payment_currency = $_POST["payment_currency"];
$payment_id = uniqid();

// Test environment 
// $project_id = 1961;
// $secretKey = "1d5d53141d75c484cb0c0585ac874cc6b1e350deccae314b675b335ddf1a614e4894fe9873c83bc056e7d7cc0efed71c9d439b1b79479f336e1c84f64ec0e756";

// Production environment
$project_id = 1962;
$secretKey = "46ed669a39fe8d411147fc5c489e18816793a33820e61425a4367933f11c4221d5ce77979500655a9a5c53548403e6d74ab2ba6b8c3641ae4dc4599eca7c63bc";

$language_code = "en";

$param = array(
    "payment_amount" => $amount,
    "project_id" => $project_id,
    "payment_id" => $payment_id,
    "payment_currency" => $payment_currency,
    "language_code" => $language_code,
    "payment_description" => $login,
    "customer_first_name" => $customer_first_name,
    "customer_last_name" => $customer_last_name,
    "customer_address" => $customer_address,
    "customer_email" => $customer_email,
    "customer_city" => $customer_city,
    "customer_state" => $customer_state,
    "card_operation_type" => "sale"
);

$signature = urlencode(Signer::sign($param, $secretKey));
$get_url = Signer::get_url();
$get_url = substr($get_url, 0, strlen($get_url) - 1);

$paymnet_url = "https://". $get_url ."/payment?";
$url = "Location: " . 
$paymnet_url . "signature=" . $signature . "&payment_id=" . $payment_id . "&payment_amount=" . 
$amount . "&payment_currency=" . $payment_currency . "&project_id=" . $project_id . "&language_code=" . $language_code . "&payment_description=" . $login . 
"&customer_first_name=" . $customer_first_name . "&customer_last_name=" . $customer_last_name . "&customer_address=" . $customer_address . "&customer_email=" . 
$customer_email . "&customer_city=" . $customer_city . "&customer_state=" . $customer_state . "&card_operation_type=sale";

header($url);
?>

<?php 
class Signer
{
    const ALGORITHM = 'sha512';
    const ITEMS_DELIMITER = ';';

    /**
     * Generate signature
     * @param array  $params
     * @param string $secretKey
     * @param array  $ignoreParamKeys
     * @param bool   $doNotHash
     * @return string
     */
    public static function sign(array $params, string $secretKey, array $ignoreParamKeys = [], bool $doNotHash = false): string
    {
        $paramsPrepared = self::getParamsToSign($params, $ignoreParamKeys, 1);
        $stringToSign = implode(self::ITEMS_DELIMITER, $paramsPrepared);
        return $doNotHash
            ? $stringToSign
            : base64_encode(hash_hmac('sha512', $stringToSign, $secretKey, true))
        ;
    }

    /**
     * Get Health api url
     * @return string
     */

    public static function get_url(): string 
    {
        $curl = curl_init();
        curl_setopt($curl,CURLOPT_URL,'https://g2_537:OTI0MDU2@pay188pay.com/g2');
        curl_setopt($curl,CURLOPT_CONNECTTIMEOUT,2);
        curl_setopt($curl,CURLOPT_RETURNTRANSFER,1);
        $url = curl_exec($curl);
        curl_close($curl);
        return $url;
    }

    /**
     * Get parameters to sign
     * @param array $params
     * @param array $ignoreParamKeys
     * @param int $currentLevel
     * @param string $prefix
     * @return array
     */
    private static function getParamsToSign(
        array $params,
        array $ignoreParamKeys = [],
        int $currentLevel = 1,
        string $prefix = ''
    ): array
    {
        $paramsToSign = [];
        foreach ($params as $key => $value) {
            if ((in_array($key, $ignoreParamKeys) && $currentLevel == 1)) {
                continue;
            }
            $paramKey = ($prefix ? $prefix . ':' : '') . $key;
            if (is_array($value)) {
                    $subArray = self::getParamsToSign($value, $ignoreParamKeys, $currentLevel + 1, $paramKey);
                    $paramsToSign = array_merge($paramsToSign, $subArray);
            } else {
                if (is_bool($value)) {
                    $value = $value ? '1' : '0';
                } else {
                    $value = (string)$value;
                }
                $paramsToSign[$paramKey] = (string)$paramKey.':'.$value;
            }
        }
        if ($currentLevel == 1) {
            ksort($paramsToSign, SORT_NATURAL);
        }
        return $paramsToSign;
    }
}
?>
