<?php
//+------------------------------------------------------------------+
//|                                             MetaTrader 5 Web API |
//|                   Copyright 2000-2020, MetaQuotes Software Corp. |
//|                                        http://www.metaquotes.net |
//+------------------------------------------------------------------+
session_start();
error_reporting(0);
include('config.php');
if(strlen($_SESSION['clogin'])==0)
{
  header('location:login.php');
}
class WebPageForm
{
  const VERIFY_CODE_LENGTH = 5;
  private $user;
  private $verify_code;
  private $root_url;
  private $api;
  /**
   * Construct
   */
  function __construct()
  {
    //---- start session
    session_start();
    //---- initialize
    $this->user = array('password' => '','phone_password' => '','password' => '', 'confirm_password' => '', 'invest_password' => '');
    //---
    $this->root_url = $_SERVER['HTTP_HOST'] . rtrim(dirname($_SERVER['PHP_SELF']), '/\\');
    //---
    $this->api = new MTWebAPI(AGENT, PATH_TO_LOGS);
    $this->api->SetLoggerWriteDebug(IS_WRITE_DEBUG_LOG);
  }
  /**
   * Create web page
   * @return void
   */
  public function CreatePage()
  {
    //---
    if (isset($_REQUEST['a']) && is_array($_REQUEST['a']))
    {
      //--- extract method name
      $methodName = 'On' . key($_REQUEST['a']);
      //--- call the method
      if (method_exists($this, $methodName)) $this->$methodName();
      return;
    }
    $this->Show();
  }
  /**
   * Send email
   * @return void
   */
  private function OnRegister()
  {
    //--- validation request
    if (!isset($_REQUEST['user']) || !is_array($_REQUEST['user']) || !isset($_REQUEST['verify_code']) || empty($_REQUEST['verify_code']) || !isset($_SESSION['verify_code']) || empty($_SESSION['verify_code']))
    {
      include("");
      exit;
    }
    //--- receive input
    $this->user = $_REQUEST['user'];
    $this->verify_code = $_REQUEST['verify_code'];
    //----
    foreach ($this->user as $key => $value) $value = trim($value);
    //--- validation input
    if ($_SESSION['verify_code'] != $this->verify_code || $this->user['password'] != $this->user['confirm_password'] ||  empty($this->user['password']) || !$this->CheckPassword($this->user['password']))
    {
      $error = '';
      if ($_SESSION['verify_code'] != $this->verify_code) $error .= '1. Invalid verify code<br>';
      if ($this->user['password'] != $this->user['confirm_password']) $error .= '2. Password not confirm<br>';
      
      if (empty($this->user['password'])) $error .= 'Empty Password <br>';

      if (!$this->CheckPassword($this->user['password'])) $error .= '3. Password should be Alpha numeric and min 5 words ex: Test@1990,  <br>';
      //---
      $this->GenerateVerifyCode();
      include("nomination1.php");
      exit;
    }
    include("nomination1.php");
     //--- put parameters in our structure
    $new_user = $this->api->UserCreate();
    $new_user->MainPassword = $this->user['password'];
    $new_user->Group = $this->user['group'];
    $new_user->Leverage = $this->user['leverage'];
    $new_user->ZipCode = $this->user['zip'];
    $new_user->Country = $this->user['country'];
    $new_user->State = $this->user['state'];
    $new_user->City = $this->user['city'];
    $new_user->Address = $this->user['address'];
    $new_user->Phone = $this->user['phone'];
    $new_user->Currency = 'USD';
    $new_user->Name = $this->user['name'];
    $new_user->Email = $this->user['email'];
    $new_user->LeadSource = $this->user['refer_email'];
    $new_user->PhonePassword = $this->user['phone_password'];
    $new_user->InvestPassword =$this->user['invest_password'];
    //--- create new account 
    $this->CreateAccount($new_user, $user_server);
    //--- see new login on server
    $new_user->Login = $user_server->Login;
     // Store user to database 
    $account_type=$new_user->Group;
    $currency=$new_user->Currency;
    $trade_id=$new_user->Login;
    $trader_pwd=$new_user->MainPassword;
   $fullname=$new_user->Name;
    $invester_pwd=$new_user->InvestPassword;
    $phone_pwd=$new_user->PhonePassword;
    $leverage=$new_user->Leverage;
    $email=$new_user->Email;
    $ib1=$new_user->LeadSource;
    $sql = "INSERT INTO  liveaccount(email,trade_id,account_type,leverage,currency,trader_pwd,invester_pwd,phone_pwd,ib1)
    VALUES (:email,:trade_id,:account_type,:leverage,:currency,:trader_pwd,:invester_pwd,:phone_pwd,:ib1)";
    $query = $dbh->prepare($sql);
    $query->bindParam(':email',$email,PDO::PARAM_STR);
    $query->bindParam(':trade_id',$trade_id,PDO::PARAM_STR);
    $query->bindParam(':account_type',$account_type,PDO::PARAM_STR);
    $query->bindParam(':leverage',$leverage,PDO::PARAM_STR);
    $query->bindParam(':currency',$currency,PDO::PARAM_STR);
    $query->bindParam(':trader_pwd',$trader_pwd,PDO::PARAM_STR);
    $query->bindParam(':invester_pwd',$invester_pwd,PDO::PARAM_STR);
    $query->bindParam(':phone_pwd',$phone_pwd,PDO::PARAM_STR);
    $query->bindParam(':ib1',$ib1,PDO::PARAM_STR);
    $query->execute();
    $lastInsertId = $dbh->lastInsertId();
    echo "<script>
    alert('Your Trading Live Account Created Successfully');
    </script>";
  
  // start mail send username and password
$toEmail = "$email";
$from = "contact@pipspulsefx.com";
$emailSubject = 'Pips Pulse Capital - Live Account Credentials';
$htmlContent = "
<html>
            <body>
               <table width=\"100%\" border=\"0\" align=\"center\" cellpadding=\"0\" cellspacing=\"0\">
    <!-- START HEADER/BANNER -->
    <tbody>
        <tr>
            <td align=\"center\">
                <table class=\"col-600\" width=\"600\" border=\"0\" align=\"center\" cellpadding=\"0\" cellspacing=\"0\">
                    <tbody>
                        <tr>
                            <td align=\"center\" valign=\"top\" background=\"https://designmodo.com/demo/emailtemplate/images/header-background.jpg\" bgcolor=\"#66809b\" style=\"background-size:cover; background-position:top;height=\"300\">
                                <table class=\"col-600\" width=\"600\" height=\"150\" border=\"0\" align=\"center\" cellpadding=\"0\" cellspacing=\"0\">
                                    <tbody>
                                        <tr>
                                            <td align=\"center\" style=\"line-height: 0px;color:white;font-size:35px;\">
                                               Pips Pulse Capital
                                            </td>
                                        </tr>
                                    </tbody>
                                </table>
                            </td>
                        </tr>
                    </tbody>
                </table>
            </td>
        </tr>
        <!-- END HEADER/BANNER -->
        <!-- START 3 BOX SHOWCASE -->
        <tr>
            <td align=\"center\">
                <table class=\"col-600\" width=\"600\" border=\"0\" align=\"center\" cellpadding=\"0\" cellspacing=\"0\" style=\"padding-left:0px; padding-right:0px; border-left: 1px solid #dbd9d9; border-right: 1px solid #dbd9d9;\">
                    <tbody>
                        <tr>
                            <td height=\"35\"></td>
                        </tr>

                        <tr>
                            <td align=\"center\" style=\"font-family: 'Raleway', sans-serif; font-size:22px; font-weight: bold; color:#2a3a4b;\">Confirm Your E-Mail Address</td>
                        </tr>

                        <tr>
                            <td height=\"40\"></td>
                        </tr>

                        <tr>
                            <td align=\"left\" style=\"font-family: 'Lato', sans-serif; font-size:16px; color:#757575; line-height:38px; font-weight: 800;padding-left:50px;\">
                                Hi $fullname,
                                <br>
                            </td>
                        </tr>
                        <tr>
                            <td align=\"left\" style=\"font-family: 'Lato', sans-serif; font-size:14px; color:#757575; line-height:24px; font-weight: 400;padding-left:50px;\">
                                Welcome to Pips Pulse Capital!
                            </td>
                        </tr>

                        <tr>
                            <td align=\"left\" style=\"font-family: 'Lato', sans-serif; font-size:14px; color:#757575; line-height:24px; font-weight: 400;padding-left:50px;padding-right:50px;\">
                                You are receiving this email because you have created a Live Trading Account.
                                <br>
                                <br>
                            </td>
                        </tr>
                    </tbody>
                </table>
            </td>
        </tr>
       
        <!-- END 3 BOX SHOWCASE -->

        <!-- START AWESOME TITLE -->
        <tr>
            <td align=\"center\">
                <table align=\"center\" class=\"col-600\" width=\"600\" border=\"0\" cellspacing=\"0\" cellpadding=\"0\">
                    <tbody>
                        <tr>
                            <td align=\"center\" style=\"background-color:#2e3f4c;\">
                                <table class=\"col-600\" width=\"600\" align=\"center\" border=\"0\" cellspacing=\"0\" cellpadding=\"0\">
                                    <tbody>
                                        <tr>
                                            <td height=\"33\"></td>
                                        </tr>
                                        <tr>
                                            <td>
                                                <table class=\"col3_one\" width=\"563\" border=\"0\" align=\"right\" cellpadding=\"0\" cellspacing=\"0\">
                                                    <tbody>
                                                        <tr align=\"left\" valign=\"top\">
                                                            <td style=\"font-family: 'Raleway', sans-serif; font-size:22px; color:#ff0062; line-height:40px; font-weight: bold;\">Live Account Credentials. </td>
                                                        </tr>

                                                        <tr>
                                                            <td height=\"5\"></td>
                                                        </tr>

                                                        <tr align=\"left\" valign=\"top\">
                                                            <td style=\"font-family: 'Lato', sans-serif; font-size:14px; color:#fff; line-height:24px; font-weight: 300;\">
                                       <b>                         Login : $trade_id </b><br>
                                                                <br>
                                                            </td>
                                                        </tr>
                                                        <tr>
                                                        <tr align=\"left\" valign=\"top\">
                                                            <td style=\"font-family: 'Lato', sans-serif; font-size:14px; color:#fff; line-height:24px; font-weight: 300;\">
                                                          <b>      Trade Password : $trader_pwd</b><br>
                                                                <br>
                                                            </td>
                                                        </tr>
                                                        <tr align=\"left\" valign=\"top\">
                                                            <td style=\"font-family: 'Lato', sans-serif; font-size:14px; color:#fff; line-height:24px; font-weight: 300;\">
                                                            <b>    Server : Pips Pulse - Live</b>
                                                                <br>
                                                            </td>
                                                        </tr>
                                                            <td height=\"30\"></td>
                                                        </tr>

                                                       
                                                    </tbody>
                                                </table>
                                            </td>
                                        </tr>
                                        <tr>
                                            <td height=\"33\"></td>
                                        </tr>
                                    </tbody>
                                </table>
                            </td>
                        </tr>
                    </tbody>
                </table>
            </td>
        </tr>

       <tr>
            <td align=\"center\">
                <table class=\"col-600\" width=\"600\" border=\"0\" align=\"center\" cellpadding=\"0\" cellspacing=\"0\">

                    <tbody>
                        <tr>
                            <td align=\"center\">
                                <table class=\"col-600\" width=\"600\" border=\"0\" align=\"center\" cellpadding=\"0\" cellspacing=\"0\" style=\"border-left: 1px solid #dbd9d9; border-right: 1px solid #dbd9d9;padding-left:10px;padding-right:10px;\">
                                    <tbody>
                                        <tr>
                                            <td height=\"50\"></td>
                                        </tr>
                                        <tr>
                                            <td align=\"right\">

                                                <table width=\"574‬\" border=\"0\" align=\"left\" cellpadding=\"0\" cellspacing=\"0\" class=\"col2\">
                                                    <tbody>
                                                        <tr>
                                                            <td>
                                                                <table class=\"insider\" width=\"563\" border=\"0\" align=\"center\" cellpadding=\"0\" cellspacing=\"0\">

                                                                    <tbody>
                                                                        <tr align=\"left\">
                                                                            <td style=\"font-family: 'Raleway', sans-serif; font-size:22px; color:#2a3b4c; line-height:30px; font-weight: bold;\">Pips Pulse Capital</td>
                                                                        </tr>

                                                                        <tr>
                                                                            <td height=\"5\"></td>
                                                                        </tr>

                                                                        <tr>
                                                                            <td style=\"font-family: 'Lato', sans-serif; font-size:14px; color:#7f8c8d; line-height:24px; font-weight: 300;\">
                                                                               Pips Pulse Capital has developed a variety of options to make your forex trading even more convenient. We offer live ECN accounts as well as micro accounts.
                                                                            </td>
                                                                        </tr>

                                                                    </tbody>
                                                                </table>
                                                            </td>
                                                        </tr>
                                                    </tbody>
                                                </table>
                                            </td>
                                        </tr>
                                    </tbody>
                                </table>
                            </td>
                        </tr>
                    </tbody>
                </table>
            </td>
        </tr>
        
        
            <tr>
                            <td align=\"center\">
                                <table align=\"center\" width=\"50%\" border=\"0\" cellspacing=\"0\" cellpadding=\"0\" style=\"border-left: 1px solid #dbd9d9; border-right: 1px solid #dbd9d9;\">
                                    <tbody>
                                        <tr>
                                            <td height=\"50\"></td>
                                        </tr>
                                        <tr>
                                            <td align=\"center\" bgcolor=\"#34495e\" background=\"https://designmodo.com/demo/emailtemplate/images/footer.jpg\" height=\"185\">
                                                <table class=\"col-600\" width=\"600\" border=\"0\" align=\"center\" cellpadding=\"0\" cellspacing=\"0\">
                                                    <tbody>
                                                        <tr>
                                                            <td height=\"25\"></td>
                                                        </tr>

                                                        <tr>
                                                            <td align=\"center\" style=\"font-family: 'Raleway',  sans-serif; font-size:16px; font-weight: 300; color:white;padding-left:50px;padding-right:50px;color:white;\">This is an automatically generated email please do not reply to this email. If you face any issues, please contact us</td>
                                                        </tr>
                                                        <td height=\"30\"></td>

                                                        <tr>
                                                            <td>
                                                                <hr style=\"width:150px;border:1px solid #ff0062;\"> </td>
                                                        </tr>
                                                        <tr>
                                                            <td>
                                                                <center><a href=\"#\" style=\"text-decoration: none;color:white;\">support@pipspulsefx.com</a></center>
                                                            </td>
                                                        </tr>

                                                        <tr>
                                                            <td>
                                                                <hr style=\"width:150px;border:1px solid #ff0062;\"> </td>
                                                        </tr>

                                                        <tr>
                                                            <td height=\"25\"></td>
                                                        </tr>

                                                    </tbody>
                                                </table>
                                             
                                                < </td>
                                        </tr>
                                    </tbody>
                                </table>
                                </td>
                        </tr>                         
                                   
    </tbody>
</table>
        
            </body>
        </html>
";
        // Set content-type header for sending HTML email
        $headers = "MIME-Version: 1.0" . "\r\n";
        $headers .= "Content-type:text/html;charset=UTF-8" . "\r\n";
        // Additional headers
        $headers .= 'From:'.'Pips Pulse Capital'.'<'.$from .'>'. "\r\n";
        // Send email
        if(mail($toEmail,$emailSubject,$htmlContent,$headers))
        {
          $msg = "
                <div class='alert alert-success'>
                    <button class='close' data-dismiss='alert'>&times;</button>
                    <strong>Success!</strong>  We've sent an email to $email.
                    Please click on the confirmation link in the email to Activate your account.
                </div>
                ";
        }
        //end mail srcipt
}

  /**
   * Create user on MT server
   * @param $user MTUser
   * @param $user_server MTUser
   * @return bool
   */
  function CreateAccount($user, &$user_server)
  {
    //--- check connection
    if (!$this->api->IsConnected())
    {
      if (($error_code = $this->api->Connect(MT5_SERVER_IP, MT5_SERVER_PORT, 300, MT5_SERVER_WEB_LOGIN, MT5_SERVER_WEB_PASSWORD)) != MTRetCode::MT_RET_OK)
      {
        echo "<script>
        alert('Something went wrong. Please try again');
        </script>";
          /*
        echo "authentication on MetaTrader Server failed [", $error_code, "] ", MTRetCode::GetError($error_code);
        */
        exit;
      }
    }
    //--- add user
    if (($error_code = $this->api->UserAdd($user, $user_server)) != MTRetCode::MT_RET_OK)
    {
      echo "<script>
      alert('Something went wrong. Please try again');
      </script>";
        /*
       echo "Add user on MetaTrader Server failed [", $error_code, "] ", MTRetCode::GetError($error_code);
       */
       exit;
     }
   }
  /**
   * Check password
   * @param $password string
   * @return bool
   */
  function CheckPassword($password)
  {
    $digit = 0;
    $upper = 0;
    $lower = 0;
    //--- check password size
    if (strlen($password) < 5) return (false);
    //--- check password
    for ($i = 0; $i < strlen($password); $i++)
    {
      if (ctype_digit($password[$i])) $digit = 1;
      if (ctype_lower($password[$i])) $lower = 1;
      if (ctype_upper($password[$i])) $upper = 1;
    }
    //--- final check
    return (($digit + $upper + $lower) >= 2);
  }
  /**
   * Generate new verify code
   * @return void
   */
  private function GenerateVerifyCode()
  {
    $random_string = '';
    for ($i = 0; $i < self::VERIFY_CODE_LENGTH; $i++)
    {
      $random_string .= rand(0, 9);
    }
    $_SESSION['verify_code'] = $random_string;
  }
  /**
   * View page
   * @return void
   */
  private function Show()
  {
    $this->GenerateVerifyCode();
    //---
    include("nomination1.php");
  }
}
?>