<?php
//+------------------------------------------------------------------+
//|                                             MetaTrader 5 Web API |
//|                   Copyright 2000-2020, MetaQuotes Software Corp. |
//|                                        http://www.metaquotes.net |
//+------------------------------------------------------------------+
session_start();
error_reporting(0);
include('config.php');
if(strlen($_SESSION['clogin'])==0)
{
  header('location:login.php');
}
class WebPageForm
{
  const VERIFY_CODE_LENGTH = 5;
  private $user;
  private $verify_code;
  private $root_url;
  private $api;
  /**
   * Construct
   */
  function __construct()
  {
    //---- start session
    session_start();
    //---- initialize
    $this->user = array('password' => '','phone_password' => '','password' => '', 'confirm_password' => '', 'invest_password' => '');
    //---
    $this->root_url = $_SERVER['HTTP_HOST'] . rtrim(dirname($_SERVER['PHP_SELF']), '/\\');
    //---
    $this->api = new MTWebAPI(AGENT, PATH_TO_LOGS);
    $this->api->SetLoggerWriteDebug(IS_WRITE_DEBUG_LOG);
  }
  /**
   * Create web page
   * @return void
   */
  public function CreatePage()
  {
    //---
    if (isset($_REQUEST['a']) && is_array($_REQUEST['a']))
    {
      //--- extract method name
      $methodName = 'On' . key($_REQUEST['a']);
      //--- call the method
      if (method_exists($this, $methodName)) $this->$methodName();
      return;
    }
    $this->Show();
  }
  /**
   * Send email
   * @return void
   */
  private function OnRegister()
  {
    //--- validation request
    if (!isset($_REQUEST['user']) || !is_array($_REQUEST['user']) || !isset($_REQUEST['verify_code']) || empty($_REQUEST['verify_code']) || !isset($_SESSION['verify_code']) || empty($_SESSION['verify_code']))
    {
      include("");
      exit;
    }
    //--- receive input
    $this->user = $_REQUEST['user'];
    $this->verify_code = $_REQUEST['verify_code'];
    //----
    foreach ($this->user as $key => $value) $value = trim($value);
    //--- validation input
    if ($_SESSION['verify_code'] != $this->verify_code || $this->user['password'] != $this->user['confirm_password'] ||  empty($this->user['password']) || !$this->CheckPassword($this->user['password']))
    {
      $error = '';
      if ($_SESSION['verify_code'] != $this->verify_code) $error .= '1. Invalid verify code<br>';
      if ($this->user['password'] != $this->user['confirm_password']) $error .= '2. Password not confirm<br>';
      
      if (empty($this->user['password'])) $error .= 'Empty Password <br>';

      if (!$this->CheckPassword($this->user['password'])) $error .= '3. Password should be Alpha numeric and min 5 words ex: Test@1990,  <br>';
      //---
      $this->GenerateVerifyCode();
      include("demo_account1.php");
      exit;
    }
    include("demo_account_history.php");
     //--- put parameters in our structure
    $new_user = $this->api->UserCreate();
    $new_user->MainPassword = $this->user['password'];
    $new_user->Group = $this->user['group'];
    $new_user->Leverage = $this->user['leverage'];
    $new_user->ZipCode = $this->user['zip'];
    $new_user->Country = $this->user['country'];
    $new_user->State = $this->user['state'];
    $new_user->City = $this->user['city'];
    $new_user->Address = $this->user['address'];
    $new_user->Phone = $this->user['phone'];
    $new_user->Currency = 'USD';
    $new_user->Name = $this->user['name'];
    $new_user->Email = $this->user['email'];
    $new_user->PhonePassword = $this->user['phone_password'];
    $new_user->InvestPassword =$this->user['invest_password'];
    //--- create new account 
    $this->CreateAccount($new_user, $user_server);
    //--- see new login on server
    $new_user->Login = $user_server->Login;
    // Store user to database 
    $account_type=$new_user->Group;
    $currency=$new_user->Currency;
    $trade_id=$new_user->Login;
    $trader_pwd=$new_user->MainPassword;
    $invester_pwd=$new_user->InvestPassword;
    $phone_pwd=$new_user->PhonePassword;
    $leverage=$new_user->Leverage;
    $email=$new_user->Email;
    $sql = "INSERT INTO  demoaccount(email,trade_id,account_type,leverage,currency,trader_pwd,invester_pwd,phone_pwd)
    VALUES (:email,:trade_id,:account_type,:leverage,:currency,:trader_pwd,:invester_pwd,:phone_pwd)";
    $query = $dbh->prepare($sql);
    $query->bindParam(':email',$email,PDO::PARAM_STR);
    $query->bindParam(':trade_id',$trade_id,PDO::PARAM_STR);
    $query->bindParam(':account_type',$account_type,PDO::PARAM_STR);
    $query->bindParam(':leverage',$leverage,PDO::PARAM_STR);
    $query->bindParam(':currency',$currency,PDO::PARAM_STR);
    $query->bindParam(':trader_pwd',$trader_pwd,PDO::PARAM_STR);
    $query->bindParam(':invester_pwd',$invester_pwd,PDO::PARAM_STR);
    $query->bindParam(':phone_pwd',$phone_pwd,PDO::PARAM_STR);
    $query->execute();
    $lastInsertId = $dbh->lastInsertId();
    echo "<script>
    alert('Your Trading Demo Account Created Successfully');
    </script>";
  
  }
  /**
   * Create user on MT server
   * @param $user MTUser
   * @param $user_server MTUser
   * @return bool
   */
  function CreateAccount($user, &$user_server)
  {
    //--- check connection
    if (!$this->api->IsConnected())
    {
      if (($error_code = $this->api->Connect(MT5_SERVER_IP, MT5_SERVER_PORT, 300, MT5_SERVER_WEB_LOGIN, MT5_SERVER_WEB_PASSWORD)) != MTRetCode::MT_RET_OK)
      {
        echo "<script>
        alert('Something went wrong. Please try again');
        </script>";
          /*
        echo "authentication on MetaTrader Server failed [", $error_code, "] ", MTRetCode::GetError($error_code);
        */
        exit;
      }
    }
    
    //--- add user
    if (($error_code = $this->api->UserAdd($user, $user_server)) != MTRetCode::MT_RET_OK)
    {
      echo "<script>
      alert('Something went wrong. Please try again');
      </script>";
        /*
       echo "Add user on MetaTrader Server failed [", $error_code, "] ", MTRetCode::GetError($error_code);
       */
       exit;
     }
   }
  /**
   * Check password
   * @param $password string
   * @return bool
   */
  function CheckPassword($password)
  {
    $digit = 0;
    $upper = 0;
    $lower = 0;
    //--- check password size
    if (strlen($password) < 5) return (false);
    //--- check password
    for ($i = 0; $i < strlen($password); $i++)
    {
      if (ctype_digit($password[$i])) $digit = 1;
      if (ctype_lower($password[$i])) $lower = 1;
      if (ctype_upper($password[$i])) $upper = 1;
    }
    //--- final check
    return (($digit + $upper + $lower) >= 2);
  }
  /**
   * Generate new verify code
   * @return void
   */
  private function GenerateVerifyCode()
  {
    $random_string = '';
    for ($i = 0; $i < self::VERIFY_CODE_LENGTH; $i++)
    {
      $random_string .= rand(0, 9);
    }
    $_SESSION['verify_code'] = $random_string;
  }
  /**
   * View page
   * @return void
   */
  private function Show()
  {
    $this->GenerateVerifyCode();
    //---
    include("demo_account1.php");
  }
}
?>