dashboard.factory('Auth', ['$http', '$localStorage', 'urls', '$cookies', function($http, $localStorage, urls, $cookies) {
  function urlBase64Decode(str) {
    var output = str.replace('-', '+').replace('_', '/');
    switch (output.length % 4) {
      case 0:
        break;
      case 2:
        output += '==';
        break;
      case 3:
        output += '=';
        break;
      default:
        throw 'Illegal base64url string!';
    }
    return window.atob(output);
  }

  function getClaimsFromToken() {
    var token = $cookies.get('token');
    var user = {};
    if (typeof token !== 'undefined') {
      var encoded = token.split('.')[1];
      user = JSON.parse(urlBase64Decode(encoded));
    }
    return user;
  }

  function verifyToken() {
    var token = $cookies.get('token');
  }

  var tokenClaims = getClaimsFromToken();

  return {
    signin: function(data, success, error) {
      var sts;
      $http.post(urls.Login, data).then(function(response) {
        if (response.status === 200 && response.data.status === "authenticated") {
          success(response.data);
        } else {
          sts = response.data.status_type || null;
          error(sts);
        }
      }, function() {
        error(sts);
      });
    },
    logout: function(success) {
      tokenClaims = {};
      $cookies.remove('token', {
        path: '/'
      });
      $localStorage.$reset();
      success();
    },
    getTokenClaims: function() {
      return tokenClaims;
    }
  };
}]);

dashboard.filter('dateToISO', function() {
  return function(input) {
    if (input !== undefined || input != null) {
      return new Date(input).toISOString();
    } else {
      return input;
    }
  };
});

dashboard.filter('msdate', function() {
  return function(input) {
    if (input !== undefined || input != null) {
      return new Date(input);
    } else {
      return input;
    }
  }
});

dashboard.filter('startFrom', function() {
  return function(input, start) {
    start = +start; //parse to int
    return input.slice(start);
  }
});

dashboard.filter('substrId', function(){
  return function(input){
    var id = input.substring(0,15);
    id = id.toUpperCase();
    return id;
  }
});

dashboard.filter('totalLots', function(){
  return function(input) {
    var total = 0;
    angular.forEach(input, function(item) {
      if(item !== null || item !== undefined) {
        if (item.volumeReal !== null && item.volumeReal !== undefined && item.hedgeFL !== null && item.hedgeFL !== undefined && item.hedgeHL !== null && item.hedgeHL !== undefined) {
          total += (parseFloat(item.hedgeFL) + (parseFloat(item.hedgeHL) / 2));
        }
      }
    });
    return total.toFixed(4);
  }
});

dashboard.filter('HLots', function(){
  return function(input) {
    var total = 0;
    angular.forEach(input, function(item) {
      if(item !== null || item !== undefined) {
        if (item.volumeReal !== null && item.volumeReal !== undefined && item.hedgeFL !== null && item.hedgeFL !== undefined && item.hedgeHL !== null && item.hedgeHL !== undefined) {
          total += parseFloat(item.hedgeHL);
        }
      }
    });
    return total.toFixed(4);
  }
});

dashboard.filter('NHtotalLots', function(){
  return function(input) {
    var total = 0;
    angular.forEach(input, function(item) {
      if(item !== null || item !== undefined) {
        if (item.volumeReal !== null && item.volumeReal !== undefined && item.hedgeFL !== null && item.hedgeFL !== undefined && item.hedgeHL !== null && item.hedgeHL !== undefined) {
          total += parseFloat(item.hedgeFL);
        }
      }
    });
    return total.toFixed(4);
  }
});

dashboard.filter('Commission', function(){
  return function(input) {
    var total = 0;
    angular.forEach(input, function(item) {
      if(item !== null || item !== undefined) {
        if (item.volumeReal !== null && item.volumeReal !== undefined && item.cms !== null && item.cms !== undefined) {
          total += parseFloat(item.cms);
        }
      }
    });
    return total.toFixed(4);
  }
});

dashboard.filter('daterangeFilter', function() {
  return function(input, date) {
    var fromDate = date.startDate;
    var toDate = date.endDate;
    var filtered = [];
    if (fromDate === null || toDate === null) {
      return input;
    } else {
      fromDate = Math.round(((new Date(fromDate).getTime()) / 1000));
      toDate = Math.round((new Date(toDate).getTime()) / 1000);
      angular.forEach(input, function(item) {
        if (item.date !== null && item.date !== undefined) {
          if (Math.round(Date.parse(item.date.date)/1000) >= fromDate && Math.round(Date.parse(item.date.date)/1000) <= (toDate)) {
            filtered.push(item);
          }
        }
      });
      return filtered;
    }
  }
});

dashboard.filter('daterangeFilter2', function() {
  return function(input, date) {
    var fromDate = date.startDate;
    var toDate = date.endDate;
    var filtered = [];
    if (fromDate === null || toDate === null) {
      return input;
    } else {
      fromDate = Math.round(((new Date(fromDate).getTime()) / 1000));
      toDate = Math.round((new Date(toDate).getTime()) / 1000);
      angular.forEach(input, function(item) {
        if (item.date !== null && item.date !== undefined) {
          if (Math.round(Date.parse(item.date)/1000) >= fromDate && Math.round(Date.parse(item.date)/1000) <= (toDate)) {
            filtered.push(item);
          }
        }
      });
      return filtered;
    }
  }
});

dashboard.filter('tradeCloseTime', function() {
  return function(input, date) {
    var fromDate = date.startDate;
    var toDate = date.endDate;
    var filtered = [];
    if (fromDate === null || toDate === null) {
      return input;
    } else {
      fromDate = (Math.round(((new Date(fromDate).getTime()) / 1000))) + 19800;
      toDate = (Math.round((new Date(toDate).getTime()) / 1000)) + 19799;
      angular.forEach(input, function(item) {
        if (item.closeTime !== null && item.closeTime !== undefined) {
          if (Math.round(Date.parse(item.closeTime) / 1000) >= fromDate && Math.round(Date.parse(item.closeTime) / 1000) <= (toDate)) {
            filtered.push(item);
          }
        }
      });
      return filtered;
    }
  }
});

dashboard.factory('Excel', function($window) {
  var uri = 'data:application/vnd.ms-excel;base64,',
    template = '<html xmlns:o="urn:schemas-microsoft-com:office:office" xmlns:x="urn:schemas-microsoft-com:office:excel" xmlns="http://www.w3.org/TR/REC-html40"><head><!--[if gte mso 9]><xml><x:ExcelWorkbook><x:ExcelWorksheets><x:ExcelWorksheet><x:Name>{worksheet}</x:Name><x:WorksheetOptions><x:DisplayGridlines/></x:WorksheetOptions></x:ExcelWorksheet></x:ExcelWorksheets></x:ExcelWorkbook></xml><![endif]--></head><body><table>{table}</table></body></html>',
    base64 = function(s) {
      return $window.btoa(unescape(encodeURIComponent(s)));
    },
    format = function(s, c) {
      return s.replace(/{(\w+)}/g, function(m, p) {
        return c[p];
      })
    };
  return {
    tableToExcel: function(tableId, worksheetName) {
      var table = $(tableId),
        ctx = {
          worksheet: worksheetName,
          table: table.html()
        },
        href = uri + base64(format(template, ctx));
      return href;
    }
  };
});

dashboard.factory('getOptionsList', function($http) {
  return {
    getCategory: function(type) {
      var data = {
        "Categorytype": type,
        "request_type": "category"
      };
      return $http.post("../../core/functions/optionsList", data);
    },
    getLanguage: function() {
      var data = {
        "request_type": "language"
      };
      return $http.post("../../core/functions/optionsList", data);
    }
  }
});

dashboard.factory('getMarketingTools', function($http) {
  return {
    getEmailTemplates: function() {
      var data = {
        "request_type": "emailTemplate"
      };
      return $http.post("../../core/functions/getMarketingTools", data);
    },
    getBanners: function() {
      var data = {
        "request_type": "banners"
      };
      return $http.post("../../core/functions/getMarketingTools", data);
    },
    getLandingPage: function() {
      var data = {
        "request_type": "landingPage"
      };
      return $http.post("../../core/functions/getMarketingTools", data);
    },
    
    getCampaignData: function() {
      var data = {
        "request_type": "getCampaign"
      };
      return $http.post("../../core/functions/getMarketingTools", data);
    }
  }
});

dashboard.service('ngCopy', ['$window', function($window) {
  var body = angular.element($window.document.body);
  var textarea = angular.element('<textarea/>');
  textarea.css({
    position: 'fixed',
    opacity: '0'
  });

  return function(toCopy) {
    textarea.val(toCopy);
    body.append(textarea);
    textarea[0].select();

    try {
      var successful = document.execCommand('copy');
      if (!successful) {
        throw successful
      } else {
        swal("code copied", toCopy, "success");
      }
    } catch (err) {
      swal("unable to copy code", toCopy, "warning");
    }
    textarea.remove();
  }
}]);

dashboard.directive('tooltip', function() {
  return {
    restrict: 'A',
    link: function(scope, element, attrs) {
      $(element).hover(function() {
        $(element).tooltip('show');
      }, function() {
        $(element).tooltip('hide');
      });
    }
  };
});