var days = ["Sun","Mon","Tue","Wed","Thu","Fri"];
var hours = ["00","01","02","03","04","05","06","07","08","09","10","11","12","13","14","15","16","17","18","19","20","21","22","23"];
var UNSELECT_STATUS = 1;
var SELECT_STATUS = 2;
var INIT_STATUS = 3;
var currentStatus = INIT_STATUS;
jQuery.fn.extend({
    timeTable : function(data) {
        var dataJson = getDataAsJson(data);
        for (var t = 0; t < this.length; t++) {
            var masterAccountOid = this[t].getAttribute("master");
            var table = new Element('table', {id:"timeTable" + masterAccountOid,className:"maxWidth marginCenter pointer"});
            jQuery(table).disableSelection();
            var trThElement = table.insertRow(table.rows.length);

            jQuery(document).mouseup(function() {
                currentStatus = INIT_STATUS;
            });
            //init date text when out of table
            jQuery(table).on("mouseleave", function() {
                var trsArray = this.childNodes;
                this.childNodes[0].rows[this.childNodes[0].rows.length - 1].childNodes[0].innerHTML = "&nbsp";
            });

            //empty td to move right hours
            var th = new Element('td', {});
            trThElement.insert(th);

            for (var i = 0; i < hours.length; i++) {
                th = new Element('td', {});
                th.innerHTML = hours[i];
                th.width = 15;
                trThElement.insert(th);
            }
            for (var d = 0; d < 6; d++) {
                var trElement = table.insertRow(table.rows.length);
                trElement.className = "day";
                var thDayText = new Element('td', {});
                thDayText.innerHTML = days[d];
                trElement.insert(thDayText);
                thDayText.height = 15;
                thDayText.width = 15;
                var tdData = dataJson[table.rows.length - 2];
                for (var h = 0; h < 24; h++) {
                    var status = UNSELECT_STATUS;
                    var tdElement = trElement.insertCell(trElement.cells.length);
                    if (tdData != null && tdData[trElement.cells.length - 2] != null)
                        tdElement.className = "redBG1 radius3";
                    else {
                        tdElement.className = "greenBG1 radius3";
                        status = SELECT_STATUS;
                    }
                    tdElement.setAttribute("status", status);

                    jQuery(tdElement).mousedown(function(e) {
                        var elementStatus = Number(this.getAttribute("status"));
                        currentStatus = (elementStatus == UNSELECT_STATUS) ? SELECT_STATUS : UNSELECT_STATUS;
                        this.className = (elementStatus == UNSELECT_STATUS) ? "greenBG1 radius3" : "redBG1 radius3";
                        this.setAttribute("status", currentStatus);
                    });


                    jQuery(tdElement).mouseover(function() {
                        var elementStatus = Number(this.getAttribute("status"));
                        if (currentStatus != elementStatus && currentStatus != INIT_STATUS) {
                            this.className = (elementStatus == UNSELECT_STATUS) ? "greenBG1 radius3" : "redBG1 radius3";
                            this.setAttribute("status", currentStatus);
                        }
                        else {
                            var trsArray = this.parentNode.parentNode.childNodes;
                            var trText = this.parentNode.childNodes[0].innerHTML;
                            var hour = trsArray[0].childNodes[this.cellIndex].innerHTML;
                            trsArray[trsArray.length - 1].childNodes[0].innerHTML = trText + " " + hour + ":00:00" + "-" + hour + ":59:59";
                        }
                    });
                }
            }
            trElement = table.insertRow(table.rows.length);
            var tdWord = trElement.insertCell(trElement.cells.length);
            //init date text when over
            jQuery(tdWord).on("mouseenter", function() {
                this.innerHTML = "&nbsp";
            });
            tdWord.className = "tdWord center";
            tdWord.colSpan = 24;
            tdWord.innerHTML = "&nbsp";
            this[t].appendChild(table)
        }
    }

});

function updateTableTimesSelection(tableId, selected) {
    $$(tableId + " td[status]").each(function(element) {
        element.className = (selected) ? "greenBG1 radius3" : "redBG1 radius3";
        element.setAttribute("status", (selected) ? 2 : 1);
    });
}
function getDataAsJson(data) {
    var map = {};
    if (data != null) {
        var weekData = data.split('@');
        if (weekData != null && weekData.length > 0) {
            for (var i = 0; i < weekData.length; i++) {
                var hoursMap = {};
                var dayData = weekData[i].split("#");
                if (dayData != null && dayData.length == 2 && hasText(dayData[1])) {
                    var hours = dayData[1].split(",");
                    if (hours != null && hours.length > 0) {
                        for (var j = 0; j < hours.length; j++) {
                            if (hasText(hours[j]))
                                hoursMap[Number(hours[j])] = true;
                        }
                    }
                    map[Number(dayData[0])] = hoursMap;
                }
            }
        }
    }
    return map;
}

function updateTimeTableData(accountOid, data) {
    var dataJson = getDataAsJson(data);
    var trs = $$("#timeTable" + accountOid + " tr[class=day]");
    for (var i = 0; i < trs.length; i++) {
        var tr = trs[i];
        var tdData = dataJson[i];
        for (var j = 1; j < tr.cells.length; j++) {
            var td = tr.cells[j];
            if (tdData != null && tdData[j - 1] != null) {
                td.className = "redBG1 radius3";
                td.setAttribute("status", 1);
            }
            else {
                td.className = "greenBG1 radius3";
                td.setAttribute("status", 2);
            }
        }
    }
}