function refresher(ajax_delay,langId) {
    var ajax_delay = ajax_delay || 8000,
        requestParams = {},
        chartID;
    var recursive_mode = true;
    // prepare URL request params
    requestParams.refresher_version = 'v1.6.9'; // do not forget to change the version on refresher.php **
    requestParams.lang = langId;
    // Add Charts-specific params
    try {
        if ( typeof FPCharts.Utils.enrich_refresher_params === 'function' ) {
            requestParams = FPCharts.Utils.enrich_refresher_params(requestParams);
        }
    } catch(e) {}

    $.ajax({
        url: '/refresher.php',
        type: "GET",
        data: requestParams,
        dataType: "text",
        success:
            function(data) {
                if (data.length > 0) {
                    try {
                        var tables_array_all = JSON.parse(data);
                    } catch(e) {
                        if (recursive_mode)
                            setTimeout( function() {
                                refresher(ajax_delay,langId);
                            }, 15000);
                        return false;
                    }
                    var h;
                    var i;
                    var j;

                    for (h in tables_array_all) {

                        switch (h){
                            case 'newer_version' : // check if need to get newer version ***
                                location.reload(true);
                                return;
                                break;

                            case "EconomicCalendar": // EconomicCalendar JSON ***
                                economicCalendarRefresh_injs(tables_array_all[h]);
                                continue;
                                break;
                        }

                        var tables_array = tables_array_all[h];
                        for (i in tables_array) {

                            if(i=='quotesSummary') {
                                $('#quotes_summary_current_data').html(tables_array[i]['current_data']);
                                $('#quotes_summary_secondary_data').html(tables_array[i]['secondary_data']);
								$('#fl_header_pair_chg').html(tables_array[i]['fl_header_pair_chg']);
                                $('#fl_header_pair_lst').html(tables_array[i]['fl_header_pair_lst']);
                                $('#fl_header_pair_pch').html('('+tables_array[i]['fl_header_pair_pch']+'%)');
								$('#fl_header_pair_pch').removeClass('redFont').removeClass('greenFont').addClass(tables_array[i]['fl_header_pair_clr']+'Font');
								$('#fl_header_pair_chg').removeClass('redFont').removeClass('greenFont').addClass(tables_array[i]['fl_header_pair_clr']+'Font');
                                continue;
                            }

                            if (i=='js_instrument_chart'){
                                // pass received array to javascript function that should
                                // use it to update all charts of that type
                                try {
                                    if ( typeof FPCharts.Utils.update_charts === 'function' ) {
                                        FPCharts.Utils.update_charts(tables_array[i], i);
                                    }
                                } catch(e) {}
                                continue
                            }

                            var table_rows_array = tables_array[i];
                            for (j in table_rows_array) {
                                var divname = '#'+i+' #pair_' + j;
                                var divcontent = table_rows_array[j];

                                if (divcontent['type']) {
                                    switch (divcontent['type'])
                                    {
                                        case 'value':
                                            $('#' + divcontent['id']).html(divcontent['data']); //if (divcontent['id'] == 'qb_pair_change_1'){alert(divcontent['id'] + ' ** ' + divcontent['data']);}
                                            break;
                                        case 'css':
                                            $('#' + divcontent['id']).removeClass();
                                            $('#' + divcontent['id']).addClass(divcontent['data']);
                                            break;
                                        case 'style':
                                            $('#' + divcontent['id']).attr('style', divcontent['data']);
                                            break;
                                        case 'style_color':
                                            $('#' + divcontent['id']).css('color', divcontent['data']);
                                            break;
                                        case 'ec_bgColor':
                                            if (divcontent['checkData'] != $('#' + divcontent['checkID']).html())
                                                $('#' + divcontent['id']).css('background-color', divcontent['data']);
                                            break;
                                        case 'clear':
                                            var bid = document.getElementById(i + 'cl_bid' + j);
                                            var ask = document.getElementById(i + 'cl_ask' + j);
                                            var last = document.getElementById(i + 'cl_last' + j);

                                            if(bid){
                                                bid.className = '';
                                            }
                                            if(ask){
                                                ask.className = '';
                                            }
                                            if(last){
                                                last.className = '';
                                            }

                                            if (divcontent['date']){
                                                var datetime = document.getElementById(i + 'cl_date' + j);
                                                if (datetime){
                                                    datetime.innerHTML = divcontent['date'];
                                                }
                                            }
                                            break;
                                    }
                                }
                                else {
                                    $(divname).html(divcontent);
                                }
                            }
                        }
                    }
                    delete tables_array;
                    delete table_rows_array;
                    delete h;
                    delete i;
                    delete j;
                    delete divname;
                    delete divcontent;
                }
                if (recursive_mode)
                    setTimeout( function() {
                        refresher(ajax_delay,langId);

                    }, ajax_delay);
            },
        error:
            function(XMLHttpRequest, textStatus, errorThrown)
            {
                setTimeout( function() {
                    refresher(ajax_delay,langId);

                }, 15000);
            }
    });
    sortTable();
}
function sortTable(){
    $("table[tablesorter]").trigger("update");
}

/**
 * Hover event handler clears the yellow backgroud from the changed row.
 * Economic calendar
 */
function removeBackgroundColor(eventObject){
    $(this).removeClass("passedTime");
    $(this).unbind("hover", removeBackgroundColor);
}

/*
 * events = Array(
 *     Array('row_ID' => ...,
 *         'event_previous_formatted' => ...,
 * 	       'event_forecast_formatted' => ...,
 *         'event_actual_formatted' => ...,
 *         'event_revised_from_title' => ...,
 *         'event_relative_title' => ...,
 *		   'event_relative_font' => ...,
 *	       'event_relative_arrow' => ...
 *     )
 * )
 */
function economicCalendarRefresh_injs(events) {
	//console.log('test in js');
    for (idx in events) {
        var eventRowId = events[idx]['row_ID'];
        var actualElementId = "#eventActual_" + eventRowId;
        var sandClockElementId = "sandClock_" + eventRowId;
        //Paint yellow if actual changed
        var currentActual = $(actualElementId).html();
        var previousElementId = "#eventPrevious_" + eventRowId;
        var currentPrevious = $(previousElementId).html();
        if ((currentActual != events[idx]['event_actual_formatted']
            && typeof(events[idx]['event_actual_formatted']) == 'string'
            && events[idx]['event_actual_formatted'].indexOf(sandClockElementId) == -1
            && events[idx]['event_actual_formatted'] != '&nbsp;')
            || (typeof(events[idx]['event_previous_formatted']) != 'undefined'
            && events[idx]['event_previous_formatted'] != null
            && events[idx]['event_previous_formatted'] != '&nbsp;'
            && events[idx]['event_previous_formatted'] != currentPrevious)
            ) {
            $("#eventRowId_" + eventRowId).addClass("passedTime");
            $("#eventRowId_" + eventRowId).hover(removeBackgroundColor);
        }
        //update actual
        $(actualElementId).html(events[idx]['event_actual_formatted']);
        $(actualElementId).attr('title', events[idx]['event_relative_title']);
        $(actualElementId).removeClass('redFont').removeClass('greenFont').removeClass('blackFont').addClass(events[idx]['event_actual_relative_font']);
        //update forecast
        var forecastElementId = "#eventForecast_" + eventRowId;
        $(forecastElementId).html(events[idx]['event_forecast_formatted']);
        //update previous
        $(previousElementId).html(events[idx]['event_previous_formatted']);

        if(events[idx]['event_previous_relative_font'] != ''){
            var thisfontColor = events[idx]['event_previous_relative_font'];
            $('#eventPrevious_'+eventRowId).removeClass('redFont').removeClass('greenFont').removeClass('blackFont').addClass(thisfontColor);
        }
        //update revised
        var eventRevisedFromTitle = events[idx]['event_revised_from_title'];
        ecUpdateRevised(eventRowId, eventRevisedFromTitle);
        //Update event info if it is open
        if ($("#eventInfo" + eventRowId).is(':visible')) {
            //actual
            $("#eventInfoActual_" + eventRowId).html(events[idx]['event_actual_formatted']);
            $("#eventInfoActual_" + eventRowId).removeClass('redFont').removeClass('greenFont').removeClass('blackFont').addClass(events[idx]['event_actual_relative_font']);
            //forecast
            $("#eventInfoForecast_" + eventRowId).html(events[idx]['event_forecast_formatted']);
            //previous
            $("#eventInfoPrevious_" + eventRowId).html(events[idx]['event_previous_formatted']);
            //revised from
            var eventInfoRevisedFromIconClass;
            if (typeof eventRevisedFromTitle == 'string' && eventRevisedFromTitle.length > 0) {
                eventInfoRevisedFromIconClass = "diamondNewIcon";
            } else {
                eventInfoRevisedFromIconClass = "diamondNewEmptyIcon";
            }
            $("#eventInfoRevised_" + eventRowId).removeClass("diamondNewEmptyIcon").removeClass("diamondNewIcon").addClass(eventInfoRevisedFromIconClass);
            $("#eventInfoRevised_" + eventRowId).attr("title", eventRevisedFromTitle);

            //relative arrow
            $("#eventInfoRelativeArrow_" + eventRowId).removeClass("upArrow").removeClass("downArrow").addClass(events[idx]['event_actual_relative_arrow']);
        }
    }
}

function ecUpdateRevised(eventRowId, eventRevisedFromTitle) {
    var eventRevisedFromWrapperTdId = "#eventRevisedFrom_" + eventRowId;
    var eventRevisedFromSpanId = "#eventRevisedFromSpan_" + eventRowId;
    //There is a revised from number

    if (typeof eventRevisedFromTitle == 'string' && eventRevisedFromTitle.length > 0) {
        if ($(eventRevisedFromSpanId).is('span')) {
            //There was already a span
            $(eventRevisedFromSpanId).attr('title', eventRevisedFromTitle);
        } else {
            //there was no revised from number earlier
            var directionClass = "";
            if (document.dir == "rtl") {
                directionClass = "dirRtl";
            }
            //Add the span
            $(eventRevisedFromWrapperTdId).html('<span id="eventRevisedFromSpan_' + eventRowId + '" class="diamondNewIcon inlineblock ' + directionClass + '" title="' + eventRevisedFromTitle + '"></span>');
        }
    } else {
        //There was a revised from value (shouldn't happen)
        if ($(eventRevisedFromSpanId).is('span')) {
            //Remove the span
            $(eventRevisedFromWrapperTdId).html('&nbsp;');
        }
    }
}

function getRefresherColor(color){
    if (color == 1)
        return 'greenFont';
    else if (color == -1)
        return 'redFont';
    else
        return '';
}


/////////////////zzzzzzzzzz///////////


function dateToString(dateObj)
{
	var day = dateObj.getDate();	
	var paddedDay;
	if (day < 10) {
		paddedDay = "0" + day;
	} else {
		paddedDay = day;
	}
	var month = dateObj.getMonth()+1;
	var paddedMonth;
	if (month < 10) {
		paddedMonth = "0" + month;
	} else {
		paddedMonth = month;
	}
	var dateStr = dateObj.getFullYear() + "-" + (paddedMonth) + "-" + paddedDay;
	return dateStr;
}

function showLoader()
{
	$('#ecEventsTable').addClass("displayNone");
	$('#economicCalendarLoading').css('display', "block");
}
function hideLoader()
{
	$('#ecEventsTable').removeClass("displayNone");
	$('#economicCalendarLoading').css('display', "none");
}

function timeFrameOnClickHandler()
{
    var clickedId = $(this).attr('id');
	$(".saveSpace A").html($(this).html());
    if (clickedId == 'timeFrame_yesterday') {
        var yesterday = new Date();
        yesterday.setDate(yesterday.getDate() - 1);
        //setTimeFrame("timeFrame_yesterday", yesterday, yesterday);
        setTimeFrame("timeFrame_yesterday","yesterday", false);
        $('#timeFrame_yesterday').unbind('click', timeFrameOnClickHandler);
    } else if (clickedId == 'timeFrame_today') {
        var today = new Date();
        //setTimeFrame("timeFrame_today", today, today);
        setTimeFrame("timeFrame_today","today", false);
        $('#timeFrame_today').unbind('click', timeFrameOnClickHandler);
    } else if(clickedId == 'timeFrame_tomorrow') {
        var dt = new Date();
        dt.setDate(dt.getDate() + 1);
        //setTimeFrame("timeFrame_tomorrow", dt, dt);
        setTimeFrame("timeFrame_tomorrow","tomorrow", false);
        $('#timeFrame_tomorrow').unbind('click', timeFrameOnClickHandler);
    } else if (clickedId == 'timeFrame_thisWeek') {
        var today = new Date();
        var todayDay = today.getDay();
        var offsetStart;
        if (todayDay >= 1) {
            offsetStart = (todayDay );
        } else {
            offsetStart = 0;
        }
        var fromDate = new Date();
        fromDate.setDate(today.getDate() - offsetStart);
        //var toDate = new Date();
        //toDate.setDate(fromDate.getDate() + 6);//monday to sunday (monday + 6 days)
        var toDate = new Date( fromDate.getTime() + 6 * 24 * 3600 * 1000 );
        //setTimeFrame("timeFrame_thisWeek", fromDate, toDate);
        setTimeFrame("timeFrame_thisWeek", "thisWeek", false);
        $('#timeFrame_thisWeek').unbind('click', timeFrameOnClickHandler);
    } else if (clickedId == 'timeFrame_nextWeek') {
        var today = new Date();
        var todayDay = today.getDay();
        var offsetStart;
        if (todayDay >= 1) {
            offsetStart = (todayDay );
        } else {
            offsetStart = 0;
        }
        setTimeFrame("timeFrame_nextWeek", "nextWeek", false);
        $('#timeFrame_nextWeek').unbind('click', timeFrameOnClickHandler);
    }
    $('a[id^="timeFrame_"]').not('[id=' + clickedId + ']').unbind('click', timeFrameOnClickHandler).bind('click', timeFrameOnClickHandler);
}

var nextEventTimeoutVar;
function parseDateTime(dtStr)
{
	if (typeof(dtStr) != "string") {
		return null;
	}
	var dateTimeArr = dtStr.split(" ");
	if (!$.isArray(dateTimeArr) || dateTimeArr.length != 2) {
		return null;
	}
	var dateStr = dateTimeArr[0];
	var timeStr = dateTimeArr[1];
	var dateArr = dateStr.split("-");
	if (!$.isArray(dateArr) || dateArr.length != 3) {
		return null;
	}
	var timeArr = timeStr.split(":");
	if (!$.isArray(timeArr) || timeArr.length != 3) {
		return null;
	}	
	return new Date(dateArr[0], 
			(parseInt(dateArr[1], 10) - 1),
			parseInt(dateArr[2], 10),
			parseInt(timeArr[0], 10),
			parseInt(timeArr[1], 10),
			parseInt(timeArr[2], 10),
			0);
}

function resetNextEventLineTimeout()
{
	lastEventTr = $('tr[timeSeparator="true"]');
	$(lastEventTr).removeAttr('timeSeparator');
	if ($(lastEventTr).hasClass("timeSeparator")) {
		$(lastEventTr).removeClass("timeSeparator");
	}
	var timestamp = $(lastEventTr).attr("event_timestamp");
	var currentDateTime = parseDateTime(timestamp);
	//console.log("current next event" + currentDateTime);
	resetNextEventLine(currentDateTime); 
}

function resetNextEventLine(currentDateTime)
{
    //console.log('Reseting next event' + currentDateTime);
    if (currentDateTime != null) {
        $("tr[id^=eventRowId_]").each(function(index, element) {
            var timestamp = $(element).attr("event_timestamp");
            var eventDateTime = parseDateTime(timestamp);
            //console.log('in each. event datetime: ' + eventDateTime);
            if (eventDateTime != null) {
                if (eventDateTime > currentDateTime) {
                    var prevId = $(element).prev().attr('id');
                    if (typeof(prevId) == 'string'
                            && (prevId.indexOf('eventRowId_') == 0
                            || prevId.indexOf('eventInfo') == 0)
                            ) {
                        $(element).addClass("timeSeparator");
                    }
                    $(element).attr('timeSeparator', 'true');
                    return false;
                }
            }
        });
    }
}

function changeFiltersVisibility(withScroll) {
    $("#filtersWrapper").slideToggle("slow");
    if ($("#filterStateAnchor").hasClass("active")) {
        $("#filterStateAnchor").removeClass("active");
		if($(document).scrollTop() > 392){
			if (withScroll && $("#filtersWrapper").is(':visible')) {
				$("html, body").animate({ scrollTop: 0 }, "slow");            
			}
		}
    } else {
        $("#filterStateAnchor").addClass("active");
    }
}

function searchEvent(eventId)
{
	if (eventId == 'na' || eventId == '' || !eventId)
		return;
	//$.scrollTo($("#ecEventsTable").offset().top - 130);
	var params = {"event_ID": eventId};
	$.ajax({
		url: "/searchresult.php",
		type: "POST",
		data: params,
		beforeSend: function() {
			showLoader();
		},
		complete: function() {
			hideLoader();
			//close the filters after any apply
			if ($("#filtersWrapper").is(':visible')) {
				changeFiltersVisibility(true);
			}
		},
		success: function(data) {
			$("#ecEventsTable tbody").empty().html(data);
			$('a[id^="timeFrame"]').removeClass("toggled");
			$('a[id^="timeFrame_"]').unbind('click', timeFrameOnClickHandler).bind('click', timeFrameOnClickHandler);
			var searchedTrSelector = "tr[event_attr_ID='" + eventId + "']"; 
			var trObject = $(searchedTrSelector);
			var eventRowObjectId = $(trObject).attr("id");
			if (typeof(eventRowObjectId) == "string") {
				var eventRowId = eventRowObjectId.substr("eventRowId_".length);
				changeEventDisplay(eventRowId, trObject, "overview");
				var searchEventTs = parseDateTime($(trObject).attr('event_timestamp'));				 
				resetNextEventLine(searchEventTs);
			}
		}
	});
}

//Check if all country, category, importance filters are off, set
//the filter button class to off. Otherwise set the filter button to on.
//The class is changed only if neccessary.
function filterStateButton()
{
  if ($.find("input[name='country[]']:checked").length == 0
          && $.find("input[name='category[]']:checked").length == 0
          && $.find("input[name='importance[]']:checked").length == 0
          ) {
      if ($("#filterStateButton").hasClass("filtersOnLight")) {
          $("#filterStateButton").removeClass("filtersOnLight").addClass("filtersOffLight");
      }
  } else if ($("#filterStateButton").hasClass("filtersOffLight")){
      $("#filterStateButton").removeClass("filtersOffLight").addClass("filtersOnLight");
  }
}

//End of filter state
//--------------------------------------------------------------------------------------------------------
//Select / Clear all
function selectAll(name) {
    $("input[name='" + name + "']").prop('checked', true);
    //filterStateButton();
}

function clearAll(name) {
    $("input[name='" + name + "']").removeAttr('checked');
    //filterStateButton();
}

function isNumeric(n) {
    
    return !isNaN(parseFloat(n)) && isFinite(n);
}

//End of Select / Clear all
//--------------------------------------------------------------------------------------------------------
function checkEnterForEcSearch(evt)//called from search text field
{
    if(evt.keyCode == 13){
    	
    	if( 0 == searchSelfElement.resultsData.length ) return false;
		if( 0 == searchSelfElement.rowNumber ){
			searchSelfElement.rowNumber = 1;
		}
			
		if( !isNumeric( searchSelfElement.resultsData[(searchSelfElement.rowNumber)-1].eventId ))
			return false;
    	
        searchEvent(searchSelfElement.resultsData[(searchSelfElement.rowNumber)-1].eventId);
        $('#economicCalendarSearchPopupResults').addClass('displayNone');
        $('#economicCalendarSearchPopupResults').html('');

        searchSelfElement.searchDeafaultVale = '';
        return false;
    }
}
	
function getSandClockString(eventRowId, waitForDataDefine){
    return '<span id="sandClock_'+eventRowId+'" class="newSiteIconsSprite sandClock middle" title="' + waitForDataDefine + '"></span>';
}

function ecReady(){
	
	resetNextEventLine(currentDateTime);
	if (!$('#timeFrame_yesterday').hasClass('toggled')) {
		$('#timeFrame_yesterday').bind('click', timeFrameOnClickHandler);
	}

	//today timeframe
	if (!$('#timeFrame_today').hasClass('toggled')) {
		$('#timeFrame_today').bind('click', timeFrameOnClickHandler);
	}

	//tomorrow timeframe
	if (!$('#timeFrame_tomorrow').hasClass('toggled')) {
		$('#timeFrame_tomorrow').bind('click', timeFrameOnClickHandler);
	}

	//thisWeek timeframe
	if (!$('#timeFrame_thisWeek').hasClass('toggled')) {
		$('#timeFrame_thisWeek').bind('click', timeFrameOnClickHandler);
	}

	//nextWeek timeframe
	if (!$('#timeFrame_nextWeek').hasClass('toggled')) {
		$('#timeFrame_nextWeek').bind('click', timeFrameOnClickHandler);
	}
	$(function() {
		
		if (location.hash != undefined && location.hash.length > 1) {
			var hashEventId = location.hash.replace('#', '');
			var searchedTrSelector = "#eventRowId_" + hashEventId;
			var trObject = $(searchedTrSelector);
			if (trObject != undefined && $(trObject).is("tr")) {
				
				setTimeout(function(){
					changeEventDisplay(hashEventId, trObject, "overview");
					$.scrollTo($(searchedTrSelector).offset().top - 130);
				}, 2000);
			}
		}
	});
	//Restore Defaults
	
	$("#filterRestoreDefaults").click(function(){
		var restoreFilterFields = new Array("country", "category", "importance");
		var i,j;
		for (i = 0; i < restoreFilterFields.length; i++) {
			var filterName = restoreFilterFields[i];
			clearAll(filterName + "[]");
			if (defaultParams[filterName] != undefined
				&& defaultParams[filterName].length > 0
			) {
				if(filterName == "country") { 
					for(j = 0; j < defaultParams[filterName].length; j++) {
						$("input[id='" + filterName + defaultParams[filterName][j] + "']").prop('checked', true);
					}
				}
			}
		}
	});
	//End of Restore Defaults
	$("#ecoCurrentTime").click(function(eventObject){
		if ($("#ecoCurrentTimePop").is(":visible")) {
			$("#ecoCurrentTimePop").addClass("displayNone");
		} else {
			$("#ecoCurrentTimePop").removeClass("displayNone");
		}
		eventObject.stopPropagation();
	});
	//On selection of a timezone set the hidden select option accordingly.
	//close the selection div. submit the form and reload the events table.
	//update the current time.
	$("li[id^='liTz']").click(function(eventObject){
		liTzId = $(this).attr("id");
		optionValue = liTzId.substr("liTz".length);
		//Select the pressed timeZone
		$("#timeZone").val(optionValue);
		//Set the string displaying the time and timezone
		$("#ecoCurrentTimePop").addClass("displayNone");
		economicCalendarFormSubmit();
		
	});
	//End of Select timezone
	
	 var searchEcoCalender;
	    searchEcoCalender = new FXautoComplete;
	    searchEcoCalender.Element.searchTextInputId = 'economicCalendarSearchText';
	    searchEcoCalender.Element.formElementId = 'search_0bottom';
	    searchEcoCalender.Element.resultsInnerContainerId = 'innerContainerEC';
	    searchEcoCalender.Element.resultsOuterContainerId = 'economicCalendarSearchPopupResults';
	    searchEcoCalender.Element.url = '/autocomplete.php';
	    searchEcoCalender.Element.hiddenDocDirectionId = 'doc_direconomicCalendarSearchPopupResults';
	    searchEcoCalender.Element.mainResultRowIdPrefix = 'searchRowIdEC_';
	    searchEcoCalender.Element.hasDefaultText = false;
	    searchEcoCalender.Element.minimumChar = 2;

	    searchEcoCalender.inputFieldBind( $('#economicCalendarSearchText') );
	    searchEcoCalender.getSymbol=function(selectedRowObj)
	    {
	        return $('td:first', selectedRowObj).html();
	    }
	    searchEcoCalender.buildSearchResults=function(data){
	        var obj = this;
	        var resultsHtml = '<div class="textBox clear" id="innerContainerEC"> ' +
	                            '<table>';
	        if(data === null){
	            return;
	        }
	        searchSelfElement.firstRowId = 0;
	        $.each(data, function(index,item){
	            if(item !== undefined)
	            {
	                index++;
	                resultsHtml += '<tr class="row" event_id="'+item['eventId']+'" id="'+obj.Element.mainResultRowIdPrefix+index+'">';
	                resultsHtml += '<td class="first">' + item['label'] + '</td><td class="second">' + item['currency'] + '</td>';
	                resultsHtml += '</tr>';
	            }
	        });

	        resultsHtml += '</table></div>';
	        $('#'+obj.Element.resultsOuterContainerId).html(resultsHtml);

	        }
	        searchEcoCalender.bindResults=function(rowElement){
	            var obj = this;
	            $(rowElement).click(function(){
	            searchEvent( $(rowElement).attr('event_id') );
	            searchSelfElement.closeAutocomplete.call(obj,obj);
	            });
	        }
}

function FXautoComplete(){
    this.Element = {
        minimumChar : 1,
        hasTabs : false,
        selectedCountryId : 0,
        hasDefaultText : true,
        googleSearchDefineId : '',
        lang:1
    };
}

FXautoComplete.prototype = {
    rowNumber     : 0,
    lastRowNumber : 1,
    searchText    : '',
    allowdReset   : true,
    allowdClosePopUp : true,
    allowdKeys : false,
    allowdForm : false,
    searchDeafaultVale : '',
    searchTimeOutRunning : false,
    arrowfocus:'',
    current_tab : 'All',
    previousTab : 'All',
    resultsData:'',
    firstRowId: 0,
    dynamicVar : '',
    countriesData : undefined,
    countriesDefaultText : undefined,
    searchType: '',
    portfolioPairId: undefined,

    setTabsText : function(jsonTabs){
        var tabs = JSON.parse(jsonTabs);

        var c = '';
        var counter = 0;
        for(tab_id in tabs){
            var selected = (tabs[tab_id].selected == true) ? 'selected' : '';
            var first = (counter == 0) ? 'first' : '';
            var last = (counter == tabs.length - 1) ? 'last' : '';
            var country = (tabs[tab_id].id == 'search_box_topCountries') ? 'country' : '';

            if(tabs[tab_id].id == 'search_box_topCountries'){
                this.countriesDefaultText = tabs[tab_id].name;
            }

            c += '<li id="'+ tabs[tab_id].id +'" class="'+ first+' '+ last +' '+ country +' '+ selected +'"><a href="javascript:void(0);">'+ tabs[tab_id].name +'</a></li>';
            counter++;
        }

        $('#'+ this.Element.tabsDivId).html(c);
    },
//General functions
    clearInputField : function(Obj) {

        if (searchSelfElement.searchDeafaultVale == ''){ ///https://set default value
            searchSelfElement.searchDeafaultVale = $(Obj).val();
        }
        var searchDeafaultVale = searchSelfElement.searchDeafaultVale;
    	if ($(Obj).attr('default') != ''){
    		searchDeafaultVale = $(Obj).attr('default');
    	}
		
        if(searchDeafaultVale ==  $(Obj).val()){//check if need to clear
            $('#'+this.Element.searchTextInputId).val('');
            searchSelfElement.allowdReset = true;
            searchSelfElement.allowdKeys = false;
            searchSelfElement.allowdForm = false;
        }
    },

    markSelectedRow : function(){
        $('#'+this.Element.resultsInnerContainerId+' .row').removeClass('hoverSearch');
        $('#'+this.Element.mainResultRowIdPrefix+searchSelfElement.rowNumber).addClass('hoverSearch');

    },
    setSelectedRowNumber : function(row) {
        searchSelfElement.allowdForm = true;
        this.lastRowNumber = searchSelfElement.rowNumber;
        searchSelfElement.rowNumber = row;
    },
    changeCurrentTabDisplay : function(tabId){

        $('#'+this.Element.tabsPrefix+tabId).addClass('selected');
        $('#'+this.Element.tabsPrefix+tabId).siblings().each(function(){
            $(this).removeClass('selected');
        });
    },
    getSelectedRowElement : function(obj) {
        return $('#'+obj.Element.mainResultRowIdPrefix + searchSelfElement.rowNumber);
    },
    closeAutocomplete : function(obj){
        obj.Element.selectedCountryId = 0;
        searchSelfElement.previousTab = 'All';
        $('#'+this.Element.resultsInnerContainerId).scrollTop(0);
        $('#'+this.Element.countriesScrollDiv).scrollTop(0);
        $('#'+obj.Element.countriesWrapperId).addClass('displayNone');
        var defaultText = this.countriesDefaultText;
        if(this.countriesDefaultText == undefined){
        	defaultText = this.Element.countriesDefaultText;
        }
        $('#'+obj.Element.tabsPrefix+'Countries').html('<a href="javascript:void(0);">'+ defaultText +'</a>');

        $('#'+obj.Element.resultsOuterContainerId).addClass('displayNone');
        $('#'+obj.Element.resultsInnerContainerId).html('');

    },
    closeSearchResultBox : function(){
        $('#'+this.Element.resultsOuterContainerId).addClass('displayNone');
        searchSelfElement.closeAutocomplete.call(this,this);

    },
    getResultsNumber : function(){
        return  $('#'+this.Element.resultsInnerContainerId).find("table tr").length;
    },
//End - General functions
//Key functionality
    keyCodeUp : function(){
        searchSelfElement.rowNumber--;
        var total_rows = searchSelfElement.getResultsNumber.call(this);
        if(searchSelfElement.rowNumber == -1 || isNaN(searchSelfElement.rowNumber) )
        {
            $('#'+this.Element.resultsInnerContainerId+' .row').removeClass('hoverSearch');
            $('#'+this.Element.formElementId).attr('onsubmit', 'return false;');
            searchSelfElement.arrowfocus = "text";
            $('#'+this.Element.searchTextInputId).focus();
            searchSelfElement.rowNumber = -1;
            $('#'+this.Element.searchTextInputId).val(searchSelfElement.searchText);
            searchSelfElement.allowdKeys = true;
        }
        if( (total_rows - searchSelfElement.rowNumber) >7){
            $('#'+this.Element.resultsInnerContainerId).scrollTop(($('#'+this.Element.resultsInnerContainerId).scrollTop())-22 );//22 is row height
        }

    },
    keyCodeDown : function(){

        if(searchSelfElement.rowNumber === undefined)
            searchSelfElement.rowNumber = 0;

        searchSelfElement.arrowfocus = "tabs";
        var total_rows = searchSelfElement.getResultsNumber.call(this);
        if(total_rows == searchSelfElement.rowNumber)
        {
            return;
        }

        $('#'+this.Element.formElementId).attr('onsubmit', 'return true;');
        searchSelfElement.rowNumber++;
        if(searchSelfElement.rowNumber > 7)
            $('#'+this.Element.resultsInnerContainerId).scrollTop(($('#'+this.Element.resultsInnerContainerId).scrollTop())+22 );//22 is row height
        else
            $('#'+this.Element.resultsInnerContainerId).scrollTop(0);
    },
    keyFunctunality : function(evt, keyCode){

        searchSelfElement.allowdForm = false;
        searchSelfElement.lastRowNumber = searchSelfElement.rowNumber;
        var showSymbol = true;
        if (keyCode == 40){ // down
            searchSelfElement.keyCodeDown.call(this);
        }
        else if (keyCode == 38){ //up
            searchSelfElement.keyCodeUp.call(this);
        }
        else if(keyCode == 39 && searchSelfElement.arrowfocus == "tabs" && (this.Element.hasTabs))//arrow right
        {
            var tab = searchSelfElement.getTheNextTab.call(this,1);//send the side (1 = right)
            if(tab == ''){
                showSymbol = false;
            }
            else{
                searchSelfElement.rowNumber = 0;
            }
            searchSelfElement.ChangeTabOnClick.call(this,tab);
        }
        else if(keyCode == 37 && searchSelfElement.arrowfocus == "tabs" && (this.Element.hasTabs))//arrow left
        {
            var tab = searchSelfElement.getTheNextTab.call(this,0);//send the side (2 = left)
            if(tab == ''){
                showSymbol = false;
            }else{
                searchSelfElement.rowNumber = 0;
            }
            searchSelfElement.ChangeTabOnClick.call(this,tab);
        }

        var selectedRow = searchSelfElement.getSelectedRowElement(this);
        if(selectedRow.length > 0 && showSymbol){
            var symbol = searchSelfElement.executeGetSymbol.call(this,selectedRow);
            searchSelfElement.symbolAndAction.call(this,symbol, selectedRow,$('#'+this.Element.searchTextInputId),false);
            searchSelfElement.markSelectedRow.call(this);
        }


    },
    setGoogleLink : function(){
        var googleSearchDefine = this.Element.googleSearchDefineId;
        var link ='/'+googleSearchDefine+'?q='+searchSelfElement.searchText;
        $('#'+this.Element.googleLinkID).attr('href', link);
        $('#'+this.Element.googleLinkID).html(searchSelfElement.searchText);
    },
    symbolAndAction : function(symbol, selectedRow, Obj,hover) {

        symbol = symbol.replace(/<\/\i>/g, "");
        symbol = symbol.replace(/<i class="bold">/g, "");
        symbol = symbol.replace(/<\/\I>/g, "");
        symbol = symbol.replace(/<I class=bold>/g, "");
        symbol = symbol.replace(/<\/\i>/g, "");
        symbol = symbol.replace(/<\/\i>/g, "");

        if(hover != true)
            $(Obj).val(symbol);
        if(this.Element.formElementId != undefined && this.Element.formElementId != '') {
            $('#'+this.Element.formElementId).attr('action', $('#' + selectedRow.attr('id') + ' .symbolName').attr('link'));
            if(this.Element.searchType == 'portfolio'){
            	//alert($('#' + selectedRow.attr('id') + ' .symbolName').attr('pairid'));
            	//alert(this.Element.portfolioPairId);
            	//var pairId = 
            	//alert(pairId);
            	this.Element.portfolioPairId = $('#' + selectedRow.attr('id') + ' .symbolName').attr('pairid');
            	//alert(this.Element.portfolioPairId);
            }
        }
    },
//End - Key functionality

//Show results and rows action
    displayAndSetSearchResultBox : function(){

        searchSelfElement.allowdForm = true;
        searchSelfElement.arrowfocus = 'tabs';

        if(searchSelfElement.firstRowId === 'no_results' && this.Element.googleSearchDefineId != ''){
            searchSelfElement.allowdForm = true;
            var googleSearchDefine = this.Element.googleSearchDefineId;
            $('#'+this.Element.formElementId).attr('action', '/'+googleSearchDefine+'?q='+searchSelfElement.searchText);
            $('#'+this.Element.formElementId).attr('onsubmit', 'return true;');
        }
        else if(searchSelfElement.firstRowId === 'no_results'){
            searchSelfElement.allowdForm = false;
            $('#'+this.Element.formElementId).attr('onsubmit', 'return false;');
        }
        else{
            $('#'+this.Element.formElementId).attr('onsubmit', 'return searchSelfElement.allowdForm;');
        }
        $('#'+this.Element.formElementId).attr('action', $('#'+this.Element.mainResultRowIdPrefix + searchSelfElement.firstRowId + ' .symbolName').attr('link'));
        //add pairId
        this.Element.portfolioPairId = $('#'+this.Element.mainResultRowIdPrefix + searchSelfElement.firstRowId + ' .symbolName').attr('pairid');
        var obj = this;
        if(this.Element.hasTabs)
            searchSelfElement.bindTabs.call(obj);

        searchSelfElement.executeBindResults.call(obj);
        $('#'+this.Element.resultsOuterContainerId).removeClass('displayNone');
    },

//End - Show results and rows action

//Send ajax call
    validateForSearch : function(evt,Obj) {
        if(evt.keyCode != 38 && evt.keyCode != 40 && evt.keyCode != 37 && evt.keyCode != 39) {
            searchSelfElement.searchText = $(Obj).val();
        }
        if((searchSelfElement.searchText.length > 0) && (evt.keyCode == 38 || evt.keyCode == 40 || evt.keyCode == 37 || evt.keyCode == 39) && searchSelfElement.allowdKeys)
        {
            searchSelfElement.keyFunctunality.call(this,evt,evt.keyCode);
        }
        else if((evt.keyCode != 13) && (searchSelfElement.searchText.length >= this.Element.minimumChar) && (!searchSelfElement.searchTimeOutRunning))
        {
            searchSelfElement.allowdReset = false;
            searchSelfElement.checkIfTimedOut.call(this);
        }
        else if(searchSelfElement.searchText.length == 0)
        {
            searchSelfElement.closeSearchResultBox.call(this);
        }
    },
    checkIfTimedOut : function(){

        if(!searchSelfElement.searchTimeOutRunning) {
            var that = this;
            searchSelfElement.searchTimeOutRunning = true;
            that.timer = setTimeout(function() { searchSelfElement.executeAutoCompleteSearch.call(that); },400);
        }
    },
    executeAutoCompleteSearch : function(){

        if(searchSelfElement.searchText == ''){
            searchSelfElement.searchTimeOutRunning = false;
            return;
        }

        var se = $('#'+ this.Element.formElementId +' > .searchGlassIcon');
        se.removeClass('searchGlassIcon newSiteIconsSprite');
        se.addClass('loading');

        var obj = this;
        searchSelfElement.allowdForm = false;
        if(obj.Element.selectedCountryId == '' || isNaN(parseInt(obj.Element.selectedCountryId)) )
            obj.Element.selectedCountryId = 0;
        if(obj.Element.googleSearchDefineId != ''){
            searchSelfElement.setGoogleLink.call(obj);
        }
 
        $.post(this.Element.url,
            {
                search_text    	  : searchSelfElement.searchText,
                term    	  : searchSelfElement.searchText,
                extraParameters   : searchSelfElement.extraParameters,
                country_id		  : obj.Element.selectedCountryId,
                lang              : curlang
            },
            function(data) {

                searchSelfElement.allowdKeys = false;
                searchSelfElement.allowdForm = false;
                searchSelfElement.resultsData = data;

                if(data != '' && data != null)
                {
                    searchSelfElement.allowdKeys = true;
                    searchSelfElement.arrowfocus = 'text';
                }
                else{
                    searchSelfElement.closeSearchResultBox.call(obj);
                    se.removeClass('loading');
                    se.addClass('searchGlassIcon newSiteIconsSprite');
                    return;
                }

                searchSelfElement.executeBuildResultsBox.call(obj);
                searchSelfElement.displayAndSetSearchResultBox.call(obj);

                se.removeClass('loading');
                se.addClass('searchGlassIcon newSiteIconsSprite');

            }, "json"
        );

        searchSelfElement.searchTimeOutRunning = false;
    },
//End - Send ajax call

//Default, bind searchText input field
    inputFieldBind : function(Obj){
        var that = this;

        Obj.bind(
            'focus' , function() {
                searchSelfElement.clearInputField.call(that, Obj);
                $('#'+ this.id + 'Container').addClass('topBarInputSelected');
                searchSelfElement.rowNumber = 0;
            });
        Obj.bind(
            'keyup' , function(event) {
                searchSelfElement.allowdKeys=true;
                searchSelfElement.validateForSearch.call(that, event, Obj);
            });
        $('#'+that.Element.searchTextInputId).bind(
            'focusout' , function() {
                $(document).click( function (evt) {
                    if(
                        ($(evt.target).parents('#'+that.Element.resultsInnerContainerId).length < 1)
                            &&
                            (evt.target.id != that.Element.resultsInnerContainerId )
                            &&
                            ($(evt.target).parents('#'+that.Element.searchTextInputId).length < 1)
                            &&
                            (evt.target.id != that.Element.searchTextInputId )
                            &&
                            ($(evt.target).parents('#'+that.Element.resultsOuterContainerId).length < 1)
                            &&
                            (evt.target.id != that.Element.resultsOuterContainerId )
                        ){
                        if( !(that.Element.hasDefaultText) )
                            $('#'+that.Element.searchTextInputId).val('');
                        else{
                        	if ($('#'+that.Element.searchTextInputId).attr('default') != ''){
								$('#'+that.Element.searchTextInputId).val($('#'+that.Element.searchTextInputId).attr('default'));
							}else{
								$('#'+that.Element.searchTextInputId).val(searchSelfElement.searchDeafaultVale);
							}
                        }

                        $('#'+ that.Element.searchTextInputId + 'Container').removeClass('topBarInputSelected');
                        searchSelfElement.closeAutocomplete.call(that,that);
                    }
                });

            });


    },
//End - Default, bind searchText input field

//Tabs related functions
    //Coming here from clicking on tab or moving with arrows
    //tab_id is the tab to switch too
    ChangeTabOnClick : function (tab_id) {
        tab_id = tab_id.replace(this.Element.tabsPrefix,"");

        var obj = this;
        var changeTab = true;
        if(tab_id == ''){
            changeTab = false;
            tab_id = searchSelfElement.previousTab;
        }

        if(tab_id != 'Countries') {
            searchSelfElement.previousTab = tab_id;
            if(changeTab){
                searchSelfElement.executeBuildResultsBox.call(this);
            }
            searchSelfElement.displayAndSetSearchResultBox.call(this);

            if(searchSelfElement.arrowfocus != 'tabs'){
                $('#'+this.Element.formElementId).attr('onsubmit', 'return false;');
                searchSelfElement.arrowfocus = 'text';
            }
            if(changeTab){
                $('#'+this.Element.searchTextInputId).focus();
                setTimeout(function () {
                    $('#'+obj.Element.searchTextInputId).val(searchSelfElement.searchText);
                }, 1);
            }
        }
        else if(tab_id == 'Countries')
        {
            if($('#'+obj.Element.countriesWrapperId).hasClass('displayNone')){

               // if(FXautoComplete.countriesData == undefined){
                    $.ajax({
                        url: "/search/countries",
                        dataType: "json",
                        async:   false,
                        success: function(data) {
                            FXautoComplete.countriesData = data;
                            var countries_c = '';
                            for (var i in data) {
                                var selected = data[i].selected == 'true' ? 'selected' : '';
                                countries_c += '';
                                countries_c +='<tr id="country'+ obj.Element.dynamicVar +'_'+ data[i].country_id +'">';
                                countries_c +='<td class="'+ selected +'" id="tdCountry'+ obj.Element.dynamicVar +'_'+ data[i].country_id +'">'+ data[i].country_name +'</td>';
                                countries_c +='</tr>';
                            }

                            $('#'+obj.Element.countriesTableId+' > tbody').html(countries_c);

                        }
                    });
               // }

                searchSelfElement.bindCountries.call(this);
                $('#'+obj.Element.countriesWrapperId).removeClass('displayNone');
            }else{
                $('#'+obj.Element.countriesWrapperId).addClass('displayNone');
            }

        }

    },
    bindCountries : function(){
        var obj = this;
        $('#'+obj.Element.countriesTableId+' '+obj.Element.countriesType).each(function(){
            if(obj.Element.countryRowPrefix+obj.Element.selectedCountryId != this.id)
                $(this).removeClass('selected');
            $(this).unbind();

            $(this).click( function(){
                searchSelfElement.searchInCountryId.call(obj,this.id);
            });
        });
    },
    //called from onClick of countries
    searchInCountryId : function(tdId){

        $('#'+tdId).addClass('selected');
        this.Element.selectedCountryId = tdId.replace(this.Element.countryRowPrefix,'');

        searchSelfElement.allowdReset = false;
        $('#'+this.Element.countriesScrollDiv).scrollTop(0);
        $('#'+this.Element.countriesWrapperId).addClass('displayNone');
        searchSelfElement.checkIfTimedOut.call(this);
        $('#'+this.Element.tabsPrefix+'Countries').html('<a href="javascript:void(0);">'+$('#'+tdId).html()+'</a>');

        $('#'+this.Element.searchTextInputId).focus();
        setTimeout(function () {
            $('#'+this.Element.searchTextInputId).val(searchSelfElement.searchText);
        }, 1);

    },
    bindTabs : function(){
        var obj = this;
        $('#'+obj.Element.tabsDivId+' '+obj.Element.tabsType).each(function(){
            $(this).unbind();
            $(this).click( function(){
                searchSelfElement.ChangeTabOnClick.call(obj,this.id);
            })
        });
    },
    //get the side (1 = right , 2 = left)
    getTheNextTab :  function (side)
    {
        if($('#'+this.Element.hiddenDocDirectionId).attr('rel') == 'rtl')
        {
            if(side == 0)
                side = 1;
            else
                side = 0;
        }
        var obj = this;
        var tabsArr = new Array();
        var tabId = '';
        var tabNameClean = '';
        var index = 0;

        $('#'+obj.Element.tabsDivId+' '+obj.Element.tabsType).each(function(){

            tabId = this.id;
            tabNameClean = tabId.replace(obj.Element.tabsPrefix , '');
            tabsArr[index] = tabNameClean;
            index++;

        });
        var nextTab = '';
        for(var i=0;i<tabsArr.length;i++){
            if(searchSelfElement.previousTab == tabsArr[i])
            {
                if(side == 0)
                    side = -1;
                nextTab = tabsArr[i+side];
            }
        }
        if(nextTab != '' && nextTab != undefined && nextTab != 'Countries')
            nextTab = obj.Element.tabsPrefix+nextTab;
        else{
            nextTab = '';
        }
        return nextTab;

    },
//End - tabs related functions

//Execute specific search functions
    executeBuildResultsBox : function(){
        var obj = this;
        var data = searchSelfElement.resultsData;
        obj.buildSearchResults(data);
    },
    executeBindResults : function(){
        var obj = this;
        $('#'+obj.Element.resultsInnerContainerId+' .row').each(function(){
            $(this).unbind();
            obj.bindResults(this);
        });
    },
    executeGetSymbol : function(selectedRowObj){
        return (this.getSymbol(selectedRowObj));
    }
//End - Execute specific search functions


};

var searchSelfElement = FXautoComplete.prototype;

function getTimeFrame(){
	var retval = '';
	$('a[id^="timeFrame_"]').each( function(){
	    		if($(this).hasClass("toggled")){
	    			var toggled =  $(this).get(0).id;
	    			retval = toggled.substr("timeFrame_".length);
	    		}
	   		});
	return retval;
}

function setTimeFrame(timeFrameObjectId, dateFrom, dateTo) {
    //Cancel any selection of timeframe
    $('a[id^="timeFrame"]').removeClass("toggled");
    //Select the pressed timeframe
    $('a[id="' + timeFrameObjectId + '"]').addClass("toggled");
    //Set the string displaying the dateFrom - dateTo
    if(dateTo != false){//string send
	    var dateFromStr = dateToString(dateFrom);
	    var dateToStr = dateToString(dateTo);
	    if($('#widgetFieldDateRange').get(0) != undefined) {
	    	$('#widgetFieldDateRange').get(0).innerHTML = dateFromStr + " - " + dateToStr;
	    }
	    //Set the input fields
	    $('#dateFrom').val(dateFromStr);
	    $('#dateTo').val(dateToStr);
	    $('#widgetHolCalendar').DatePickerSetDate(new Array(dateFrom, dateTo), true);
    }
    else
    	$('#timeframe').val(dateFrom);
    economicCalendarFormSubmit();
}


function resetTodayForHandler( currentDateTime ){
	if (todayForHandler != undefined){
	 todayForHandler.length = 0;
     todayForHandler =[currentDateTime.getFullYear(),currentDateTime.getMonth(),currentDateTime.getDate(),
                       currentDateTime.getHours(),currentDateTime.getMinutes(), 0, 0 ];
	}
    
}
//End of filter state

function resetStartPageTime(){
	var curTime = new Date();
	var psa = Math.floor(curTime.getTime()/60000) * 60000;
	$('[pageStartAt]').attr('pageStartAt', psa);
}

var cEPT_hh;
var cEPT_mm;
var cEPT_mLong;
var cEPT_timer;

function calcEventPushTime( hh, mm, mLong, forceUpdTitle){
	cEPT_hh = hh;
	cEPT_mm = mm;
	cEPT_mLong = mLong;
	var curTime = new Date();
		curTime.setSeconds(0);
	 
	var td = $('[evtStrtTime]');
	var seconds_delay ;
	var psa = Math.round(curTime.getTime()/60000) * 60000;
	if(forceUpdTitle){
		seconds_delay = parseInt(td.attr('evtPageStrtTimeSeconds'));
		if(seconds_delay < 0) {
			seconds_delay = 60 + seconds_delay ;
		}
		$('[pageStartAt]').attr('pageStartAt', psa);
	}
	var waitTime = (psa - $('[pageStartAt]').attr('pageStartAt')) / 60000;
	var updTxt =checkTimeFrameSelection();
	
	var moveline = 0;
	
	$(td).each(  function() {
		var tentative = false;
		var eventWaitTime = parseInt($(this).attr('evtPageStrtTime'));
		if(eventWaitTime != ''){
			var remainTime =  eventWaitTime-waitTime;
			//console.log("remainTime " + remainTime);
			var remainTimeTxt='';

			if(  typeof $(this).attr('evttentative') != "undefined")
            	tentative = true;

			if(remainTime <= 0){
				if(remainTime > -1)
					moveline = 1;
					//moveTimeSeparatorLine(curTime);
				
				if(updTxt &&  !tentative) {
					$(this).text($(this).attr('evtStrtTime'));
				}
				remainTimeTxt = toHourMin(remainTime, hh, mm, mLong);
				$(this).attr('title', updateTitleText(remainTimeTxt, 'released'));
			}
			else
			{//will be released at	
			 //only 1-59 min
				var newval = checkMin(remainTime);
				if(newval !=''){
					moveline = 1;
					//moveTimeSeparatorLine(curTime);
			    }
				if( updTxt  && (newval !='') ){
					if(!tentative) {
						$(this).text(newval + ' '+ mLong );
					}
					$(this).attr('title', updateTitleText($(this).attr('evtStrtTime'),'upcoming'));
				}
				else
				{
			    	remainTimeTxt = toHourMin(remainTime, hh, mm, mLong);
					$(this).attr('title', updateTitleText(remainTimeTxt,'upcomingNoDspl'));
				}
			}
			
		}
	});
	
	//if(moveline == 1) {
		moveTimeSeparatorLine(curTime);
	//}

	if(forceUpdTitle){
		//console.log("seconds_delay " + seconds_delay);
		cEPT_timer = setTimeout( function()	{ calcEventPushTime( hh, mm, mLong, false); }, seconds_delay * 1000);
		return;
	}
	
	var tick = new Date().getTime();
	var mins = Math.floor(tick/60000) * 60000;
	var secs = Math.floor((tick - mins)/1000);
	//console.log("secs " + secs);
	cEPT_timer = setTimeout( function()	{ calcEventPushTime( hh, mm, mLong, false); }, (60000 - parseInt(secs)*1000));
}

function moveTimeSeparatorLine( curTime ){
	
	var lastEventTr = $('tr[timeSeparator="true"]');
	$(lastEventTr).removeAttr('timeSeparator');
	if ($(lastEventTr).hasClass("timeSeparator")) {
		$(lastEventTr).removeClass("timeSeparator");
	}	
	currentDateTime.setSeconds(0);
	var offset = Math.floor((currentDateTime.getTime() - $('[pageStartAt]').attr('pageStartAt'))/60000) * 60000;
	//var offset = currentDateTime.getTime() - $('[pageStartAt]').attr('pageStartAt');
	var timeZoneCurDateInt = curTime.getTime() + offset;
	var timeZoneCurDate = new Date(timeZoneCurDateInt);
	timeZoneCurDate.setSeconds(0);
	console.log("curTime " + curTime + "timeZoneCurDate " + timeZoneCurDate + " offset " + offset);
	resetNextEventLine(timeZoneCurDate);
}


  function toHourMin(val, h, m, mlong){
  	var Val = val;
  	var retTxt ='';
   	var addMin = mlong;  
 	if( val < 0) {
  		Val =(-1) * val;
  	}
	
  	if(Val < 60)	return Val+ ' ' +addMin;
	
  	mm = parseInt(Val%60);
  	if(mm < 9) mm='0'+mm;
	
  	hh = parseInt(Val/60);
  	if(hh > 0 ){
  		retTxt = hh + h +' ' ;
  		addMin = m;
  	}
  	if(mm >= 0)
  		retTxt = retTxt + mm + addMin;
		
  	return (retTxt);	
  }
  
  function checkMin(val){ //,  mlong
	  	if( val < 0 || val >= 60) 
	 		return '';
	  	
	  	if(val < 60)	
	  		return val;//+ ' ' +mlong;
  }
	  
  
  function resetCalendarDatePicker(dateFrom, dateTo){
	     $('#widgetFieldDateRange').get(0).innerHTML = dateFrom +' - '+dateTo;
 }
  
  function checkTimeFrameSelection(){
	  if (($('#timeFiltertimeRemain').attr("checked") == "checked") || timeFilter) {
		  return true;
	  } 
	  return false;
  }
  
  function switchTimeFilter() {
  	if (document.getElementById('timeFiltertimeRemain').checked) {
  		$('#timeFiltertimeOnly').removeAttr('checked');
  		$('#timeFiltertimeRemain').attr('checked','checked');
  		timeFilter = true;
  	} else {
  		$('#timeFiltertimeRemain').removeAttr('checked');
  		$('#timeFiltertimeOnly').attr('checked','checked');
  		timeFilter = false;
  	}
  }